﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;

namespace LQKJ.K3.CZXT.Pluglus
{
    [Description("加载设置费用"), HotUpdate]
    public class LQKJ_Setupfeesschedule_Edit : AbstractDynamicFormPlugIn
    {
        public override void AfterBindData(EventArgs e)
        {
            base.AfterBindData(e);

            SetF_BHR_BCGLJE(this.Context);
        }
        public override void DataChanged(DataChangedEventArgs e)
        {
            base.DataChanged(e);

            switch (e.Field.Key)
            {
                case "":  //收款条件
                    SetF_BHR_BCGLJE(this.Context);
                    break;

            }
        }
        private void SetF_BHR_BCGLJE(Context ctx)
        {
            List<DataRow> FilterValues = this.View.OpenParameter.GetCustomParameter("listData") as List<DataRow>;

            string StartDate = this.View.OpenParameter.GetCustomParameter("F_LQKJ_StartDate") as string;
            string F_LQKJ_StartDate = string.Empty;
            DateTime parsedDates;
            if (DateTime.TryParse(StartDate, out parsedDates))
            {
                // 格式化日期为 "yyyy/MM/dd" 格式
                F_LQKJ_StartDate = parsedDates.ToString("yyyy/MM/dd");
            }
            if(FilterValues.Count == 1)
            {
                string F_LQKJ_FDate = string.Empty;
                if (FilterValues[0]["F_LQKJ_FDate"].ToString() == null || FilterValues[0]["F_LQKJ_FDate"].ToString() == "")
                {
                    F_LQKJ_FDate = F_LQKJ_StartDate;
                }
                else
                {
                    F_LQKJ_FDate = Convert.ToString(FilterValues[0]["F_LQKJ_FDate"]);
                }
                string sql = $@"/*dialect*/SELECT * FROM T_LQKJ_CZexpenses WHERE F_LQKJ_FDATE='{F_LQKJ_FDate}' AND F_LQKJ_ORGID='{Convert.ToString(FilterValues[0]["FSTOCKORGID"])}' AND F_LQKJ_WAREHOUSE='{ Convert.ToString(FilterValues[0]["FSTOCKID"])}' AND F_LQKJ_FMATERIALID='{ Convert.ToString(FilterValues[0]["FMATERIALNUMBER"])}'";
                DynamicObjectCollection dynamics = DBUtils.ExecuteDynamicObject(Context, sql);
                if (dynamics.Count > 0)
                {
                    this.View.Model.SetValue("F_LQKJ_Scanfee", Convert.ToString(dynamics[0]["F_LQKJ_Scanfee"]));
                    this.View.Model.SetValue("F_LQKJ_JDchannelfee", Convert.ToString(dynamics[0]["F_LQKJ_JDchannelfee"]));
                    this.View.Model.SetValue("F_LQKJ_Breturnfees", Convert.ToString(dynamics[0]["F_LQKJ_Breturnfees"]));
                    this.View.Model.SetValue("F_LQKJ_Specialloading", Convert.ToString(dynamics[0]["F_LQKJ_Specialloading"]));
                    this.View.Model.SetValue("F_LQKJ_Inspectionfee", Convert.ToString(dynamics[0]["F_LQKJ_Inspectionfee"]));
                    this.View.Model.SetValue("F_LQKJ_Wdbczce", Convert.ToString(dynamics[0]["F_LQKJ_Wdbczce"]));
                }
                this.View.UpdateView("F_LQKJ_Scanfee"); // 更新视图
                this.View.UpdateView("F_LQKJ_JDchannelfee");
                this.View.UpdateView("F_LQKJ_Breturnfees");
                this.View.UpdateView("F_LQKJ_Specialloading");
                this.View.UpdateView("F_LQKJ_Inspectionfee");
                this.View.UpdateView("F_LQKJ_Wdbczce");
            }
        }
    }
}
