﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Kingdee.BOS;
using Kingdee.BOS.App.Core;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Contracts;
using Kingdee.BOS.Contracts.Report;
using Kingdee.BOS.Core;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Core.SqlBuilder;
using Kingdee.BOS.Model.ReportFilter;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Serialization;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using Kingdee.K3.FIN.App.Core;
using Kingdee.BOS.App;
using System.Transactions;

namespace LQKJ.K3.CZXT.Pluglus
{
    [Description("仓租汇总报表"), HotUpdate]
    public class WarehouseRentReport : SysReportBaseService
    {
        string TableName;
        string tmpTableName = string.Empty;
        private static Dictionary<string, string> tempdbs = new Dictionary<string, string>();
        // 定义一个空的字符串变量 tmpRptTbl，用来存储临时报告表的相关信息
        string tmpRptTbl = string.Empty;
        // 定义一个列表，保存 CreateTmpTableZD 类型的对象，该类型可能用于存储一些临时表的定义
        List<CreateTmpTableZD> zds = new List<CreateTmpTableZD>();
        public override void Initialize()
        {
            //删除物料收发明细表存储数据表
            //string sqlDROP = $@"/*dialect*/DROP TABLE CreditStatus";
            //DBUtils.ExecuteDynamicObject(this.Context, sqlDROP);
            string checkTableSql = @"SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'CreditStatus'";
            var result = DBUtils.ExecuteDynamicObject(this.Context, checkTableSql);
            // 检查 result 是否为空，并获取 count 值
            if (result != null && result.Count > 0)
            {
                var firstRow = result[0];  // 获取结果集中的第一行
                int tableCount = firstRow["Property0"] != null ? Convert.ToInt32(firstRow["Property0"]) : 0;
                // 如果表存在，则删除
                if (tableCount > 0)
                {
                    string sqlDROP = @"DROP TABLE CreditStatus";
                    DBUtils.ExecuteDynamicObject(this.Context, sqlDROP);
                }
            }
            // 简单账表类型：普通、树形、分页
            this.ReportProperty.ReportType = ReportType.REPORTTYPE_NORMAL;
            //通过插件创建
            this.IsCreateTempTableByPlugin = false;
            //是否分组汇总
            this.ReportProperty.IsGroupSummary = true;
            // 调用基类的 Initialize 方法，确保基类的初始化逻辑得以执行
            base.Initialize();
        }
        // 定义一个方法 GetBaseDataNameValue，输入参数为 DynamicObjectCollection 类型的 dyobj。
        // 返回类型为字符串，用于根据 dyobj 中的元素提取并拼接相关的名称值。
        private string GetBaseDataNameValue(DynamicObjectCollection dyobj)
        {
            // 初始化一个空字符串变量 name，用于存储拼接的结果
            string name = "";
            // 遍历 dyobj 中的每一个 DynamicObject 对象
            foreach (DynamicObject dynbj in dyobj)
            {
                // 检查 dynbj 是否为 null，或者 dynbj 对象中是否没有名为 "Name" 的属性
                if (dynbj != null || !dynbj.DynamicObjectType.Properties.Contains("Name"))
                {
                    // 从 dynbj 中获取第二个元素（假设是 DynamicObject 类型），并存储到 dynbj2 变量中
                    DynamicObject dynbj2 = (DynamicObject)dynbj[2];
                    // 将 dynbj2 中 "Number" 属性的值转换为字符串，并拼接到 name 变量中
                    // 拼接时，使用逗号分隔字符串
                    name = name + ",'" + dynbj2["Number"].ToString() + "'";
                }
            }
            // 如果 name 字符串的长度大于 0，表示拼接了数据
            // 则从 name 字符串的第二个字符开始截取，去掉开头的多余逗号
            if (name.Length > 0)
            {
                name = name.Substring(1, name.Length - 1);
            }
            // 返回最终拼接后的 name 字符串
            return name;
        }
        private string GetFilterWhere(IRptParams filter)
        {
            DynamicObject customFilter = filter.FilterParameter.CustomFilter;
            StringBuilder strwhere = new StringBuilder();
            //仓库
            string org = this.GetBaseDataNameValue(customFilter["F_LQKJ_Stocks"] as DynamicObjectCollection);
            string ywzzb = string.IsNullOrWhiteSpace(org)
                ? " " : string.Format(" AND CKBM.FNUMBER IN ({0}) ", org);
            strwhere.AppendLine(ywzzb);
            //物料
            string baseSuppName = this.GetBaseDataNameValue(customFilter["F_LQKJ_Materials"] as DynamicObjectCollection);
            string SuppName = string.IsNullOrWhiteSpace(baseSuppName)
                ? " " : string.Format(" AND W.FNUMBER IN ({0}) ", baseSuppName);
            strwhere.AppendLine(SuppName);

            string text2 = string.IsNullOrWhiteSpace(filter.FilterParameter.FilterString) ? " " : " AND " + filter.FilterParameter.FilterString.Replace("{ts", "").Replace("}", "");
            strwhere.AppendLine(text2);

            return strwhere.ToString();
        }
        //构建单据select 和字段
        protected override string BuilderSelectFieldSQL(IRptParams filter)
        {
            string Filter = GetFilterWhere(filter);
            //// 创建组织信息列表
            List<string> errorMessagest = new List<string>();
            // 创建一个 StringBuilder 来构建 SQL 语句中的 WHERE 子句
            StringBuilder strwhere = new StringBuilder();
            // 获取用户自定义的过滤参数（例如：开始日期、结束日期）
            DynamicObject customFilter = filter.FilterParameter.CustomFilter;
            // 获取自定义过滤器中的组织ID
            // 如果自定义过滤器没有组织ID，则默认为空字符串
            //string F_LQKJ_OrgId = Convert.ToString(customFilter["F_LQKJ_OrgId_Id"]);//组织ID
            DynamicObjectCollection F_LQKJ_OrgIdS = customFilter["F_LQKJ_OrgIds"] as DynamicObjectCollection;
            string F_LQKJ_OrgId = "";
            if (F_LQKJ_OrgIdS.Count > 0)
            {
                foreach (var item in F_LQKJ_OrgIdS)
                {
                    errorMessagest.Add(Convert.ToString(item["F_LQKJ_OrgIds_Id"]));
                }
                F_LQKJ_OrgId += string.Join(",", errorMessagest);
            }
            string F_LQKJ_StartDate = "";
            string F_LQKJ_EndDate = "";
            // 获取自定义过滤器中的开始日期和结束日期
            // 如果自定义过滤器没有设置日期，则默认为空字符串
            if (customFilter["F_LQKJ_Datemonth"] != null)
            {
                // 获取 F_LQKJ_Datemonth 字段的日期字符串
                string dateMonthStr = customFilter["F_LQKJ_Datemonth"]?.ToString()?.Trim(); // 去除首尾空格
                DateTime startDateS = DateTime.MinValue;
                DateTime endDateS = DateTime.MinValue;

                if (!string.IsNullOrEmpty(dateMonthStr))
                {
                    try
                    {
                        // 解析为 DateTime 类型
                        DateTime dateTime = DateTime.ParseExact(dateMonthStr, "yyyy-MM-dd HH:mm:ss", null);

                        // 获取该月的第一天
                        startDateS = new DateTime(dateTime.Year, dateTime.Month, 1); // 使用该年份和月份的第一天

                        // 获取该月的最后一天
                        endDateS = startDateS.AddMonths(1).AddDays(-1); // 下一月减去一天即为当前月的最后一天

                        // 格式化为字符串
                        F_LQKJ_StartDate = startDateS.ToString("yyyy-MM-dd"); // 起始日期
                        F_LQKJ_EndDate = endDateS.ToString("yyyy-MM-dd");     // 截止日期
                    }
                    catch (FormatException)
                    {
                        // 如果格式不正确，处理错误（例如记录日志，或给出默认值）
                        Console.WriteLine("日期格式无效: " + dateMonthStr);
                    }
                }
                else
                {
                    Console.WriteLine("日期字符串无效或格式不匹配");
                }
            }
            else if (customFilter["F_LQKJ_StartDate"] != null || customFilter["F_LQKJ_EndDate"] != null)
            {
                if(customFilter["F_LQKJ_StartDate"] != null && customFilter["F_LQKJ_EndDate"] != null)
                {
                    F_LQKJ_StartDate = (customFilter["F_LQKJ_StartDate"] == null) ? string.Empty : Convert.ToDateTime(customFilter["F_LQKJ_StartDate"]).ToString("yyyy-MM-dd");//起始日期
                    F_LQKJ_EndDate = (customFilter["F_LQKJ_EndDate"] == null) ? string.Empty : Convert.ToDateTime(customFilter["F_LQKJ_EndDate"]).ToString("yyyy-MM-dd");//截止日期
                }
                else if(customFilter["F_LQKJ_StartDate"] != null && customFilter["F_LQKJ_EndDate"] == null)
                {
                    F_LQKJ_StartDate = (customFilter["F_LQKJ_StartDate"] == null) ? string.Empty : Convert.ToDateTime(customFilter["F_LQKJ_StartDate"]).ToString("yyyy-MM-dd");//起始日期
                    F_LQKJ_EndDate = (customFilter["F_LQKJ_StartDate"] == null) ? string.Empty : Convert.ToDateTime(customFilter["F_LQKJ_StartDate"]).ToString("yyyy-MM-dd");//起始日期
                }
                else if (customFilter["F_LQKJ_StartDate"] == null && customFilter["F_LQKJ_EndDate"] != null)
                {
                    F_LQKJ_StartDate = (customFilter["F_LQKJ_EndDate"] == null) ? string.Empty : Convert.ToDateTime(customFilter["F_LQKJ_EndDate"]).ToString("yyyy-MM-dd");//截止日期
                    F_LQKJ_EndDate = (customFilter["F_LQKJ_EndDate"] == null) ? string.Empty : Convert.ToDateTime(customFilter["F_LQKJ_EndDate"]).ToString("yyyy-MM-dd");//截止日期
                }
            }
            // 如果截止日期超过了当前日期，设置为当前日期
            if (!string.IsNullOrEmpty(F_LQKJ_EndDate))
            {
                DateTime endDateD = Convert.ToDateTime(F_LQKJ_EndDate);
                if (endDateD.Date > DateTime.Today)
                {
                    F_LQKJ_EndDate = DateTime.Today.ToString("yyyy-MM-dd");
                }
            }
            //搜索物料收发明细表的自定义方案查询语句（仓租报表专用）
            string sqlBB = string.Format(@"/*dialect*/SELECT FSCHEMEID FROM T_BAS_FILTERSCHEME where FFORMID='STK_StockDetailRpt' and FSCHEMENAME='仓租报表专用'");
            string schemeId = AppServiceContext.DBService.ExecuteScalar<string>(Context, sqlBB, "");//获取过滤条件框的方案
            if (string.IsNullOrWhiteSpace(schemeId))
            {
                throw new Exception("物料收发明细表没有专用过滤方案！");
            }
            // 创建一个唯一的临时表名 tmpTableName
            string tmpTableName = AppServiceContext.DBService.CreateTemporaryTableName(base.Context);
            //创建一个空的临时表 tmpTableName
            CreateTmpTable(tmpTableName);
            DataTable receBillTable = new DataTable();
            receBillTable.TableName = tmpTableName;
            receBillTable.Columns.Add("FDate", typeof(DateTime));//日期
            receBillTable.Columns.Add("FSTOCKORGID", typeof(int));//组织ID
            receBillTable.Columns.Add("FSTOCKID", typeof(int));//仓库ID
            receBillTable.Columns.Add("FMATERIALID", typeof(int));//物料ID
            //receBillTable.Columns.Add("FSTOCKUNITID", typeof(int));//库存单位ID
            //receBillTable.Columns.Add("FOWNERTYPENAME", typeof(string));//货主类型
            receBillTable.Columns.Add("FSTOCKQCQTY", typeof(decimal));//库存合格数量
            receBillTable.Columns.Add("FSTOCKINQTY", typeof(decimal));//入库数量
            receBillTable.Columns.Add("FSTOCKOUTQTY", typeof(decimal));//出库数量
            receBillTable.Columns.Add("FSTOCKJCQTY", typeof(decimal));//结存数量
            receBillTable.BeginInit();
            // 创建一个唯一的临时表名 tmpTableName
            string tmpTableNameS = AppServiceContext.DBService.CreateTemporaryTableName(base.Context);
            //创建一个空的临时表 tmpTableName
            CreateTmpTableS(tmpTableNameS);
            DataTable receBillTableS = new DataTable();
            receBillTableS.TableName = tmpTableNameS;
            receBillTableS.Columns.Add("FSEQ", typeof(int));//序号
            receBillTableS.Columns.Add("FDate", typeof(DateTime));//日期
            receBillTableS.Columns.Add("FSTOCKORGID", typeof(int));//组织ID
            receBillTableS.Columns.Add("FSTOCKID", typeof(int));//仓库ID
            receBillTableS.Columns.Add("FMATERIALID", typeof(int));//物料ID
            //receBillTableS.Columns.Add("FSTOCKUNITID", typeof(int));//库存单位ID
            //receBillTableS.Columns.Add("FOWNERTYPENAME", typeof(string));//货主类型
            receBillTableS.Columns.Add("FSTOCKQCQTY", typeof(decimal));//库存合格数量
            receBillTableS.Columns.Add("FSTOCKINQTY", typeof(decimal));//入库数量
            receBillTableS.Columns.Add("FSTOCKOUTQTY", typeof(decimal));//出库数量
            receBillTableS.Columns.Add("FSTOCKJCQTY", typeof(decimal));//结存数量
            receBillTableS.BeginInit();
            DataTable dataTable = GetReportData(Context, "STK_StockDetailRpt", "STK_StockDetailFilter", schemeId, F_LQKJ_OrgId, F_LQKJ_StartDate, F_LQKJ_EndDate, 0);
            int sequenceNumber = 1;  // 序号从1开始，或者根据你的需求设置
            // DataTable 有数据
            if (dataTable != null && dataTable.Rows.Count > 0)
            {
                //获取创建的临时表的值，可以在这里处理值过滤
                foreach (DataRow item in dataTable.Rows)
                {
                    DataRow newRow = receBillTableS.NewRow();
                    // 设置自增长的序号
                    newRow["FSEQ"] = sequenceNumber++;
                    newRow["FDate"] = item["FDate"];
                    newRow["FSTOCKORGID"] = item["FSTOCKORGID"];
                    newRow["FSTOCKID"] = item["FSTOCKID"];
                    newRow["FMATERIALID"] = item["FMATERIALID"];
                    // 使用没有日期的记录的值填充
                    //newRow["FSTOCKUNITID"] = item["FSTOCKUNITID"];
                    //newRow["FOWNERTYPENAME"] = item["FOWNERTYPENAME"];
                    newRow["FSTOCKQCQTY"] = item["FSTOCKQCQTY"];
                    newRow["FSTOCKINQTY"] = item["FSTOCKINQTY"];
                    newRow["FSTOCKOUTQTY"] = item["FSTOCKOUTQTY"];
                    newRow["FSTOCKJCQTY"] = item["FSTOCKJCQTY"];
                    receBillTableS.Rows.Add(newRow);
                }
                receBillTableS.EndInit();
                Kingdee.BOS.App.Data.DBUtils.BulkInserts(this.Context, receBillTableS);
                string sqlsa = ($@"/*dialect*/SELECT * FROM (SELECT MIN(T1.FSEQ) AS FSEQ,T1.FDate--业务日期
                            ,T1.FSTOCKORGID--库存组织
                            ,T1.FSTOCKID--仓库名称
                            ,T1.FMATERIALID--物料编码
                            ,SUM(CAST(T1.FSTOCKQCQTY AS DECIMAL(18, 4))) AS FSTOCKQCQTY--期初&数量(库存)
                            ,SUM(CAST(T1.FSTOCKINQTY AS DECIMAL(18, 4))) AS FSTOCKINQTY--收入&数量(库存)
                            ,SUM(CAST(T1.FSTOCKOUTQTY AS DECIMAL(18, 4))) AS FSTOCKOUTQTY--发出&数量(库存)
                            ,SUM(CAST(T1.FSTOCKJCQTY AS DECIMAL(18, 4))) AS FSTOCKJCQTY--结存&数量(库存)
                            FROM {receBillTableS} T1
                            LEFT JOIN T_BD_MATERIAL W ON T1.FMATERIALID=W.FMATERIALID
                            LEFT JOIN T_BD_STOCK CKBM ON T1.FSTOCKID=CKBM.FSTOCKID
							WHERE T1.FDate<>'' {Filter}
                            GROUP BY T1.FSTOCKORGID,T1.FSTOCKID,T1.FMATERIALID,T1.FDate
							UNION ALL
							SELECT T1.FSEQ,T1.FDate--业务日期
                            ,T1.FSTOCKORGID--库存组织
                            ,T1.FSTOCKID--仓库名称
                            ,T1.FMATERIALID--物料编码
							,T1.FSTOCKQCQTY,T1.FSTOCKINQTY,T1.FSTOCKOUTQTY,T1.FSTOCKJCQTY FROM {receBillTableS} T1
                            LEFT JOIN T_BD_MATERIAL W ON T1.FMATERIALID=W.FMATERIALID
                            LEFT JOIN T_BD_STOCK CKBM ON T1.FSTOCKID=CKBM.FSTOCKID
							WHERE (T1.FDate IS NULL OR T1.FDate = '' ) {Filter}
							) t1
							ORDER BY FSEQ");
                DataTable dataTablesa = DBUtils.ExecuteDataSet(this.Context, sqlsa).Tables[0];
                var filteredData = dataTablesa.AsEnumerable()
                    .Where(row => row["FDate"] != DBNull.Value && !string.IsNullOrWhiteSpace(row["FDate"].ToString()))
                    .ToList();
                Dictionary<string, List<string>> keyValuePairs = new Dictionary<string, List<string>>();
                foreach (var item in filteredData)
                {
                    string key = item["FSTOCKORGID"].ToString() + item["FSTOCKID"].ToString() + item["FMATERIALID"].ToString();
                    if (keyValuePairs.ContainsKey(key))
                    {
                        keyValuePairs[key].Add(item["FDate"].ToString());
                    }
                    else
                    {
                        keyValuePairs.Add(key, new List<string>() { item["FDate"].ToString() });
                    }

                }
                string startDate = string.Empty;
                string endDate = string.Empty;

                decimal jcsl = 0;
                #region
                if (F_LQKJ_StartDate != F_LQKJ_EndDate)
                {
                    foreach (DataRow item in dataTablesa.Rows)
                    {
                        //decimal jcsl = 0;
                        DataRow data = item;//需要插入的数据
                        string keyb = item["FSTOCKORGID"].ToString() + item["FSTOCKID"].ToString() + item["FMATERIALID"].ToString();
                        List<string> dateList = new List<string>();
                        keyValuePairs.TryGetValue(keyb, out dateList);
                        if (dateList == null)
                        {
                            startDate = F_LQKJ_StartDate;
                            endDate = F_LQKJ_EndDate;
                            //data
                            TimeSpan difference = Convert.ToDateTime(endDate) - Convert.ToDateTime(startDate);
                            for (int i = 0; i <= difference.Days; i++) //6是开始日期减结束日期startDate-endDate
                            {
                                DataRow newRow = receBillTable.NewRow();
                                if (i == 0)
                                {
                                    newRow["FDate"] = Convert.ToDateTime(startDate);
                                }
                                else
                                {
                                    newRow["FDate"] = Convert.ToDateTime(startDate).AddDays(i);//需要加i天
                                }
                                newRow["FSTOCKORGID"] = data["FSTOCKORGID"];
                                newRow["FSTOCKID"] = data["FSTOCKID"];
                                newRow["FMATERIALID"] = data["FMATERIALID"];
                                newRow["FSTOCKQCQTY"] = data["FSTOCKQCQTY"];
                                newRow["FSTOCKINQTY"] = data["FSTOCKINQTY"];
                                newRow["FSTOCKOUTQTY"] = data["FSTOCKOUTQTY"];
                                newRow["FSTOCKJCQTY"] = Convert.ToDecimal(data["FSTOCKQCQTY"]) + Convert.ToDecimal(data["FSTOCKINQTY"]) - Convert.ToDecimal(data["FSTOCKOUTQTY"]);
                                //jcsl = Convert.ToDecimal(data["FSTOCKQCQTY"]) + Convert.ToDecimal(data["FSTOCKINQTY"]) - Convert.ToDecimal(data["FSTOCKOUTQTY"]);
                                receBillTable.Rows.Add(newRow);
                            }

                        }
                        else
                        {
                            if (item["FDate"].IsNullOrEmptyOrWhiteSpace())
                            {
                                startDate = F_LQKJ_StartDate;
                                endDate = dateList[0];//需要减去一天
                                                      //data
                                TimeSpan difference = Convert.ToDateTime(endDate).AddDays(-1) - Convert.ToDateTime(startDate);
                                for (int i = 0; i <= difference.Days; i++) //6是开始日期减结束日期startDate-endDate
                                {
                                    DataRow newRow = receBillTable.NewRow();
                                    if (i == 0)
                                    {
                                        newRow["FDate"] = Convert.ToDateTime(startDate);
                                    }
                                    else
                                    {
                                        newRow["FDate"] = Convert.ToDateTime(startDate).AddDays(i);//需要加i天
                                    }
                                    newRow["FSTOCKORGID"] = data["FSTOCKORGID"];
                                    newRow["FSTOCKID"] = data["FSTOCKID"];
                                    newRow["FMATERIALID"] = data["FMATERIALID"];
                                    newRow["FSTOCKQCQTY"] = data["FSTOCKQCQTY"];
                                    newRow["FSTOCKINQTY"] = data["FSTOCKINQTY"];
                                    newRow["FSTOCKOUTQTY"] = data["FSTOCKOUTQTY"];
                                    receBillTable.Rows.Add(newRow);
                                }

                            }
                            else
                            {
                                startDate = item["FDate"].ToString();
                                // 找到比 a 日期大的下一个日期
                                var nextDate = dateList
                                    .Select(date => DateTime.Parse(date)) // 转换为 DateTime 类型
                                    .Where(date => date > Convert.ToDateTime(item["FDate"])) // 过滤出大于 a 的日期
                                    .OrderBy(date => date) // 按日期排序
                                    .FirstOrDefault(); // 获取第一个（最小的）符合条件的日期
                                if (nextDate != default(DateTime))
                                {
                                    endDate = nextDate.AddDays(-1).ToString();//需要减去一天
                                }
                                else
                                {
                                    endDate = F_LQKJ_EndDate;
                                }
                                TimeSpan difference = Convert.ToDateTime(endDate) - Convert.ToDateTime(startDate);
                                for (int i = 0; i <= difference.Days; i++) //6是开始日期减结束日期startDate-endDate
                                {
                                    DataRow newRow = receBillTable.NewRow();
                                    if (i == 0)
                                    {
                                        string FSTOCKORGID = Convert.ToString(receBillTable.Rows[receBillTable.Rows.Count - 1]["FSTOCKORGID"]);
                                        string FSTOCKID = Convert.ToString(receBillTable.Rows[receBillTable.Rows.Count - 1]["FSTOCKID"]);
                                        string FMATERIALID = Convert.ToString(receBillTable.Rows[receBillTable.Rows.Count - 1]["FMATERIALID"]);
                                        if (FSTOCKORGID == data["FSTOCKORGID"].ToString() && FSTOCKID == data["FSTOCKID"].ToString() && FMATERIALID == data["FMATERIALID"].ToString())
                                        {
                                            jcsl = Convert.ToDecimal(receBillTable.Rows[receBillTable.Rows.Count - 1]["FSTOCKQCQTY"]) + Convert.ToDecimal(receBillTable.Rows[receBillTable.Rows.Count - 1]["FSTOCKINQTY"]) - Convert.ToDecimal(receBillTable.Rows[receBillTable.Rows.Count - 1]["FSTOCKOUTQTY"]);
                                            newRow["FSTOCKQCQTY"] = jcsl;
                                        }
                                        else
                                        {
                                            jcsl = 0;
                                            newRow["FSTOCKQCQTY"] = data["FSTOCKQCQTY"];
                                        }
                                        newRow["FDate"] = Convert.ToDateTime(startDate);
                                        //newRow["FSTOCKQCQTY"] = jcsl;
                                        newRow["FSTOCKINQTY"] = data["FSTOCKINQTY"];
                                        newRow["FSTOCKOUTQTY"] = data["FSTOCKOUTQTY"];
                                        jcsl = jcsl + Convert.ToDecimal(data["FSTOCKQCQTY"]) + Convert.ToDecimal(data["FSTOCKINQTY"]) - Convert.ToDecimal(data["FSTOCKOUTQTY"]);

                                    }
                                    else
                                    {
                                        newRow["FDate"] = Convert.ToDateTime(startDate).AddDays(i);//需要加i天
                                        newRow["FSTOCKINQTY"] = 0;
                                        newRow["FSTOCKOUTQTY"] = 0;
                                        newRow["FSTOCKQCQTY"] = jcsl;
                                    }
                                    newRow["FSTOCKORGID"] = data["FSTOCKORGID"];
                                    newRow["FSTOCKID"] = data["FSTOCKID"];
                                    newRow["FMATERIALID"] = data["FMATERIALID"];
                                    receBillTable.Rows.Add(newRow);
                                }
                            }
                        }
                    }
                }
                else
                {
                    string sqldate = ($@"/*dialect*/SELECT FSTOCKORGID,FSTOCKID,FMATERIALID,
                                    SUM(CAST(FSTOCKQCQTY AS DECIMAL(18, 4))) AS FSTOCKQCQTY--期初&数量(库存)
                                    ,SUM(CAST(FSTOCKINQTY AS DECIMAL(18, 4))) AS FSTOCKINQTY--收入&数量(库存)
                                    ,SUM(CAST(FSTOCKOUTQTY AS DECIMAL(18, 4))) AS FSTOCKOUTQTY--发出&数量(库存)
                                    ,SUM(CAST(FSTOCKQCQTY AS DECIMAL(18, 4))) + SUM(CAST(FSTOCKINQTY AS DECIMAL(18, 4))) - SUM(CAST(FSTOCKOUTQTY AS DECIMAL(18, 4))) AS FSTOCKJCQTY--结存&数量(库存)
                                    FROM {tmpTableNameS}
                                    GROUP BY FSTOCKORGID,FSTOCKID,FMATERIALID");
                    DataTable dynamicobjs = DBUtils.ExecuteDataSet(this.Context, sqldate).Tables[0];
                    foreach (DataRow item in dynamicobjs.Rows)
                    {
                        DataRow newRow = receBillTable.NewRow();
                        newRow["FDate"] = F_LQKJ_StartDate;
                        newRow["FSTOCKORGID"] = item["FSTOCKORGID"];
                        newRow["FSTOCKID"] = item["FSTOCKID"];
                        newRow["FMATERIALID"] = item["FMATERIALID"];
                        newRow["FSTOCKQCQTY"] = item["FSTOCKQCQTY"];
                        newRow["FSTOCKINQTY"] = item["FSTOCKINQTY"];
                        newRow["FSTOCKOUTQTY"] = item["FSTOCKOUTQTY"];
                        receBillTable.Rows.Add(newRow);
                    }
                }
                #endregion
            }
            else// DataTable 没有数据
            {
                
            }
            // 结束表初始化
            receBillTable.EndInit();
            // 保存到数据库或进一步处理
            Kingdee.BOS.App.Data.DBUtils.BulkInserts(this.Context, receBillTable);

            // 定义报表字段名的列表 zds 列表将用于记录需要选择的字段及其相关信息（如类型、长度、名称等）
            zds = new List<CreateTmpTableZD>();
            // 添加多个字段的定义：字段名称、数据类型、长度、中文名称等
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_FDate", type = 4, zdcd = 500, zwName = "业务日期" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_OrgId", type = 2, zdcd = 500, zwName = "库存组织" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_FSTOCKQCQTY", type = 3, zdcd = 4, zwName = "期初数" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_FSTOCKINQTY", type = 3, zdcd = 4, zwName = "入库数" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_FSTOCKOUTQTY", type = 3, zdcd = 4, zwName = "出库数" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_FSTOCKJCQTY", type = 3, zdcd = 4, zwName = "库存数" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Openingvolume", type = 3, zdcd = 4, zwName = "期初体积" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Inboundvolume", type = 3, zdcd = 4, zwName = "入库体积" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Outboundvolume", type = 3, zdcd = 4, zwName = "出库体积" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Inventoryvolume", type = 3, zdcd = 4, zwName = "库存体积" });

            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Warehouse", type = 3, zdcd = 4, zwName = "仓租" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Enterfee", type = 3, zdcd = 4, zwName = "进仓费" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Warehousingfee", type = 3, zdcd = 4, zwName = "出仓费" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Cargosortingfee", type = 3, zdcd = 4, zwName = "货物分拣费" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Scanfee", type = 3, zdcd = 4, zwName = "一物一码扫码出库费" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_JDchannelfee", type = 3, zdcd = 4, zwName = "京东渠道贴标费" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Breturnfees", type = 3, zdcd = 4, zwName = "B2B退货挑选费" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Specialloading", type = 3, zdcd = 4, zwName = "特殊装货" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Inspectionfee", type = 3, zdcd = 4, zwName = "检查及包装费" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Wdbczce", type = 3, zdcd = 4, zwName = "未达标仓租差额" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Totalcosts", type = 3, zdcd = 4, zwName = "费用合计" });
            try
            {
                // 创建临时表格用于执行 SQL 查询
                DataTable db = CreateTmpTable();
                db.BeginInit();// 开始初始化数据表
                // 构建最终的 SQL 查询语句
                string sql = string.Format(@"/*dialect*/SELECT REPLACE(CONVERT(VARCHAR(10), T1.FDate, 111), '-', '/') AS F_LQKJ_FDate,T1.FNUMBER,Z.FNUMBER AS F_LQKJ_OrgId --组织
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, T1.FSTOCKQCQTY), '0.####'), '0') AS F_LQKJ_FSTOCKQCQTY--期初数
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, T2.FSTOCKINQTY), '0.####'), '0') AS F_LQKJ_FSTOCKINQTY--入库数
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, T2.FSTOCKOUTQTY), '0.####'), '0') AS F_LQKJ_FSTOCKOUTQTY--出库数
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, T1.FSTOCKQCQTY+T2.FSTOCKINQTY-T2.FSTOCKOUTQTY), '0.####'), '0') AS F_LQKJ_FSTOCKJCQTY--库存数
                                            ,ISNULL(FORMAT(T1.FSTOCKQCQTY * CASE WHEN T1.FVOLUME = 0 THEN 1 ELSE T1.FVOLUME END, '0.####'), '0') AS F_LQKJ_Openingvolume--期初体积
                                            ,ISNULL(FORMAT(T2.FSTOCKINQTY * CASE WHEN T1.FVOLUME = 0 THEN 1 ELSE T1.FVOLUME END, '0.####'), '0') AS F_LQKJ_Inboundvolume--入库体积
                                            ,ISNULL(FORMAT(T2.FSTOCKOUTQTY * CASE WHEN T1.FVOLUME = 0 THEN 1 ELSE T1.FVOLUME END, '0.####'), '0') AS F_LQKJ_Outboundvolume--出库体积
                                            ,ISNULL(FORMAT(T1.FSTOCKJCQTY * CASE WHEN T1.FVOLUME = 0 THEN 1 ELSE T1.FVOLUME END, '0.####'), '0') AS F_LQKJ_Inventoryvolume--库存体积
                                            ,ISNULL(FORMAT(T1.F_ORA_DECIMAL_QTR * (T1.FSTOCKJCQTY * CASE WHEN T1.FVOLUME = 0 THEN 1 ELSE T1.FVOLUME END), '0.####'), '0') AS F_LQKJ_Warehouse--仓租 
                                            ,ISNULL(FORMAT(CS.F_LQKJ_Unloadingfee * (T1.FSTOCKJCQTY * CASE WHEN T1.FVOLUME = 0 THEN 1 ELSE T1.FVOLUME END), '0.####'), '0') AS F_LQKJ_Enterfee--进仓费
                                            ,ISNULL(FORMAT(CS.F_LQKJ_Loadingfee * (T2.FSTOCKOUTQTY * CASE WHEN T1.FVOLUME = 0 THEN 1 ELSE T1.FVOLUME END), '0.####'), '0') AS  F_LQKJ_Warehousingfee--出仓费
                                            ,ISNULL(FORMAT(CS.F_LQKJ_Sortingfees * (T1.FSTOCKJCQTY * CASE WHEN T1.FVOLUME = 0 THEN 1 ELSE T1.FVOLUME END), '0.####'), '0') AS F_LQKJ_Cargosortingfee--货物分拣费
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, SS.F_LQKJ_Scanfee), '0.####'), '0') AS F_LQKJ_Scanfee--一物一码扫码出库费
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, SS.F_LQKJ_JDchannelfee), '0.####'), '0') AS F_LQKJ_JDchannelfee--京东渠道贴标费
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, SS.F_LQKJ_Breturnfees), '0.####'), '0') AS F_LQKJ_Breturnfees --B2B退货挑选费
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, SS.F_LQKJ_Specialloading), '0.####'), '0') AS F_LQKJ_Specialloading --特殊装货
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, SS.F_LQKJ_Inspectionfee), '0.####'), '0') AS F_LQKJ_Inspectionfee --检查及包装费
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, SS.F_LQKJ_Wdbczce), '0.####'), '0') AS F_LQKJ_Wdbczce --未达标仓租差额
                                            ,ISNULL(FORMAT((T1.F_ORA_DECIMAL_QTR * (T1.FSTOCKJCQTY * CASE WHEN T1.FVOLUME = 0 THEN 1 ELSE T1.FVOLUME END)) + (CS.F_LQKJ_Unloadingfee * (T1.FSTOCKJCQTY * CASE WHEN T1.FVOLUME = 0 THEN 1 ELSE T1.FVOLUME END))
                                            + (CS.F_LQKJ_Loadingfee * (T2.FSTOCKOUTQTY * CASE WHEN T1.FVOLUME = 0 THEN 1 ELSE T1.FVOLUME END)) + (CS.F_LQKJ_Sortingfees * (T1.FSTOCKJCQTY * CASE WHEN T1.FVOLUME = 0 THEN 1 ELSE T1.FVOLUME END))
                                            + SS.F_LQKJ_Scanfee + SS.F_LQKJ_JDchannelfee + SS.F_LQKJ_Breturnfees + SS.F_LQKJ_Specialloading + SS.F_LQKJ_Inspectionfee + SS.F_LQKJ_Wdbczce, '0.####'), '0') AS F_LQKJ_Totalcosts--费用合计
                                            FROM(SELECT FDate, FNUMBER,
                                                SUM(CAST(FSTOCKQCQTY AS DECIMAL(18, 4))) AS FSTOCKQCQTY, -- 期初数量(库存)的汇总
	                                                SUM(CAST(FSTOCKJCQTY AS DECIMAL(18, 4))) AS FSTOCKJCQTY,  -- 结存数量(库存)的汇总
													SUM(CAST(FVOLUME AS DECIMAL(18, 4))) AS FVOLUME,  --体积
													SUM(CAST(F_ORA_DECIMAL_QTR AS DECIMAL(18, 4))) AS F_ORA_DECIMAL_QTR  --仓租单价
                                            FROM(SELECT T1.FDate, -- 日期
                                                    Z.FNUMBER, --组织
                                                    T1.FMATERIALID, -- 物料编码
                                                    T1.FSTOCKID, -- 仓库
                                                    SUM(CAST(T1.FSTOCKQCQTY AS DECIMAL(18, 4))) AS FSTOCKQCQTY, -- 期初数量(库存)的汇总
	                                                SUM(CAST(T1.FSTOCKJCQTY AS DECIMAL(18, 4))) AS FSTOCKJCQTY,  -- 结存数量(库存)的汇总
													SUM(CAST(JB.FVOLUME AS DECIMAL(18, 4))) AS FVOLUME,  -- 体积
													SUM(CAST(W.F_ORA_DECIMAL_QTR AS DECIMAL(18, 4))) AS F_ORA_DECIMAL_QTR  -- 仓租单价
                                            FROM {0} T1
                                            LEFT JOIN T_ORG_ORGANIZATIONS Z ON T1.FSTOCKORGID=Z.FORGID --组织表
											LEFT JOIN t_BD_MaterialBase JB ON JB.FMATERIALID=T1.FMATERIALID
											LEFT JOIN T_BD_MATERIAL W ON T1.FMATERIALID=W.FMATERIALID
                                            GROUP BY T1.FDate, T1.FMATERIALID, T1.FSTOCKID,Z.FNUMBER) T1
                                            GROUP BY FDate, FNUMBER) T1 
                                            LEFT JOIN (SELECT T1.FDate, -- 日期
                                                    Z.FNUMBER, --组织
                                                    SUM(CAST(T1.FSTOCKINQTY AS DECIMAL(18, 4))) AS FSTOCKINQTY, -- 收入&数量(库存)的汇总
	                                                SUM(CAST(T1.FSTOCKOUTQTY AS DECIMAL(18, 4))) AS FSTOCKOUTQTY  -- 发出&数量(库存)的汇总
                                            FROM {0} T1
                                            LEFT JOIN T_ORG_ORGANIZATIONS Z ON T1.FSTOCKORGID=Z.FORGID --组织表
                                            GROUP BY T1.FDate,Z.FNUMBER)T2 ON T1.FDate=T2.FDate AND T1.FNUMBER=T2.FNUMBER
                                            LEFT JOIN LQKJ_SettupParameters CS ON 1=1
                                            LEFT JOIN T_ORG_ORGANIZATIONS Z ON Z.FNUMBER=T1.FNUMBER
                                            LEFT JOIN T_ORG_ORGANIZATIONS_L ZZ ON Z.FORGID=ZZ.FORGID AND ZZ.FLOCALEID=2052
                                            LEFT JOIN(
                                            SELECT F_LQKJ_FDATE,F_LQKJ_ORGID
                                            ,SUM(CAST(F_LQKJ_Scanfee AS DECIMAL(18, 4))) AS F_LQKJ_Scanfee--一物一码扫码出库费
                                            ,SUM(CAST(F_LQKJ_JDchannelfee AS DECIMAL(18, 4))) AS F_LQKJ_JDchannelfee--京东渠道贴标费
                                            ,SUM(CAST(F_LQKJ_Breturnfees AS DECIMAL(18, 4))) AS F_LQKJ_Breturnfees--B2B退货挑选费
                                            ,SUM(CAST(F_LQKJ_Specialloading AS DECIMAL(18, 4))) AS F_LQKJ_Specialloading--特殊装货
                                            ,SUM(CAST(F_LQKJ_Inspectionfee AS DECIMAL(18, 4))) AS F_LQKJ_Inspectionfee--检查及包装费
                                            ,SUM(CAST(F_LQKJ_Wdbczce AS DECIMAL(18, 4))) AS F_LQKJ_Wdbczce--未达标仓租差额
                                            FROM T_LQKJ_CZexpenses
                                            GROUP BY F_LQKJ_FDATE,F_LQKJ_ORGID
                                            )SS ON T1.FDate=SS.F_LQKJ_FDATE AND ZZ.FNAME=SS.F_LQKJ_ORGID", receBillTable);
                // 执行动态SQL查询并获取查询结果
                DynamicObjectCollection dynamics = DBUtils.ExecuteDynamicObject(Context, sql);

                // 创建一个新的列表，用于存储处理结果的字段名
                List<string> dynamic = new List<string>();
                // 遍历动态对象集合中的每一项
                foreach (var item in dynamics)

                {
                    // 创建一个新的 DataRow 用于存储每一条记录
                    DataRow dr = db.NewRow();
                    // 遍历每一个字段定义
                    foreach (var zd in zds)
                    {
                        // 根据字段类型进行数据转换并赋值给 DataRow 中相应的列
                        switch (zd.type)
                        {
                            case 1:// 如果字段类型是整数类型
                                dr[zd.zdName] = Convert.ToInt64(item[zd.zdName]);// 将字段值转换为 long 类型
                                break;
                            case 2:// 如果字段类型是字符串类型
                                dr[zd.zdName] = Convert.ToString(item[zd.zdName]);// 将字段值转换为字符串类型
                                break;
                            case 3:// 如果字段类型是数字类型
                                dr[zd.zdName] = Math.Round(Convert.ToDecimal(item[zd.zdName]), 6); // 将字段值转换为 Decimal 类型并保留6位小数
                                break;
                            case 4:// 如果字段类型是日期类型
                                if (Convert.ToDateTime(item[zd.zdName]) > Convert.ToDateTime("2000-01-01"))
                                    dr[zd.zdName] = Convert.ToString(item[zd.zdName]);// 如果日期值大于 "2000-01-01"，则将其转换为字符串类型
                                break;
                            default:
                                break;
                        }
                    }
                    // 将 DataRow 添加到 DataTable 中
                    db.Rows.Add(dr);
                }
                // 完成 DataTable 初始化
                db.EndInit();
                // 批量插入数据到数据库
                Kingdee.BOS.App.Data.DBUtils.BulkInserts(this.Context, db);
                //AppServiceContext.DBService.DeleteTemporaryTableName(this.Context, new string[] { tmpTableName });//删除临时表
            }
            catch (Exception)
            {
                // 捕获异常并抛出
                throw;
            }
            finally
            {

            }
            // 最终构建一个 SELECT 查询语句，选择所有字段
            string sqlstr = @"select  " + string.Join(",", zds.Select(r => r.zdName));
            return sqlstr;
        }
        // 获取汇总列信息
        public override List<SummaryField> GetSummaryColumnInfo(IRptParams filter)
        {
            // 调用基类的 GetSummaryColumnInfo 方法获取基本的汇总列信息
            var result = base.GetSummaryColumnInfo(filter);
            // 以下是一些汇总字段
            result.Add(new SummaryField("F_LQKJ_FSTOCKINQTY", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//入库数
            result.Add(new SummaryField("F_LQKJ_FSTOCKOUTQTY", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//出库数
            result.Add(new SummaryField("F_LQKJ_Inboundvolume", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//入库体积
            result.Add(new SummaryField("F_LQKJ_Inventoryvolume", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//库存体积
            result.Add(new SummaryField("F_LQKJ_Warehouse", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//仓租
            result.Add(new SummaryField("F_LQKJ_Enterfee", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//进仓费
            result.Add(new SummaryField("F_LQKJ_Warehousingfee", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//出仓费
            result.Add(new SummaryField("F_LQKJ_Cargosortingfee", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//货物分拣费
            result.Add(new SummaryField("F_LQKJ_Scanfee", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//一物一码扫码出库费
            result.Add(new SummaryField("F_LQKJ_JDchannelfee", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//京东渠道贴标费
            result.Add(new SummaryField("F_LQKJ_Breturnfees", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//B2B退货挑选费
            result.Add(new SummaryField("F_LQKJ_Specialloading", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//特殊装货
            result.Add(new SummaryField("F_LQKJ_Inspectionfee", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//检查及包装费
            result.Add(new SummaryField("F_LQKJ_Wdbczce", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//未达标仓租差额
            // 返回最终的汇总列信息
            return result;
        }
        //设置单据列
        public override ReportHeader GetReportHeaders(IRptParams filter)
        {
            // 创建一个新的报告头部对象
            ReportHeader header = new ReportHeader();
            // 遍历字段（zds）并根据字段的类型来添加不同的列
            foreach (var item in zds)
            {
                switch (item.type)
                {
                    // 如果字段类型为 1，则为整数类型 
                    case 1:
                        header.AddChild(item.zdName, new LocaleValue(item.zwName, this.Context.UserLocale.LCID), SqlStorageType.SqlInt);
                        break;
                    // 如果字段类型为 2，则为字符串类型
                    case 2:
                        header.AddChild(item.zdName, new LocaleValue(item.zwName, this.Context.UserLocale.LCID), SqlStorageType.Sqlvarchar);
                        break;
                    // 如果字段类型为 3，则为小数类型
                    case 3:
                        header.AddChild(item.zdName, new LocaleValue(item.zwName, this.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
                        break;
                    // 默认情况下，假设为字符串类型
                    default:
                        header.AddChild(item.zdName, new LocaleValue(item.zwName, this.Context.UserLocale.LCID), SqlStorageType.Sqlvarchar);
                        break;
                }

            }
            // 返回最终的报告头部信息
            return header;
        }
        //构建order by语句
        protected override string BuilderTempTableOrderBySQL(IRptParams filter)
        {
            string OrderBy = "";
            // 获取排序字段字符串
            string datasort = Convert.ToString(filter.FilterParameter.SortString);
            // 如果排序字段非空，则使用该字段
            if (datasort != "")
            {
                OrderBy = datasort;
            }
            else
            {
                // 如果排序字段为空，则默认按照物料代码 F_LQKJ_Materialcode 排序
                OrderBy = "F_LQKJ_FDate";
            }
            // 返回最终的ORDER BY子句
            return OrderBy;
        }

        /// <summary>
        /// 设置报表头
        /// </summary>
        /// <param name="filter">报表过滤参数</param>
        /// <returns>报表标题</returns>
        public override ReportTitles GetReportTitles(IRptParams filter)
        {
            // 创建一个ReportTitles对象来保存报表标题
            ReportTitles titles = new ReportTitles();
            // 从过滤参数中获取自定义过滤条件
            DynamicObject customFilter = filter.FilterParameter.CustomFilter;
            // 当前方法返回空的报表标题，可以在这里根据需求设置标题
            return titles;
        }

        //构建from where语句
        protected override string BuilderFromWhereSQL(IRptParams filter)
        {
            StringBuilder strwhere = new StringBuilder();
            // 从临时表生成FROM语句，Where 1=1确保查询条件可追加
            strwhere.AppendLine(string.Format(@" from {0}  Where 1=1 ", this.tmpRptTbl));
            // 获取自定义过滤条件，并移除时间戳标记 {ts ...}
            string text2 = string.IsNullOrWhiteSpace(filter.FilterParameter.FilterString) ? " " : "and" + filter.FilterParameter.FilterString.Replace("{ts", "").Replace("}", "");
            // 将过滤条件添加到WHERE子句中
            strwhere.AppendLine(text2);
            // 返回最终的FROM WHERE语句
            return strwhere.ToString();
        }
        // 创建临时表
        private DataTable CreateTmpTable()
        {
            this.tmpRptTbl = new DBService().CreateTemporaryTableName(base.Context);  // 创建临时表名
            DataTable db = new DataTable(this.tmpRptTbl);// 初始化DataTable对象
            // 列出表中所有字段
            List<string> vs = new List<string>();
            // 遍历字段配置 zds，动态构建表的列
            foreach (var item in zds)
            {
                // 创建每个字段的DataColumn
                DataColumn col = new DataColumn(item.zdName, typeof(string)); // 默认类型为string
                db.Columns.Add(col);
                // 根据字段类型设置数据库列的数据类型
                switch (item.type)
                {
                    // 如果字段类型是整数类型
                    case 1:
                        vs.Add(item.zdName + " Int");
                        break;
                    // 如果字段类型是字符串类型
                    case 2:
                        vs.Add(item.zdName + " VARCHAR(" + item.zdcd + ")");
                        break;
                    // 如果字段类型是小数类型
                    case 3:
                        vs.Add(item.zdName + " numeric(20, " + item.zdcd + ")");
                        break;
                    // 默认类型为字符串
                    default:
                        vs.Add(item.zdName + " VARCHAR(" + item.zdcd + ")");
                        break;
                }
            }
            // 根据字段定义创建SQL语句来创建临时表
            string sql = string.Format(@"CREATE TABLE {0} ( {1} );", this.tmpRptTbl, string.Join(",", vs));
            // 执行SQL语句创建临时表
            new DBService().Execute(this.Context, sql);
            // 返回创建的DataTable对象
            return db;
        }
        /// <summary>
        /// 获取分页账表数据
        /// </summary>
        /// <param name="ctx"></param>
        /// <param name="rptFormId">账表FormId</param>
        /// <param name="rptFilterFormId">账表过滤方案FormId</param>
        /// <param name="schemeId">过滤方案内码</param>
        /// <param name="currentPosition">分页账表当前位置</param>
        /// <returns></returns>
        public DataTable GetReportData(Context ctx, string rptFormId, string rptFilterFormId, string schemeId, string F_LQKJ_OrgId, string F_LQKJ_StartDate, string F_LQKJ_EndDate, int currentPosition)
        {
            ISysReportService sysReporSservice = ServiceFactory.GetSysReportService(ctx);
            var filterMetadata = FormMetaDataCache.GetCachedFilterMetaData(ctx);//加载字段比较条件元数据。
            var reportMetadata = FormMetaDataCache.GetCachedFormMetaData(ctx, rptFormId);//加载存货收发存汇总表元数据。标准成本  最新成本：采购订单最新不含税单价
            var reportFilterMetadata = FormMetaDataCache.GetCachedFormMetaData(ctx, rptFilterFormId);//加载存货收发存汇总表过滤条件元数据。
            var reportFilterServiceProvider = reportFilterMetadata.BusinessInfo.GetForm().GetFormServiceProvider();
            var model = new SysReportFilterModel();
            model.SetContext(ctx, reportFilterMetadata.BusinessInfo, reportFilterServiceProvider);
            model.FormId = reportFilterMetadata.BusinessInfo.GetForm().Id;
            model.FilterObject.FilterMetaData = filterMetadata;
            model.InitFieldList(reportMetadata, reportFilterMetadata);
            model.GetSchemeList();
            //过滤方案的主键值，可通过该SQL语句查询得到：SELECT * FROM T_BAS_FILTERSCHEME
            var entity = model.Load(schemeId);
            var dyn = DeserializeCustomFilter(reportFilterMetadata.BusinessInfo, entity.CustomFilterSetting);
            model.DataObject = dyn;
            var filter = model.GetFilterParameter();

            //long ForgId = F_LQKJ_OrgId == null ? 0 : Convert.ToInt64(F_LQKJ_OrgId);
            DynamicObject filterObj = filter.CustomFilter;
            filterObj["StockOrgId"] = F_LQKJ_OrgId;
            if (!string.IsNullOrEmpty(F_LQKJ_StartDate) && F_LQKJ_StartDate != "")
            {
                filterObj["BeginDate"] = F_LQKJ_StartDate;
            }
            if (!string.IsNullOrEmpty(F_LQKJ_EndDate) && F_LQKJ_EndDate != "")
            {
                filterObj["EndDate"] = F_LQKJ_EndDate;
            }
            IRptParams rptParam = new RptParams();
            rptParam.FormId = reportFilterMetadata.BusinessInfo.GetForm().Id;
            rptParam.CurrentPosition = currentPosition;//分页账表当前位置
            rptParam.StartRow = 1;
            rptParam.EndRow = int.MaxValue;//StartRow和EndRow是报表数据分页的起始行数和截至行数，一般取所有数据，所以EndRow取int最大值。
            rptParam.FilterParameter = filter;
            rptParam.FilterFieldInfo = model.FilterFieldInfo;
            // var dic = new Dictionary<string, object>();
            var openParameter = new Dictionary<string, object>();

            var parameterDataFormId = reportMetadata.BusinessInfo.GetForm().ParameterObjectId;
            var parameterDataMetadata = FormMetaDataCache.GetCachedFormMetaData(ctx, parameterDataFormId);
            var parameterData = UserParamterServiceHelper.Load(ctx, parameterDataMetadata.BusinessInfo, ctx.UserId, rptFormId, KeyConst.USERPARAMETER_KEY);
            foreach (var itemProp in parameterData.DynamicObjectType.Properties)
            {
                openParameter[itemProp.Name] = parameterData[itemProp.Name];
            }
            rptParam.CustomParams.Add(KeyConst.OPENPARAMETER_KEY, openParameter);
            rptParam.ParameterData = parameterData;
            MoveReportServiceParameter param = new MoveReportServiceParameter(ctx, reportMetadata.BusinessInfo, Guid.NewGuid().ToString(), rptParam);
            //MoveReportServiceParameter param = new MoveReportServiceParameter(ctx, reportMetadata.BusinessInfo, Guid.NewGuid().ToString(), p);
            DataTable dt = new DataTable();
            //if (flag != "2")
            dt = sysReporSservice.GetListAndReportData(param).DataSource;//简单账表使用GetReportData方法 分页账表使用GetListAndReportData方法

            return dt;
        }
        private void CreateTmpTable(string tmpTableName)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendLine(string.Format(@"/*dialect*/IF NOT EXISTS (SELECT * FROM sysobjects WHERE name = '{0}' AND type = 'U') ", tmpTableName));
            builder.AppendLine(string.Format(@"CREATE TABLE {0} (", tmpTableName));
            builder.AppendLine("FDate DATE,");//日期
            builder.AppendLine("FSTOCKORGID INT,");//组织ID
            builder.AppendLine("FSTOCKID INT,");//仓库ID
            builder.AppendLine("FMATERIALID INT,");//物料ID
            //builder.AppendLine("FSTOCKUNITID INT,");//库存单位ID
            //builder.AppendLine("FOWNERTYPENAME NVARCHAR(100),");//货主类型
            builder.AppendLine("FSTOCKQCQTY DECIMAL(23, 4),");//库存合格数量
            builder.AppendLine("FSTOCKINQTY DECIMAL(23, 4),");//入库数量
            builder.AppendLine("FSTOCKOUTQTY DECIMAL(23, 4),");//出库数量
            builder.AppendLine("FSTOCKJCQTY DECIMAL(23, 4)");//结存数量
            builder.AppendLine(")");

            // 执行 SQL 语句
            DBUtils.Execute(base.Context, builder.ToString());
        }
        private void CreateTmpTableS(string tmpTableNameS)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendLine(string.Format(@"/*dialect*/IF NOT EXISTS (SELECT * FROM sysobjects WHERE name = '{0}' AND type = 'U') ", tmpTableNameS));
            builder.AppendLine(string.Format(@"CREATE TABLE {0} (", tmpTableNameS));
            builder.AppendLine("FSEQ INT,");//序号
            builder.AppendLine("FDate DATE,");//日期
            builder.AppendLine("FSTOCKORGID INT,");//组织ID
            builder.AppendLine("FSTOCKID INT,");//仓库ID
            builder.AppendLine("FMATERIALID INT,");//物料ID
            //builder.AppendLine("FSTOCKUNITID INT,");//库存单位ID
            //builder.AppendLine("FOWNERTYPENAME NVARCHAR(100),");//货主类型
            builder.AppendLine("FSTOCKQCQTY DECIMAL(23, 4),");//库存合格数量
            builder.AppendLine("FSTOCKINQTY DECIMAL(23, 4),");//入库数量
            builder.AppendLine("FSTOCKOUTQTY DECIMAL(23, 4),");//出库数量
            builder.AppendLine("FSTOCKJCQTY DECIMAL(23, 4)");//结存数量
            builder.AppendLine(")");

            // 执行 SQL 语句
            DBUtils.Execute(base.Context, builder.ToString());
        }
        /// <summary>
        /// 获取自定义参数
        /// </summary>
        /// <param name="businessInfo">过滤方案元数据</param>
        /// <param name="xml"></param>
        /// <returns></returns>
        private DynamicObject DeserializeCustomFilter(BusinessInfo businessInfo, string xml)
        {
            DcxmlBinder binder = new DynamicObjectDcxmlBinder(businessInfo);
            binder.OnlyDbProperty = false;
            DcxmlSerializer target = new DcxmlSerializer(binder);
            //切换到中性语言，获取主差量
            //CultureInfo inv = new CultureInfo(2052); //中性语言
            binder.Culture = CultureInfo.InvariantCulture;// inv;
                                                          // 集合忽略主键冲突
            target.ColloctionIgnorePKValue = true;
            DynamicObject obj = (DynamicObject)target.DeserializeFromString(xml, null);
            return obj;
        }
        //创建临时表,把数据插入到临时表中
        public string createTmpTable(DataTable data, Context context)
        {
            string fieldColumnSql = GetCreateTmpTableNameSql(data.Columns);
            string tmpTableName = "CreditStatus";
            data.TableName = tmpTableName;
            TableName = tmpTableName;
            var createTmpTableSql = string.Format("create table {0} {1}", tmpTableName, fieldColumnSql);
            try
            {
                DBServiceHelper.ExecuteDataSet(context, createTmpTableSql);
            }
            catch (Exception ex)
            {
                //DBServiceHelper.Execute(context, $"DROP TABLE CreditStatus");
                //DBServiceHelper.ExecuteDataSet(context, createTmpTableSql);
            }

            return tmpTableName;
        }
        private string GetCreateTmpTableNameSql(DataColumnCollection fieldColumn)
        {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.AppendLine("(");
            List<string> listStr = new List<string>();
            foreach (var field in fieldColumn)
            {
                listStr.Add(Convert.ToString(field).Trim() + " nvarchar(1000)");
            }
            stringBuilder.AppendLine(String.Join(",", listStr.Distinct()));
            stringBuilder.AppendLine(")");
            return stringBuilder.ToString();
        }
        public bool checkTableIsExist(Context context)
        {
            string sql = "/*dialect*/select top 1 * from sysObjects where Id=OBJECT_ID(N'CreditStatus') and xtype='U'";
            DynamicObjectCollection dynamics = DBServiceHelper.ExecuteDynamicObject(context, sql);
            if (dynamics.Count > 0)
            {
                return true;
            }
            return false;
        }
        // 临时表字段信息的类
        public class CreateTmpTableZD
        {
            // 字段名
            public string zdName { get; set; }
            // 字段类型（1: 整数，2: 字符串，3: 小数）
            public int type { get; set; }
            // 字段长度/精度
            public int zdcd { get; set; }
            // 字段显示名称
            public string zwName { get; set; }
            // 字段所属实体列表
            public List<Entity> EntityList { get; set; }
        }

        // 用于定义实体类的字段
        public class Entity
        {
            // 采购订单
            public string CGDD { get; set; }
        }
    }
}
