﻿using Kingdee.BOS.Util;
using Kingdee.K3.FIN.AR.App.Report;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Kingdee.BOS.Contracts;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.App;
using Kingdee.BOS.Log;
using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Web.ServiceVerify;
using Kingdee.BOS.Core;
using Kingdee.BOS.Core.CommonFilter;
using Kingdee.BOS.Core.Enums;
using Kingdee.BOS.Core.List;
using Kingdee.K3.SCM.App.Stock.Report;
namespace LQKJ.K3.CZXT.Pluglus
{
    //Kingdee.K3.SCM.App.Stock.Report
    [Description("物料收发汇总表添加字段"), HotUpdate]
    //继承标准报表（物料收发汇总表）的插件
    public class STK_StockSummaryRpt : StockSummaryRpt
    {
        public string[] TempTableNames;
        public override void BuilderReportSqlAndTempTable(IRptParams filter, string tableName)
        {
            //创建临时表，用于存放自己的数据
            IDBService dbservice = Kingdee.BOS.App.ServiceHelper.GetService<IDBService>();
            TempTableNames = dbservice.CreateTemporaryTableName(this.Context, 1);
            string strTable = TempTableNames[0];
            //调用基类的方法，获取初步的查询结果到临时表
            base.BuilderReportSqlAndTempTable(filter, strTable);
            //对初步的查询结果进行处理，然后写回基类默认的存放查询结果的临时表
            StringBuilder sb = new StringBuilder();
            string Sql = @"/*dialect*/SELECT T1.*,CASE WHEN JB.FVOLUME = 0 THEN 1 ELSE JB.FVOLUME END AS F_LQKJ_Unitvolume--单位体积
                        ,T1.FSTOCKJCQTY * CASE WHEN JB.FVOLUME = 0 THEN 1 ELSE JB.FVOLUME END AS F_LQKJ_Totalvolume --总体积
                        ,T2.F_LQKJ_Warehouserent AS F_LQKJ_Warehouserent--仓租单价
                        ,T2.F_LQKJ_Warehouserent * (T1.FSTOCKJCQTY * CASE WHEN JB.FVOLUME = 0 THEN 1 ELSE JB.FVOLUME END) AS F_LQKJ_Warehouse --仓租
                        ,T2.F_LQKJ_Unloadingfee AS F_LQKJ_Unloadingfee --卸车单价
                        ,T2.F_LQKJ_Unloadingfee * (T1.FSTOCKINQTY * CASE WHEN JB.FVOLUME = 0 THEN 1 ELSE JB.FVOLUME END) AS F_LQKJ_Unloading --卸车费
                        ,T2.F_LQKJ_Loadingfee AS F_LQKJ_Loadingfee --装车单价
                        ,T2.F_LQKJ_Loadingfee * (T1.FSTOCKOUTQTY * CASE WHEN JB.FVOLUME = 0 THEN 1 ELSE JB.FVOLUME END) AS F_LQKJ_Loading--装车费
                        ,T2.F_LQKJ_Sortingfees AS F_LQKJ_Sortingfees--分拣费单价
                        ,T2.F_LQKJ_Sortingfees * (T1.FSTOCKOUTQTY * CASE WHEN JB.FVOLUME = 0 THEN 1 ELSE JB.FVOLUME END) AS F_LQKJ_Sorting--分拣费
                        INTO {0}
                         FROM {1} T1
                        LEFT JOIN LQKJ_SettupParameters T2 on 1=1
					    LEFT JOIN t_BD_MaterialBase JB ON JB.FMATERIALID=T1.FMATERIALID";
            sb.AppendFormat(Sql, tableName, strTable);
            Logger.Info("物料收发汇总表：", sb.ToString());
            DBUtils.Execute(this.Context, sb.ToString());
        }
        public override void CloseReport()
        {
            //删除临时表
            if (TempTableName == null || TempTableName.Length == 0)
            {
                return;
            }
            IDBService dbservice = Kingdee.BOS.App.ServiceHelper.GetService<IDBService>();
            dbservice.DeleteTemporaryTableName(this.Context, TempTableNames);
            base.CloseReport();
        }

    }
}
