﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.Bill;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Util;
using Kingdee.BOS.Web.Bill;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;

namespace LQKJ.K3.CZXT.Pluglus
{
    [Description("设置费用是否确认"), HotUpdate]
    public class LQKJ_Warehouserentexpenses_PLTJ : AbstractDynamicFormPlugIn
    {
        public override void AfterBindData(EventArgs e)
        {
            base.AfterBindData(e);
        }
        public override void ButtonClick(ButtonClickEventArgs e)
        {

            if (e.Key == "F_LQKJ_CONFIRMSAVE")
            {
                IBillView billView = null;
                DynamicObject rowData = this.View.Model.DataObject;
                decimal F_LQKJ_Scanfee = Convert.ToDecimal(rowData["F_LQKJ_Scanfee"]);//一物一码扫码出库费
                decimal F_LQKJ_JDchannelfee = Convert.ToDecimal(rowData["F_LQKJ_JDchannelfee"]);//京东渠道贴标费
                decimal F_LQKJ_Breturnfees = Convert.ToDecimal(rowData["F_LQKJ_Breturnfees"]);//B2B退货挑选费
                decimal F_LQKJ_Specialloading = Convert.ToDecimal(rowData["F_LQKJ_Specialloading"]);//特殊装货
                decimal F_LQKJ_Inspectionfee = Convert.ToDecimal(rowData["F_LQKJ_Inspectionfee"]);//检查及包装费
                decimal F_LQKJ_Wdbczce = Convert.ToDecimal(rowData["F_LQKJ_Wdbczce"]);//未达标仓租差额
                List<DataRow> FilterValues = this.View.OpenParameter.GetCustomParameter("listData") as List<DataRow>;

                string StartDate = this.View.OpenParameter.GetCustomParameter("F_LQKJ_StartDate") as string;
                string F_LQKJ_StartDate = string.Empty;
                DateTime parsedDates;
                if (DateTime.TryParse(StartDate, out parsedDates))
                {
                    // 格式化日期为 "yyyy/MM/dd" 格式
                    F_LQKJ_StartDate = parsedDates.ToString("yyyy/MM/dd");
                }
                string sql = (@"/*dialect*/SELECT F_LQKJ_FDATE,F_LQKJ_ORGID,F_LQKJ_WAREHOUSE,F_LQKJ_FMATERIALID FROM T_LQKJ_CZexpenses");
                DynamicObjectCollection dynamics = DBUtils.ExecuteDynamicObject(Context, sql);
                //Dictionary<string, string> resultDictionary = new Dictionary<string, string>();
                List<string> resultDictionary = new List<string>();
                if (dynamics.Count > 0)
                {
                    foreach (var item in dynamics)
                    {
                        DateTime parsedDate = Convert.ToDateTime(Convert.ToString(item["F_LQKJ_FDATE"]));

                        // 将其格式化为 "yyyy/MM/dd"
                        string formattedDate = parsedDate.ToString("yyyy/MM/dd");
                        string key = formattedDate + "_" + Convert.ToString(item["F_LQKJ_ORGID"]) + "_" + Convert.ToString(item["F_LQKJ_WAREHOUSE"]) + "_" + Convert.ToString(item["F_LQKJ_FMATERIALID"]);
                        // 将拼接后的字符串存入字典，key 为拼接后的字符串，value 可以根据需求设置（例如存储为字段的原始值，或者是某种标识符）
                        resultDictionary.Add(key);  // 或者根据需求可以存储不同的值
                    }
                }
                if (FilterValues != null && FilterValues.Count > 0)
                {
                    foreach (DataRow item in FilterValues)
                    {
                        string dawdsfgs = string.Empty;
                        string F_LQKJ_FDate = string.Empty;
                        if (string.IsNullOrWhiteSpace(item["F_LQKJ_FDate"]?.ToString()))
                        {
                            F_LQKJ_FDate = F_LQKJ_StartDate;
                        }
                        else
                        {
                            F_LQKJ_FDate = Convert.ToString(item["F_LQKJ_FDate"]);
                        }
                        dawdsfgs = F_LQKJ_FDate + "_" + Convert.ToString(item["FSTOCKORGID"]) + "_" + Convert.ToString(item["FSTOCKID"]) + "_" + Convert.ToString(item["FMATERIALNUMBER"]);// 如果报表明细日期为空，默认日期为报表单据头日期

                        //// 判断 dawdsfgs 是否在 resultDictionary 中
                        if (resultDictionary.Contains(dawdsfgs))
                        {
                            string sqlupdate = $@"/*dialect*/UPDATE T_LQKJ_CZexpenses SET F_LQKJ_SCANFEE={F_LQKJ_Scanfee} ,F_LQKJ_JDCHANNELFEE={F_LQKJ_JDchannelfee} ,F_LQKJ_BRETURNFEES={F_LQKJ_Breturnfees} 
,F_LQKJ_SPECIALLOADING={F_LQKJ_Specialloading},F_LQKJ_INSPECTIONFEE={F_LQKJ_Inspectionfee},F_LQKJ_WDBCZCE={F_LQKJ_Wdbczce}
WHERE F_LQKJ_FDATE='{F_LQKJ_FDate}' AND F_LQKJ_ORGID='{Convert.ToString(item["FSTOCKORGID"])}' AND F_LQKJ_WAREHOUSE='{ Convert.ToString(item["FSTOCKID"])}' AND F_LQKJ_FMATERIALID='{ Convert.ToString(item["FMATERIALNUMBER"])}'";
                            //DBUtils.Execute(this.Context, sqlupdate);
                            try
                            {
                                int rowsAffected = DBUtils.Execute(this.Context, sqlupdate);
                                if (rowsAffected > 0)
                                {
                                    this.View.ShowMessage("修改成功！");
                                }
                                else
                                {
                                    this.View.ShowMessage("修改失败，未影响任何行！");
                                }
                            }
                            catch (Exception ex)
                            {
                                Console.WriteLine($"执行更新时出错: {ex.Message}");
                            }
                        }
                        else
                        {
                            billView = CreateBillView(this.Context, "LQKJ_Warehouserentexpenses");
                            ((IBillViewService)billView).LoadData();
                            // 设置单据头部分的值
                            if (string.IsNullOrWhiteSpace(item["F_LQKJ_FDate"]?.ToString()))
                            {
                                billView.Model.SetValue("F_LQKJ_FDate", StartDate, 0);// 如果报表明细日期为空，默认日期为报表单据头日期
                            }
                            else
                            {
                                billView.Model.SetValue("F_LQKJ_FDate", item["F_LQKJ_FDate"].ToString(), 0);// 业务日期
                            }
                            billView.Model.SetValue("F_LQKJ_OrgId", item["FSTOCKORGID"].ToString(), 0);//业务组织
                            billView.Model.SetValue("F_LQKJ_Warehouse", Convert.ToString(item["FSTOCKID"]), 0);//仓库FSTOCKID
                            billView.Model.SetValue("F_LQKJ_FMATERIALID", Convert.ToString(item["FMATERIALNUMBER"]), 0);//物料编码
                            billView.Model.SetValue("F_LQKJ_Scanfee", F_LQKJ_Scanfee, 0);//一物一码扫码出库费
                            billView.Model.SetValue("F_LQKJ_JDchannelfee", F_LQKJ_JDchannelfee, 0);//京东渠道贴标费
                            billView.Model.SetValue("F_LQKJ_Breturnfees", F_LQKJ_Breturnfees, 0);//B2B退货挑选费
                            billView.Model.SetValue("F_LQKJ_Specialloading", F_LQKJ_Specialloading, 0);//特殊装货
                            billView.Model.SetValue("F_LQKJ_Inspectionfee", F_LQKJ_Inspectionfee, 0);//检查及包装费
                            billView.Model.SetValue("F_LQKJ_Wdbczce", F_LQKJ_Wdbczce, 0);//未达标仓租差额
                            //IOperationResult saveResult = billView.Model.Save();//保存单据
                            //billView.InvokeFormOperation("Submit");//提交单据
                            try
                            {
                                IOperationResult saveResult = billView.Model.Save(); // 保存单据
                                if (saveResult.IsSuccess)
                                {
                                    this.View.ShowMessage("保存成功！");
                                    billView.InvokeFormOperation("Submit"); // 提交单据
                                }
                                else
                                {
                                    this.View.ShowMessage("保存失败: ");
                                }
                            }
                            catch (Exception ex)
                            {
                                Console.WriteLine($"保存单据时出错: {ex.Message}");
                            }
                        }


                    }
                }
            }
        }
        public override void FormClosed(FormClosedEventArgs e)
        {
            base.FormClosed(e);
            this.View.SendAynDynamicFormAction(this.View.ParentFormView);
            this.View.ParentFormView.UpdateView();
            this.View.ParentFormView.Refresh();
        }
        private BillView CreateBillView(Context ctx, string formId, string layoutId = null, object pkId = null)
        {
            var meta = (FormMetadata)Kingdee.BOS.ServiceHelper.MetaDataServiceHelper.Load(ctx, formId); //单据唯一标识
            var form = meta.BusinessInfo.GetForm();
            var param = new BillOpenParameter(formId, layoutId);
            param.Context = ctx;
            param.FormMetaData = meta;
            if (pkId != null && !string.IsNullOrWhiteSpace(pkId.ToString()))
            {
                param.Status = OperationStatus.EDIT;
                param.InitStatus = OperationStatus.EDIT;
                param.PkValue = pkId; //单据主键内码FID
            }
            else
            {
                param.Status = OperationStatus.ADDNEW;
                param.InitStatus = OperationStatus.ADDNEW;
            }
            param.SetCustomParameter("formID", form.Id);
            param.SetCustomParameter("PlugIns", form.CreateFormPlugIns()); //插件实例模型
            param.SetCustomParameter("ShowConfirmDialogWhenChangeOrg", false);
            param.NetCtrlDisable = true; // 禁用网控
            var provider = form.GetFormServiceProvider();
            var billview = (BillView)provider.GetService(typeof(IDynamicFormView));
            //var type = Type.GetType("Kingdee.BOS.Web.Import.ImportBillView,Kingdee.BOS.Web");
            //var billview2 = (BillView)Activator.CreateInstance(type);
            billview.Initialize(param, provider); //初始化
            billview.LoadData(); //加载单据数据
            return billview;
        }
    }
}
