﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.Bill;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Util;
using Kingdee.BOS.Web.Bill;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;

namespace LQKJ.K3.CZXT.Pluglus
{
    [Description("设置费用是否确认"), HotUpdate]
    public class LQKJ_Warehouserentexpenses_PLTJ : AbstractDynamicFormPlugIn
    {
        public override void ButtonClick(ButtonClickEventArgs e)
        {

            if (e.Key == "F_LQKJ_CONFIRMSAVE")
            {
                IBillView billView = null;
                DynamicObject rowData = this.View.Model.DataObject;
                decimal F_LQKJ_Scanfee = Convert.ToDecimal(rowData["F_LQKJ_Scanfee"]);//一物一码扫码出库费
                decimal F_LQKJ_JDchannelfee = Convert.ToDecimal(rowData["F_LQKJ_JDchannelfee"]);//京东渠道贴标费
                decimal F_LQKJ_Breturnfees = Convert.ToDecimal(rowData["F_LQKJ_Breturnfees"]);//B2B退货挑选费
                decimal F_LQKJ_Specialloading = Convert.ToDecimal(rowData["F_LQKJ_Specialloading"]);//特殊装货
                decimal F_LQKJ_Inspectionfee = Convert.ToDecimal(rowData["F_LQKJ_Inspectionfee"]);//检查及包装费
                decimal F_LQKJ_Wdbczce = Convert.ToDecimal(rowData["F_LQKJ_Wdbczce"]);//未达标仓租差额
                List<DataRow> FilterValues = this.View.OpenParameter.GetCustomParameter("listData") as List<DataRow>;
                if (FilterValues != null && FilterValues.Count > 0)
                {
                    foreach (DataRow item in FilterValues)
                    {
                        billView = CreateBillView(this.Context, "LQKJ_Warehouserentexpenses");
                        ((IBillViewService)billView).LoadData();
                        // 设置单据头部分的值
                        if(item["F_LQKJ_FDate"].ToString() == null || item["F_LQKJ_FDate"].ToString() == "")
                        {
                            billView.Model.SetValue("F_LQKJ_FDate", DateTime.Now.ToString("yyyy-MM-dd"),0);// 设置默认日期为当前日期
                        }
                        else
                        {
                            billView.Model.SetValue("F_LQKJ_FDate", item["F_LQKJ_FDate"].ToString(),0);// 业务日期
                        }
                        billView.Model.SetValue("F_LQKJ_OrgId", item["FSTOCKORGID"].ToString(), 0);//业务组织
                        billView.Model.SetValue("F_LQKJ_Warehouse", Convert.ToString(item["FSTOCKID"]), 0);//仓库FSTOCKID
                        billView.Model.SetValue("F_LQKJ_FMATERIALID", Convert.ToString(item["FMATERIALNUMBER"]), 0);//物料编码
                        billView.Model.SetValue("F_LQKJ_Scanfee", F_LQKJ_Scanfee, 0);//一物一码扫码出库费
                        billView.Model.SetValue("F_LQKJ_JDchannelfee", F_LQKJ_JDchannelfee, 0);//京东渠道贴标费
                        billView.Model.SetValue("F_LQKJ_Breturnfees", F_LQKJ_Breturnfees, 0);//B2B退货挑选费
                        billView.Model.SetValue("F_LQKJ_Specialloading", F_LQKJ_Specialloading, 0);//特殊装货
                        billView.Model.SetValue("F_LQKJ_Inspectionfee", F_LQKJ_Inspectionfee, 0);//检查及包装费
                        billView.Model.SetValue("F_LQKJ_Wdbczce", F_LQKJ_Wdbczce, 0);//未达标仓租差额
                        IOperationResult saveResult = billView.Model.Save();//保存单据
                        billView.InvokeFormOperation("Submit");//提交单据
                    }
                }
            }
            this.View.ParentFormView.SendDynamicFormAction(this.View.ParentFormView);
            this.View.ParentFormView.UpdateView();
            this.View.ParentFormView.Refresh();
            this.View.Close();
        }
        private BillView CreateBillView(Context ctx, string formId, string layoutId = null, object pkId = null)
        {
            var meta = (FormMetadata)Kingdee.BOS.ServiceHelper.MetaDataServiceHelper.Load(ctx, formId); //单据唯一标识
            var form = meta.BusinessInfo.GetForm();
            var param = new BillOpenParameter(formId, layoutId);
            param.Context = ctx;
            param.FormMetaData = meta;
            if (pkId != null && !string.IsNullOrWhiteSpace(pkId.ToString()))
            {
                param.Status = OperationStatus.EDIT;
                param.InitStatus = OperationStatus.EDIT;
                param.PkValue = pkId; //单据主键内码FID
            }
            else
            {
                param.Status = OperationStatus.ADDNEW;
                param.InitStatus = OperationStatus.ADDNEW;
            }
            param.SetCustomParameter("formID", form.Id);
            param.SetCustomParameter("PlugIns", form.CreateFormPlugIns()); //插件实例模型
            param.SetCustomParameter("ShowConfirmDialogWhenChangeOrg", false);
            param.NetCtrlDisable = true; // 禁用网控
            var provider = form.GetFormServiceProvider();
            var billview = (BillView)provider.GetService(typeof(IDynamicFormView));
            //var type = Type.GetType("Kingdee.BOS.Web.Import.ImportBillView,Kingdee.BOS.Web");
            //var billview2 = (BillView)Activator.CreateInstance(type);
            billview.Initialize(param, provider); //初始化
            billview.LoadData(); //加载单据数据
            return billview;
        }
    }
}
