﻿using Kingdee.BOS;
using Kingdee.BOS.Contracts;
using Kingdee.BOS.Core;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Model.ReportFilter;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Serialization;
using Kingdee.BOS.ServiceHelper;
using Kingdee.K3.FIN.App.Core;
using System;
using System.Collections.Generic;
using System.Data;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.K3.CZXT.Pluglus
{
    public class Executetheplan : IScheduleService
    {
        public void Run(Context ctx, Schedule schedule)
        {
            List<string> updateSQL = new List<string>();
            //throw new NotImplementedException();
            string sqlBB = string.Format(@"/*dialect*/SELECT FSCHEMEID FROM T_BAS_FILTERSCHEME where FFORMID='STK_StockDetailRpt' and FSCHEMENAME='仓租报表专用'");
            string schemeId = AppServiceContext.DBService.ExecuteScalar<string>(ctx, sqlBB, "");//获取过滤条件框的方案
            if (string.IsNullOrWhiteSpace(schemeId))
            {
                throw new Exception("物料收发明细表没有专用过滤方案！");
            }
            string F_LQKJ_StartDate = DateTime.Now.AddDays(-1).ToString("yyyy-MM-dd");
            DataTable dataTable = GetReportData(ctx, "STK_StockDetailRpt", "STK_StockDetailFilter", schemeId, F_LQKJ_StartDate, 0);
            foreach (DataRow item in dataTable.Rows)
            {
               string SQL = $@"INSERT INTO T_LQKJ_CZDataSheet 
                            (
                                FDate,
                                FSTOCKORGID,
                                FSTOCKID,
                                FMATERIALID,
                                FSTOCKUNITID,
                                FOWNERTYPENAME,
                                FSTOCKQCQTY,
                                FSTOCKINQTY,
                                FSTOCKOUTQTY,
                                FSTOCKJCQTY
                            )
                            VALUES
                            (
                                '{F_LQKJ_StartDate}',       -- FDate: 插入的日期
                                {item["FSTOCKORGID"]},                  -- FSTOCKORGID: 例如库存组织ID
                                {item["FSTOCKID"]},                -- FSTOCKID: 例如库存ID
                                {item["FMATERIALID"]},               -- FMATERIALID: 例如物料ID
                                {item["FSTOCKUNITID"]},                 -- FSTOCKUNITID: 例如库存单位ID
                                N'{item["FOWNERTYPENAME"]}',           -- FOWNERTYPENAME: 例如所有者名称（注意使用 N 前缀表示 Unicode 字符串）
                                {item["FSTOCKQCQTY"]},             -- FSTOCKQCQTY: 合格数量
                                {item["FSTOCKINQTY"]},             -- FSTOCKINQTY: 入库数量
                                {item["FSTOCKOUTQTY"]},             -- FSTOCKOUTQTY: 出库数量
                                {item["FSTOCKJCQTY"]}               -- FSTOCKJCQTY: 借出数量
                            );";
                updateSQL.Add(SQL);
            }
            if (updateSQL.Count > 0)
            {
                DBServiceHelper.ExecuteBatch(ctx, updateSQL);
            }
        }
        /// <summary>
        /// 物料收发明细表
        /// </summary>
        /// <param name="businessInfo"></param>
        /// <param name="xml"></param>
        /// <returns></returns>
        public DataTable GetReportData(Context ctx, string rptFormId, string rptFilterFormId, string schemeId, string F_LQKJ_StartDate, int currentPosition)
        {
            ISysReportService sysReporSservice = ServiceFactory.GetSysReportService(ctx);
            IPermissionService permissionService = ServiceFactory.GetPermissionService(ctx);
            var filterMetadata = FormMetaDataCache.GetCachedFilterMetaData(ctx);//加载字段比较条件元数据。
            var reportMetadata = FormMetaDataCache.GetCachedFormMetaData(ctx, rptFormId);//加载存货收发存汇总表元数据。标准成本  最新成本：采购订单最新不含税单价
            var reportFilterMetadata = FormMetaDataCache.GetCachedFormMetaData(ctx, rptFilterFormId);//加载存货收发存汇总表过滤条件元数据。
            var reportFilterServiceProvider = reportFilterMetadata.BusinessInfo.GetForm().GetFormServiceProvider();
            var model = new SysReportFilterModel();
            model.SetContext(ctx, reportFilterMetadata.BusinessInfo, reportFilterServiceProvider);
            model.FormId = reportFilterMetadata.BusinessInfo.GetForm().Id;
            model.FilterObject.FilterMetaData = filterMetadata;
            model.InitFieldList(reportMetadata, reportFilterMetadata);
            model.GetSchemeList();
            //过滤方案的主键值，可通过该SQL语句查询得到：SELECT * FROM T_BAS_FILTERSCHEME
            var entity = model.Load(schemeId);
            var dyn = DeserializeCustomFilter(reportFilterMetadata.BusinessInfo, entity.CustomFilterSetting);
            model.DataObject = dyn;
            var filter = model.GetFilterParameter();
            DynamicObject filterObj = filter.CustomFilter;
            //filterObj["StockOrgId"] = F_LQKJ_OrgId;
            if (!string.IsNullOrEmpty(F_LQKJ_StartDate) && F_LQKJ_StartDate != "")
            {
                filterObj["BeginDate"] = Convert.ToDateTime(F_LQKJ_StartDate);
                filterObj["EndDate"] = Convert.ToDateTime(F_LQKJ_StartDate);
            }
            //AppServiceContext.DBService.LoadReferenceObject(ctx, new DynamicObject[] { filterObj }, det, false);

            //IRptParams p = new RptParams();
            //p.FormId = reportFilterMetadata.BusinessInfo.GetForm().Id;
            //p.CurrentPosition = currentPosition;//分页账表当前位置
            //p.StartRow = 1;
            //p.EndRow = int.MaxValue;
            //p.FilterParameter = filter;
            //p.FilterFieldInfo = model.FilterFieldInfo;
            //p.BaseDataTempTable.AddRange(permissionService.GetBaseDataTempTable(ctx, reportMetadata.BusinessInfo.GetForm().Id));
            IRptParams rptParam = new RptParams();
            rptParam.FormId = reportFilterMetadata.BusinessInfo.GetForm().Id;
            rptParam.CurrentPosition = currentPosition;//分页账表当前位置
            rptParam.StartRow = 1;
            rptParam.EndRow = int.MaxValue;//StartRow和EndRow是报表数据分页的起始行数和截至行数，一般取所有数据，所以EndRow取int最大值。
            rptParam.FilterParameter = filter;
            rptParam.FilterFieldInfo = model.FilterFieldInfo;
            // var dic = new Dictionary<string, object>();
            var openParameter = new Dictionary<string, object>();

            var parameterDataFormId = reportMetadata.BusinessInfo.GetForm().ParameterObjectId;
            var parameterDataMetadata = FormMetaDataCache.GetCachedFormMetaData(ctx, parameterDataFormId);
            var parameterData = UserParamterServiceHelper.Load(ctx, parameterDataMetadata.BusinessInfo, ctx.UserId, rptFormId, KeyConst.USERPARAMETER_KEY);
            foreach (var itemProp in parameterData.DynamicObjectType.Properties)
            {
                openParameter[itemProp.Name] = parameterData[itemProp.Name];
            }
            rptParam.CustomParams.Add(KeyConst.OPENPARAMETER_KEY, openParameter);
            rptParam.ParameterData = parameterData;
            MoveReportServiceParameter param = new MoveReportServiceParameter(ctx, reportMetadata.BusinessInfo, Guid.NewGuid().ToString(), rptParam);
            //MoveReportServiceParameter param = new MoveReportServiceParameter(ctx, reportMetadata.BusinessInfo, Guid.NewGuid().ToString(), p);
            DataTable dt = new DataTable();
            //if (flag != "2")
            dt = sysReporSservice.GetListAndReportData(param).DataSource;//简单账表使用GetReportData方法 分页账表使用GetListAndReportData方法

            return dt;
        }
        private DynamicObject DeserializeCustomFilter(BusinessInfo businessInfo, string xml)
        {
            DcxmlBinder binder = new DynamicObjectDcxmlBinder(businessInfo);
            binder.OnlyDbProperty = false;
            DcxmlSerializer target = new DcxmlSerializer(binder);
            //切换到中性语言，获取主差量
            //CultureInfo inv = new CultureInfo(2052); //中性语言
            binder.Culture = CultureInfo.InvariantCulture;// inv;
            // 集合忽略主键冲突
            target.ColloctionIgnorePKValue = true;
            DynamicObject obj = (DynamicObject)target.DeserializeFromString(xml, null);
            return obj;
        }
    }
}
