﻿using Kingdee.BOS.Core.Bill;
using Kingdee.BOS.Core.CommonFilter;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.DynamicForm.PlugIn.ControlModel;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Core.Report.PlugIn;
using Kingdee.BOS.Model.Report;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LQKJ.K3.CZXT.Pluglus
{
    [Description("打开仓租手输费用表单"), HotUpdate]
    public class Handlossfees_TCBD : AbstractSysReportPlugIn
    {
        public override void BarItemClick(Kingdee.BOS.Core.DynamicForm.PlugIn.Args.BarItemClickEventArgs e)
        {
            //点击按钮事件
            base.BarItemClick(e);
            //当点击这个按钮,触发
            if (e.BarItemKey.Equals("LQKJ_Setupfees"))
            {
                //获取报表过滤条件上的值
                var mode = this.Model as SysReportModel;
                var a = mode.FilterParameter.CustomFilter;
                string F_LQKJ_StartDate = a["F_LQKJ_StartDate"].ToString();
                // 定义 listData 用于存储选中的数据
                List<DataRow> listData = new List<DataRow>();
                List<object> sdsw2 = new List<object>();
                //调用,动态表单
                DynamicFormShowParameter parameter = new DynamicFormShowParameter();
                DataRow[] selectedDataRows = this.SysReportView.SelectedDataRows;
                if (selectedDataRows ==null)
                {
                    this.View.ShowMessage("请至少选择一条数据再进行设置费用！");
                }
                else
                {
                    //获取选中数据添加到集合中
                    foreach (DataRow dataRow in selectedDataRows)
                    {
                        //string F_LQKJ_StartDate = Convert.ToString(dataRow["F_LQKJ_StartDate"]);
                        listData.Add(dataRow);
                    }
                    parameter.OpenStyle.ShowType = ShowType.Floating;
                    //调用哪个表单
                    parameter.FormId = "LQKJ_Setupfeesschedule";
                    //通过销售订单编号,当前打开单据的单据编号查询后台数据库
                    parameter.CustomComplexParams.Add("listData", listData);
                    parameter.CustomComplexParams.Add("F_LQKJ_StartDate", F_LQKJ_StartDate);
                    //打开的动态表单,加载进来
                    this.View.ShowForm(parameter);
                }
            }
        }
    }
}
