﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;

namespace LQKJ.K3.CZXT.Pluglus
{
    [Description("加载设置参数"), HotUpdate]
    public class LQKJ_Setparameters_Edit : AbstractDynamicFormPlugIn
    {
        public override void AfterBindData(EventArgs e)
        {
            base.AfterBindData(e);

            SetF_BHR_BCGLJE(this.Context);
        }
        public override void DataChanged(DataChangedEventArgs e)
        {
            base.DataChanged(e);

            switch (e.Field.Key)
            {
                case "":  //收款条件
                    SetF_BHR_BCGLJE(this.Context);
                    break;

            }
        }
        private void SetF_BHR_BCGLJE(Context ctx)
        {
            string sql = (@"/*dialect*/SELECT * FROM LQKJ_SettupParameters");
            DynamicObjectCollection dynamics = DBUtils.ExecuteDynamicObject(Context, sql);
            if (dynamics.Count > 0)
            {
                this.View.Model.SetValue("F_LQKJ_Unitvolume", Convert.ToString(dynamics[0]["F_LQKJ_Unitvolume"]));
                this.View.Model.SetValue("F_LQKJ_Warehouserent", Convert.ToString(dynamics[0]["F_LQKJ_Warehouserent"]));
                this.View.Model.SetValue("F_LQKJ_Unloadingfee", Convert.ToString(dynamics[0]["F_LQKJ_Unloadingfee"]));
                this.View.Model.SetValue("F_LQKJ_Loadingfee", Convert.ToString(dynamics[0]["F_LQKJ_Loadingfee"]));
                this.View.Model.SetValue("F_LQKJ_Sortingfees", Convert.ToString(dynamics[0]["F_LQKJ_Sortingfees"]));
            }
            this.View.UpdateView("F_LQKJ_Unitvolume"); // 更新视图
            this.View.UpdateView("F_LQKJ_Warehouserent");
            this.View.UpdateView("F_LQKJ_Unloadingfee");
            this.View.UpdateView("F_LQKJ_Loadingfee");
            this.View.UpdateView("F_LQKJ_Sortingfees");
        }
    }

}

