﻿using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;

namespace LQKJ.K3.CZXT.Pluglus
{
    [Description("设置参数是否确认"), HotUpdate]
    public class Setupparameter : AbstractDynamicFormPlugIn
    {
        public override void ButtonClick(ButtonClickEventArgs e)
        {
            List<string> combinedMessages = new List<string>();
            if (e.Key == "F_LQKJ_CONFIRMREVISE")
            {
                // 创建整单错误信息列表
                List<string> errorMessagest = new List<string>();
                List<string> stringst = new List<string>();
                bool hasChanges = false;
                DynamicObject rowData = this.View.Model.DataObject;
                decimal F_LQKJ_Unitvolume = Convert.ToDecimal(rowData["F_LQKJ_Unitvolume"]);//单位体积
                decimal F_LQKJ_Warehouserent = Convert.ToDecimal(rowData["F_LQKJ_Warehouserent"]);//仓租单价
                decimal F_LQKJ_Unloadingfee = Convert.ToDecimal(rowData["F_LQKJ_Unloadingfee"]);//卸车费单价
                decimal F_LQKJ_Loadingfee = Convert.ToDecimal(rowData["F_LQKJ_Loadingfee"]);//装车费单价
                decimal F_LQKJ_Sortingfees = Convert.ToDecimal(rowData["F_LQKJ_Sortingfees"]);//分拣费单价

                //判断所有字段是否为0
                if (F_LQKJ_Unitvolume == 0)
                {
                    errorMessagest.Add("单位体积");
                    hasChanges = true;
                }
                if (F_LQKJ_Warehouserent == 0)
                {
                    errorMessagest.Add("仓租单价");
                    hasChanges = true;
                }
                if (F_LQKJ_Unloadingfee == 0)
                {
                    errorMessagest.Add("卸车费单价");
                    hasChanges = true;
                }
                if (F_LQKJ_Loadingfee == 0)
                {
                    errorMessagest.Add("装车费单价");
                    hasChanges = true;
                }
                if (F_LQKJ_Sortingfees == 0)
                {
                    errorMessagest.Add("分拣费单价");
                    hasChanges = true;
                }
                if (hasChanges)
                {
                    string errorMessage = "";
                    errorMessage += string.Join("、", errorMessagest);
                    stringst.Add(errorMessage);
                }
                if ((F_LQKJ_Unitvolume + F_LQKJ_Warehouserent + F_LQKJ_Unloadingfee + F_LQKJ_Loadingfee + F_LQKJ_Sortingfees) == 0)
                {
                    combinedMessages.Add($"当前所有参数都为0");
                }
                else if ((F_LQKJ_Unitvolume + F_LQKJ_Warehouserent + F_LQKJ_Unloadingfee + F_LQKJ_Loadingfee + F_LQKJ_Sortingfees) > 0 && stringst.Count > 0)
                {
                    combinedMessages.Add($"{string.Join("\n", stringst)}为0");
                }
                if (combinedMessages.Count > 0)
                {
                    this.View.ShowMessage($"{string.Join("\n", combinedMessages)}，是否继续确认修改！",
                    //提示信息：是、否
                    MessageBoxOptions.YesNo,
                    new Action<MessageBoxResult>((result) =>
                    {
                        if (result == MessageBoxResult.Yes)
                        {
                            //如果选择的是,给备注赋值,是
                            string SQL = $@"UPDATE LQKJ_SettupParameters SET F_LQKJ_Unitvolume={F_LQKJ_Unitvolume}, F_LQKJ_Warehouserent={F_LQKJ_Warehouserent}, F_LQKJ_Unloadingfee={F_LQKJ_Unloadingfee}, F_LQKJ_Loadingfee={F_LQKJ_Loadingfee}, F_LQKJ_Sortingfees={F_LQKJ_Sortingfees} WHERE Id=1";
                            // 执行添加数据的SQL语句
                            //DBUtils.Execute(this.Context, SQL);
                            try
                            {
                                int rowsAffected = DBUtils.Execute(this.Context, SQL);
                                if (rowsAffected > 0)
                                {
                                    this.View.ShowMessage("修改成功！");
                                }
                                else
                                {
                                    this.View.ShowMessage("修改失败，未影响任何行！");
                                }
                            }
                            catch (Exception ex)
                            {
                                Console.WriteLine($"执行更新时出错: {ex.Message}");
                            }
                        }
                        else if (result == MessageBoxResult.No)
                        {
                            //如果选择的否,给备注赋值,否
                            //this.View.Close();
                            return;
                        }
                        // 清空 combinedMessages 列表
                        combinedMessages.Clear();
                    }));
                }
                else
                {
                    // 查询 LQKJ_SettupParameters 表是否已经有数据
                    string checkSQL = @"/*dialect*/SELECT COUNT(*) AS [RowCount] FROM [dbo].[LQKJ_SettupParameters]";
                    //int count = Convert.ToInt32(DBUtils.ExecuteDynamicObject(this.Context, checkSQL));
                    DynamicObjectCollection dynamics = DBUtils.ExecuteDynamicObject(Context, checkSQL);
                    string SQL = string.Empty;

                    // 判断是否已有数据
                    if (Convert.ToDecimal(dynamics[0]["RowCount"]) > 0)
                    {
                        // 如果有数据，执行 UPDATE 操作
                        SQL = $@"
        UPDATE LQKJ_SettupParameters 
        SET 
            F_LQKJ_Unitvolume = {F_LQKJ_Unitvolume}, 
            F_LQKJ_Warehouserent = {F_LQKJ_Warehouserent}, 
            F_LQKJ_Unloadingfee = {F_LQKJ_Unloadingfee}, 
            F_LQKJ_Loadingfee = {F_LQKJ_Loadingfee}, 
            F_LQKJ_Sortingfees = {F_LQKJ_Sortingfees}";
                    }
                    else
                    {
                        // 如果没有数据，执行 INSERT 操作
                        SQL = $@"
        INSERT INTO LQKJ_SettupParameters (
            F_LQKJ_Unitvolume, 
            F_LQKJ_Warehouserent, 
            F_LQKJ_Unloadingfee, 
            F_LQKJ_Loadingfee, 
            F_LQKJ_Sortingfees
        ) 
        VALUES (
            {F_LQKJ_Unitvolume}, 
            {F_LQKJ_Warehouserent}, 
            {F_LQKJ_Unloadingfee}, 
            {F_LQKJ_Loadingfee}, 
            {F_LQKJ_Sortingfees}
        )";
                    }

                    // 执行 SQL 操作
                    try
                    {
                        int rowsAffected = DBUtils.Execute(this.Context, SQL);
                        if (rowsAffected > 0)
                        {
                            this.View.ShowMessage("操作成功！");
                        }
                        else
                        {
                            this.View.ShowMessage("操作失败，未影响任何行！");
                        }
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine($"执行更新或插入时出错: {ex.Message}");
                    }
                }
            }
        }
        public override void FormClosed(FormClosedEventArgs e)
        {
            base.FormClosed(e);
            this.View.SendAynDynamicFormAction(this.View.ParentFormView);
            this.View.ParentFormView.UpdateView();
            this.View.ParentFormView.Refresh();
        }
    }
}
