﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Kingdee.BOS;
using Kingdee.BOS.App.Core;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Contracts;
using Kingdee.BOS.Contracts.Report;
using Kingdee.BOS.Core;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Core.SqlBuilder;
using Kingdee.BOS.Model.ReportFilter;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Serialization;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using Kingdee.K3.FIN.App.Core;
using Kingdee.BOS.App;
using System.Transactions;

namespace LQKJ.K3.CZXT.Pluglus
{
    [Description("仓租汇总报表"), HotUpdate]
    public class WarehouseRentReport : SysReportBaseService
    {
        string TableName;
        string tmpTableName = string.Empty;
        private static Dictionary<string, string> tempdbs = new Dictionary<string, string>();
        // 定义一个空的字符串变量 tmpRptTbl，用来存储临时报告表的相关信息
        string tmpRptTbl = string.Empty;
        // 定义一个列表，保存 CreateTmpTableZD 类型的对象，该类型可能用于存储一些临时表的定义
        List<CreateTmpTableZD> zds = new List<CreateTmpTableZD>();
        public override void Initialize()
        {
            //删除物料收发明细表存储数据表
            //string sqlDROP = $@"/*dialect*/DROP TABLE CreditStatus";
            //DBUtils.ExecuteDynamicObject(this.Context, sqlDROP);
            string checkTableSql = @"SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'CreditStatus'";
            var result = DBUtils.ExecuteDynamicObject(this.Context, checkTableSql);
            // 检查 result 是否为空，并获取 count 值
            if (result != null && result.Count > 0)
            {
                var firstRow = result[0];  // 获取结果集中的第一行
                int tableCount = firstRow["Property0"] != null ? Convert.ToInt32(firstRow["Property0"]) : 0;
                // 如果表存在，则删除
                if (tableCount > 0)
                {
                    string sqlDROP = @"DROP TABLE CreditStatus";
                    DBUtils.ExecuteDynamicObject(this.Context, sqlDROP);
                }
            }
            // 简单账表类型：普通、树形、分页
            this.ReportProperty.ReportType = ReportType.REPORTTYPE_NORMAL;
            //通过插件创建
            this.IsCreateTempTableByPlugin = false;
            //是否分组汇总
            this.ReportProperty.IsGroupSummary = true;
            // 调用基类的 Initialize 方法，确保基类的初始化逻辑得以执行
            base.Initialize();
        }
        // 定义一个方法 GetBaseDataNameValue，输入参数为 DynamicObjectCollection 类型的 dyobj。
        // 返回类型为字符串，用于根据 dyobj 中的元素提取并拼接相关的名称值。
        private string GetBaseDataNameValue(DynamicObjectCollection dyobj)
        {
            // 初始化一个空字符串变量 name，用于存储拼接的结果
            string name = "";
            // 遍历 dyobj 中的每一个 DynamicObject 对象
            foreach (DynamicObject dynbj in dyobj)
            {
                // 检查 dynbj 是否为 null，或者 dynbj 对象中是否没有名为 "Name" 的属性
                if (dynbj != null || !dynbj.DynamicObjectType.Properties.Contains("Name"))
                {
                    // 从 dynbj 中获取第二个元素（假设是 DynamicObject 类型），并存储到 dynbj2 变量中
                    DynamicObject dynbj2 = (DynamicObject)dynbj[2];
                    // 将 dynbj2 中 "Number" 属性的值转换为字符串，并拼接到 name 变量中
                    // 拼接时，使用逗号分隔字符串
                    name = name + ",'" + dynbj2["Number"].ToString() + "'";
                }
            }
            // 如果 name 字符串的长度大于 0，表示拼接了数据
            // 则从 name 字符串的第二个字符开始截取，去掉开头的多余逗号
            if (name.Length > 0)
            {
                name = name.Substring(1, name.Length - 1);
            }
            // 返回最终拼接后的 name 字符串
            return name;
        }
        //构建单据select 和字段
        protected override string BuilderSelectFieldSQL(IRptParams filter)
        {
            //// 创建组织信息列表
            List<string> errorMessagest = new List<string>();
            // 创建一个 StringBuilder 来构建 SQL 语句中的 WHERE 子句
            StringBuilder strwhere = new StringBuilder();
            // 获取用户自定义的过滤参数（例如：开始日期、结束日期）
            DynamicObject customFilter = filter.FilterParameter.CustomFilter;
            // 获取自定义过滤器中的组织ID
            // 如果自定义过滤器没有组织ID，则默认为空字符串
            //string F_LQKJ_OrgId = Convert.ToString(customFilter["F_LQKJ_OrgId_Id"]);//组织ID
            DynamicObjectCollection F_LQKJ_OrgIdS = customFilter["F_LQKJ_OrgIds"] as DynamicObjectCollection;
            string F_LQKJ_OrgId = "";
            if (F_LQKJ_OrgIdS.Count > 0)
            {
                foreach (var item in F_LQKJ_OrgIdS)
                {
                    errorMessagest.Add(Convert.ToString(item["F_LQKJ_OrgIds_Id"]));
                }
                F_LQKJ_OrgId += string.Join(",", errorMessagest);
            }
            string F_LQKJ_StartDate = "";
            string F_LQKJ_EndDate = "";
            // 获取自定义过滤器中的开始日期和结束日期
            // 如果自定义过滤器没有设置日期，则默认为空字符串
            if (customFilter["F_LQKJ_StartDate"] != null && customFilter["F_LQKJ_EndDate"] != null)
            {
                F_LQKJ_StartDate = (customFilter["F_LQKJ_StartDate"] == null) ? string.Empty : Convert.ToDateTime(customFilter["F_LQKJ_StartDate"]).ToString("yyyy-MM-dd");//起始日期
                F_LQKJ_EndDate = (customFilter["F_LQKJ_EndDate"] == null) ? string.Empty : Convert.ToDateTime(customFilter["F_LQKJ_EndDate"]).ToString("yyyy-MM-dd");//截止日期
            }
            else if( customFilter["F_LQKJ_Datemonth"] != null)
            {
                // 获取 F_LQKJ_Datemonth 字段的日期字符串
                string dateMonthStr = customFilter["F_LQKJ_Datemonth"]?.ToString()?.Trim(); // 去除首尾空格
                DateTime startDate = DateTime.MinValue;
                DateTime endDate = DateTime.MinValue;

                if (!string.IsNullOrEmpty(dateMonthStr))
                {
                    try
                    {
                        // 解析为 DateTime 类型
                        DateTime dateTime = DateTime.ParseExact(dateMonthStr, "yyyy-MM-dd HH:mm:ss", null);

                        // 获取该月的第一天
                        startDate = new DateTime(dateTime.Year, dateTime.Month, 1); // 使用该年份和月份的第一天

                        // 获取该月的最后一天
                        endDate = startDate.AddMonths(1).AddDays(-1); // 下一月减去一天即为当前月的最后一天

                        // 格式化为字符串
                        F_LQKJ_StartDate = startDate.ToString("yyyy-MM-dd"); // 起始日期
                        F_LQKJ_EndDate = endDate.ToString("yyyy-MM-dd");     // 截止日期
                    }
                    catch (FormatException)
                    {
                        // 如果格式不正确，处理错误（例如记录日志，或给出默认值）
                        Console.WriteLine("日期格式无效: " + dateMonthStr);
                    }
                }
                else
                {
                    Console.WriteLine("日期字符串无效或格式不匹配");
                }
            }

            string tmpRpt1 = "";
            //搜索物料收发明细表的默认方案查询语句
            //string sqlBB = string.Format(@"/*dialect*/SELECT FSCHEMEID FROM T_BAS_FILTERSCHEME where FFORMID='STK_StockDetailRpt' and FSCHEMENAME='Default Scheme'");
            //搜索物料收发明细表的自定义方案查询语句（仓租报表专用）
            string sqlBB = string.Format(@"/*dialect*/SELECT FSCHEMEID FROM T_BAS_FILTERSCHEME where FFORMID='STK_StockDetailRpt' and FSCHEMENAME='仓租报表专用'");
            string schemeId = AppServiceContext.DBService.ExecuteScalar<string>(Context, sqlBB, "");//获取过滤条件框的方案
            if (string.IsNullOrWhiteSpace(schemeId))
            {
                throw new Exception("物料收发明细表没有专用过滤方案！");
            }

            IMoveReport moveReport = GetReportData(Context, "STK_StockDetailRpt", "STK_StockDetailFilter", schemeId, F_LQKJ_OrgId, F_LQKJ_StartDate,F_LQKJ_EndDate, 0);
            if (moveReport.DataSource != null)
            {
                
                tmpRpt1 = moveReport.DataSource.TableName;
                //tempdbs.Add(key, tmpRpt1);
            }

            // 定义报表字段名的列表 zds 列表将用于记录需要选择的字段及其相关信息（如类型、长度、名称等）
            zds = new List<CreateTmpTableZD>();
            // 添加多个字段的定义：字段名称、数据类型、长度、中文名称等
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_FDate", type = 4, zdcd = 500, zwName = "业务日期" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_OrgId", type = 2, zdcd = 500, zwName = "货主" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_FSTOCKQCQTY", type = 3, zdcd = 2, zwName = "期初数" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_FSTOCKINQTY", type = 3, zdcd = 2, zwName = "入库数" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_FSTOCKOUTQTY", type = 3, zdcd = 2, zwName = "出库数" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_FSTOCKJCQTY", type = 3, zdcd = 2, zwName = "库存数" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Openingvolume", type = 3, zdcd = 2, zwName = "期初体积" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Inboundvolume", type = 3, zdcd = 2, zwName = "入库体积" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Outboundvolume", type = 3, zdcd = 2, zwName = "出库体积" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Inventoryvolume", type = 3, zdcd = 2, zwName = "库存体积" });

            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Warehouse", type = 3, zdcd = 2, zwName = "仓租" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Enterfee", type = 3, zdcd = 2, zwName = "进仓费" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Warehousingfee", type = 3, zdcd = 2, zwName = "出仓费" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Cargosortingfee", type = 3, zdcd = 2, zwName = "货物分拣费" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Scanfee", type = 3, zdcd = 2, zwName = "一物一码扫码出库费" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_JDchannelfee", type = 3, zdcd = 2, zwName = "京东渠道贴标费" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Breturnfees", type = 3, zdcd = 2, zwName = "B2B退货挑选费" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Specialloading", type = 3, zdcd = 2, zwName = "特殊装货" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Inspectionfee", type = 3, zdcd = 2, zwName = "检查及包装费" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Wdbczce", type = 3, zdcd = 2, zwName = "未达标仓租差额" });
            zds.Add(new CreateTmpTableZD() { zdName = "F_LQKJ_Totalcosts", type = 3, zdcd = 2, zwName = "费用合计" });
            try
            {
                // 创建临时表格用于执行 SQL 查询
                DataTable db = CreateTmpTable();
                db.BeginInit();// 开始初始化数据表
                // 构建最终的 SQL 查询语句
                string sql = string.Format(@"/*dialect*/SELECT REPLACE(CONVERT(VARCHAR(10), T1.FDate, 111), '-', '/') AS F_LQKJ_FDate,T1.FNUMBER,ZZ.FNAME AS F_LQKJ_OrgId --组织
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, T1.FSTOCKQCQTY), '0.##'), '0') AS F_LQKJ_FSTOCKQCQTY--期初数
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, T2.FSTOCKINQTY), '0.##'), '0') AS F_LQKJ_FSTOCKINQTY--入库数
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, T2.FSTOCKOUTQTY), '0.##'), '0') AS F_LQKJ_FSTOCKOUTQTY--出库数
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, T1.FSTOCKJCQTY), '0.##'), '0') AS F_LQKJ_FSTOCKJCQTY--库存数
                                            ,ISNULL(FORMAT(T1.FSTOCKQCQTY * CASE WHEN CS.F_LQKJ_Unitvolume = 0 THEN 1 ELSE CS.F_LQKJ_Unitvolume END, '0.##'), '0') AS F_LQKJ_Openingvolume--期初体积
                                            ,ISNULL(FORMAT(T2.FSTOCKINQTY * CASE WHEN CS.F_LQKJ_Unitvolume = 0 THEN 1 ELSE CS.F_LQKJ_Unitvolume END, '0.##'), '0') AS F_LQKJ_Inboundvolume--入库体积
                                            ,ISNULL(FORMAT(T2.FSTOCKOUTQTY * CASE WHEN CS.F_LQKJ_Unitvolume = 0 THEN 1 ELSE CS.F_LQKJ_Unitvolume END, '0.##'), '0') AS F_LQKJ_Outboundvolume--出库体积
                                            ,ISNULL(FORMAT(T1.FSTOCKJCQTY * CASE WHEN CS.F_LQKJ_Unitvolume = 0 THEN 1 ELSE CS.F_LQKJ_Unitvolume END, '0.##'), '0') AS F_LQKJ_Inventoryvolume--库存体积
                                            ,ISNULL(FORMAT(CS.F_LQKJ_Warehouserent * (T1.FSTOCKJCQTY * CASE WHEN CS.F_LQKJ_Unitvolume = 0 THEN 1 ELSE CS.F_LQKJ_Unitvolume END), '0.##'), '0') AS F_LQKJ_Warehouse--仓租 
                                            ,ISNULL(FORMAT(CS.F_LQKJ_Unloadingfee * (T1.FSTOCKJCQTY * CASE WHEN CS.F_LQKJ_Unitvolume = 0 THEN 1 ELSE CS.F_LQKJ_Unitvolume END), '0.##'), '0') AS F_LQKJ_Enterfee--进仓费
                                            ,ISNULL(FORMAT(CS.F_LQKJ_Loadingfee * (T2.FSTOCKOUTQTY * CASE WHEN CS.F_LQKJ_Unitvolume = 0 THEN 1 ELSE CS.F_LQKJ_Unitvolume END), '0.##'), '0') AS  F_LQKJ_Warehousingfee--出仓费
                                            ,ISNULL(FORMAT(CS.F_LQKJ_Sortingfees * (T1.FSTOCKJCQTY * CASE WHEN CS.F_LQKJ_Unitvolume = 0 THEN 1 ELSE CS.F_LQKJ_Unitvolume END), '0.##'), '0') AS F_LQKJ_Cargosortingfee--货物分拣费
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, SS.F_LQKJ_Scanfee), '0.##'), '0') AS F_LQKJ_Scanfee--一物一码扫码出库费
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, SS.F_LQKJ_JDchannelfee), '0.##'), '0') AS F_LQKJ_JDchannelfee--京东渠道贴标费
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, SS.F_LQKJ_Breturnfees), '0.##'), '0') AS F_LQKJ_Breturnfees --B2B退货挑选费
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, SS.F_LQKJ_Specialloading), '0.##'), '0') AS F_LQKJ_Specialloading --特殊装货
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, SS.F_LQKJ_Inspectionfee), '0.##'), '0') AS F_LQKJ_Inspectionfee --检查及包装费
                                            ,ISNULL(FORMAT(CONVERT(FLOAT, SS.F_LQKJ_Wdbczce), '0.##'), '0') AS F_LQKJ_Wdbczce --未达标仓租差额
                                            ,ISNULL(FORMAT((CS.F_LQKJ_Warehouserent * (T1.FSTOCKJCQTY * CASE WHEN CS.F_LQKJ_Unitvolume = 0 THEN 1 ELSE CS.F_LQKJ_Unitvolume END)) + (CS.F_LQKJ_Unloadingfee * (T1.FSTOCKJCQTY * CASE WHEN CS.F_LQKJ_Unitvolume = 0 THEN 1 ELSE CS.F_LQKJ_Unitvolume END))
                                            + (CS.F_LQKJ_Loadingfee * (T2.FSTOCKOUTQTY * CASE WHEN CS.F_LQKJ_Unitvolume = 0 THEN 1 ELSE CS.F_LQKJ_Unitvolume END)) + (CS.F_LQKJ_Sortingfees * (T1.FSTOCKJCQTY * CASE WHEN CS.F_LQKJ_Unitvolume = 0 THEN 1 ELSE CS.F_LQKJ_Unitvolume END))
                                            + SS.F_LQKJ_Scanfee + SS.F_LQKJ_JDchannelfee + SS.F_LQKJ_Breturnfees + SS.F_LQKJ_Specialloading + SS.F_LQKJ_Inspectionfee + SS.F_LQKJ_Wdbczce, '0.##'), '0') AS F_LQKJ_Totalcosts--费用合计
                                            FROM(SELECT FDate, FNUMBER,
                                                SUM(CAST(FSTOCKQCQTY AS DECIMAL(18, 2))) AS FSTOCKQCQTY, -- 期初数量(库存)的汇总
	                                                SUM(CAST(FSTOCKJCQTY AS DECIMAL(18, 2))) AS FSTOCKJCQTY  -- 结存数量(库存)的汇总
                                            FROM(SELECT T1.FDate, -- 日期
                                                    Z.FNUMBER, --组织
                                                    T1.FMATERIALNUMBER, -- 物料编码
                                                    T1.FSTOCKNUMBER, -- 仓库
                                                    SUM(CAST(T1.FSTOCKQCQTY AS DECIMAL(18, 2))) AS FSTOCKQCQTY, -- 期初数量(库存)的汇总
	                                                SUM(CAST(T1.FSTOCKJCQTY AS DECIMAL(18, 2))) AS FSTOCKJCQTY  -- 结存数量(库存)的汇总
                                            FROM CreditStatus T1
                                            LEFT JOIN T_ORG_ORGANIZATIONS Z ON T1.FSTOCKORGID=Z.FORGID --组织表
                                            GROUP BY T1.FDate, T1.FMATERIALNUMBER, T1.FSTOCKNUMBER,Z.FNUMBER) T1
                                            GROUP BY FDate, FNUMBER) T1 
                                            LEFT JOIN (SELECT T1.FDate, -- 日期
                                                    Z.FNUMBER, --组织
                                                    SUM(CAST(T1.FSTOCKINQTY AS DECIMAL(18, 2))) AS FSTOCKINQTY, -- 收入&数量(库存)的汇总
	                                                SUM(CAST(T1.FSTOCKOUTQTY AS DECIMAL(18, 2))) AS FSTOCKOUTQTY  -- 发出&数量(库存)的汇总
                                            FROM CreditStatus T1
                                            LEFT JOIN T_ORG_ORGANIZATIONS Z ON T1.FSTOCKORGID=Z.FORGID --组织表
                                            GROUP BY T1.FDate,Z.FNUMBER)T2 ON T1.FDate=T2.FDate AND T1.FNUMBER=T2.FNUMBER
                                            LEFT JOIN LQKJ_SettupParameters CS ON 1=1
                                            LEFT JOIN T_ORG_ORGANIZATIONS Z ON Z.FNUMBER=T1.FNUMBER
                                            LEFT JOIN T_ORG_ORGANIZATIONS_L ZZ ON Z.FORGID=ZZ.FORGID AND ZZ.FLOCALEID=2052
                                            LEFT JOIN(
                                            SELECT F_LQKJ_FDATE,F_LQKJ_ORGID
                                            ,SUM(CAST(F_LQKJ_Scanfee AS DECIMAL(18, 2))) AS F_LQKJ_Scanfee--一物一码扫码出库费
                                            ,SUM(CAST(F_LQKJ_JDchannelfee AS DECIMAL(18, 2))) AS F_LQKJ_JDchannelfee--京东渠道贴标费
                                            ,SUM(CAST(F_LQKJ_Breturnfees AS DECIMAL(18, 2))) AS F_LQKJ_Breturnfees--B2B退货挑选费
                                            ,SUM(CAST(F_LQKJ_Specialloading AS DECIMAL(18, 2))) AS F_LQKJ_Specialloading--特殊装货
                                            ,SUM(CAST(F_LQKJ_Inspectionfee AS DECIMAL(18, 2))) AS F_LQKJ_Inspectionfee--检查及包装费
                                            ,SUM(CAST(F_LQKJ_Wdbczce AS DECIMAL(18, 2))) AS F_LQKJ_Wdbczce--未达标仓租差额
                                            FROM T_LQKJ_CZexpenses
                                            GROUP BY F_LQKJ_FDATE,F_LQKJ_ORGID
                                            )SS ON T1.FDate=SS.F_LQKJ_FDATE AND ZZ.FNAME=SS.F_LQKJ_ORGID");
                // 执行动态SQL查询并获取查询结果
                DynamicObjectCollection dynamics = DBUtils.ExecuteDynamicObject(Context, sql);
                
                // 创建一个新的列表，用于存储处理结果的字段名
                List<string> dynamic = new List<string>();
                // 遍历动态对象集合中的每一项
                foreach (var item in dynamics)
                
                {
                    // 创建一个新的 DataRow 用于存储每一条记录
                    DataRow dr = db.NewRow();
                    // 遍历每一个字段定义
                    foreach (var zd in zds)
                    {
                        // 根据字段类型进行数据转换并赋值给 DataRow 中相应的列
                        switch (zd.type)
                        {
                            case 1:// 如果字段类型是整数类型
                                dr[zd.zdName] = Convert.ToInt64(item[zd.zdName]);// 将字段值转换为 long 类型
                                break;
                            case 2:// 如果字段类型是字符串类型
                                dr[zd.zdName] = Convert.ToString(item[zd.zdName]);// 将字段值转换为字符串类型
                                break;
                            case 3:// 如果字段类型是数字类型
                                dr[zd.zdName] = Math.Round(Convert.ToDecimal(item[zd.zdName]), 6); // 将字段值转换为 Decimal 类型并保留6位小数
                                break;
                            case 4:// 如果字段类型是日期类型
                                if (Convert.ToDateTime(item[zd.zdName]) > Convert.ToDateTime("2000-01-01"))
                                    dr[zd.zdName] = Convert.ToString(item[zd.zdName]);// 如果日期值大于 "2000-01-01"，则将其转换为字符串类型
                                break;
                            default:
                                break;
                        }
                    }
                    // 将 DataRow 添加到 DataTable 中
                    db.Rows.Add(dr);
                }
                // 完成 DataTable 初始化
                db.EndInit();
                // 批量插入数据到数据库
                Kingdee.BOS.App.Data.DBUtils.BulkInserts(this.Context, db);
                string sqlDROP = @"DROP TABLE CreditStatus";
                DBUtils.ExecuteDynamicObject(this.Context, sqlDROP);
            }
            catch (Exception)
            {
                // 捕获异常并抛出
                throw;
            }
            finally
            {

            }
            // 最终构建一个 SELECT 查询语句，选择所有字段
            string sqlstr = @"select  " + string.Join(",", zds.Select(r => r.zdName));
            return sqlstr;
        }
        // 获取汇总列信息
        public override List<SummaryField> GetSummaryColumnInfo(IRptParams filter)
        {
            // 调用基类的 GetSummaryColumnInfo 方法获取基本的汇总列信息
            var result = base.GetSummaryColumnInfo(filter);
            // 以下是一些被注释掉的代码，表示如果需要，可以添加更多的汇总字段
            result.Add(new SummaryField("F_LQKJ_FSTOCKINQTY", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//入库数
            result.Add(new SummaryField("F_LQKJ_FSTOCKOUTQTY", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//出库数
            result.Add(new SummaryField("F_LQKJ_Inboundvolume", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//入库体积
            result.Add(new SummaryField("F_LQKJ_Inventoryvolume", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//库存体积
            result.Add(new SummaryField("F_LQKJ_Warehouse", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//仓租
            result.Add(new SummaryField("F_LQKJ_Enterfee", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//进仓费
            result.Add(new SummaryField("F_LQKJ_Warehousingfee", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//出仓费
            result.Add(new SummaryField("F_LQKJ_Cargosortingfee", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//货物分拣费
            result.Add(new SummaryField("F_LQKJ_Scanfee", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//一物一码扫码出库费
            result.Add(new SummaryField("F_LQKJ_JDchannelfee", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//京东渠道贴标费
            result.Add(new SummaryField("F_LQKJ_Breturnfees", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//B2B退货挑选费
            result.Add(new SummaryField("F_LQKJ_Specialloading", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//特殊装货
            result.Add(new SummaryField("F_LQKJ_Inspectionfee", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//检查及包装费
            result.Add(new SummaryField("F_LQKJ_Wdbczce", Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));//未达标仓租差额
            // 返回最终的汇总列信息
            return result;
        }
        //设置单据列
        public override ReportHeader GetReportHeaders(IRptParams filter)
        {
            // 创建一个新的报告头部对象
            ReportHeader header = new ReportHeader();
            // 遍历字段（zds）并根据字段的类型来添加不同的列
            foreach (var item in zds)
            {
                switch (item.type)
                {
                    // 如果字段类型为 1，则为整数类型 
                    case 1:
                        header.AddChild(item.zdName, new LocaleValue(item.zwName, this.Context.UserLocale.LCID), SqlStorageType.SqlInt);
                        break;
                    // 如果字段类型为 2，则为字符串类型
                    case 2:
                        header.AddChild(item.zdName, new LocaleValue(item.zwName, this.Context.UserLocale.LCID), SqlStorageType.Sqlvarchar);
                        break;
                    // 如果字段类型为 3，则为小数类型
                    case 3:
                        header.AddChild(item.zdName, new LocaleValue(item.zwName, this.Context.UserLocale.LCID), SqlStorageType.SqlDecimal);
                        break;
                    // 默认情况下，假设为字符串类型
                    default:
                        header.AddChild(item.zdName, new LocaleValue(item.zwName, this.Context.UserLocale.LCID), SqlStorageType.Sqlvarchar);
                        break;
                }

            }
            // 返回最终的报告头部信息
            return header;
        }
        //构建order by语句
        protected override string BuilderTempTableOrderBySQL(IRptParams filter)
        {
            string OrderBy = "";
            // 获取排序字段字符串
            string datasort = Convert.ToString(filter.FilterParameter.SortString);
            // 如果排序字段非空，则使用该字段
            if (datasort != "")
            {
                OrderBy = datasort;
            }
            else
            {
                // 如果排序字段为空，则默认按照物料代码 F_LQKJ_Materialcode 排序
                OrderBy = "F_LQKJ_FDate";
            }
            // 返回最终的ORDER BY子句
            return OrderBy;
        }

        /// <summary>
        /// 设置报表头
        /// </summary>
        /// <param name="filter">报表过滤参数</param>
        /// <returns>报表标题</returns>
        public override ReportTitles GetReportTitles(IRptParams filter)
        {
            // 创建一个ReportTitles对象来保存报表标题
            ReportTitles titles = new ReportTitles();
            // 从过滤参数中获取自定义过滤条件
            DynamicObject customFilter = filter.FilterParameter.CustomFilter;
            // 当前方法返回空的报表标题，可以在这里根据需求设置标题
            return titles;
        }

        //构建from where语句
        protected override string BuilderFromWhereSQL(IRptParams filter)
        {
            StringBuilder strwhere = new StringBuilder();
            // 从临时表生成FROM语句，Where 1=1确保查询条件可追加
            strwhere.AppendLine(string.Format(@" from {0}  Where 1=1 ", this.tmpRptTbl));
            // 获取自定义过滤条件，并移除时间戳标记 {ts ...}
            string text2 = string.IsNullOrWhiteSpace(filter.FilterParameter.FilterString) ? " " : "and" + filter.FilterParameter.FilterString.Replace("{ts", "").Replace("}", "");
            // 将过滤条件添加到WHERE子句中
            strwhere.AppendLine(text2);
            // 返回最终的FROM WHERE语句
            return strwhere.ToString();
        }
        // 创建临时表
        private DataTable CreateTmpTable()
        {
            this.tmpRptTbl = new DBService().CreateTemporaryTableName(base.Context);  // 创建临时表名
            DataTable db = new DataTable(this.tmpRptTbl);// 初始化DataTable对象
            // 列出表中所有字段
            List<string> vs = new List<string>();
            // 遍历字段配置 zds，动态构建表的列
            foreach (var item in zds)
            {
                // 创建每个字段的DataColumn
                DataColumn col = new DataColumn(item.zdName, typeof(string)); // 默认类型为string
                db.Columns.Add(col);
                // 根据字段类型设置数据库列的数据类型
                switch (item.type)
                {
                    // 如果字段类型是整数类型
                    case 1:
                        vs.Add(item.zdName + " Int");
                        break;
                    // 如果字段类型是字符串类型
                    case 2:
                        vs.Add(item.zdName + " VARCHAR(" + item.zdcd + ")");
                        break;
                    // 如果字段类型是小数类型
                    case 3:
                        vs.Add(item.zdName + " numeric(20, " + item.zdcd + ")");
                        break;
                    // 默认类型为字符串
                    default:
                        vs.Add(item.zdName + " VARCHAR(" + item.zdcd + ")");
                        break;
                }
            }
            // 根据字段定义创建SQL语句来创建临时表
            string sql = string.Format(@"CREATE TABLE {0} ( {1} );", this.tmpRptTbl, string.Join(",", vs));
            // 执行SQL语句创建临时表
            new DBService().Execute(this.Context, sql);
            // 返回创建的DataTable对象
            return db;
        }
        /// <summary>
        /// 获取分页账表数据
        /// </summary>
        /// <param name="ctx"></param>
        /// <param name="rptFormId">账表FormId</param>
        /// <param name="rptFilterFormId">账表过滤方案FormId</param>
        /// <param name="schemeId">过滤方案内码</param>
        /// <param name="currentPosition">分页账表当前位置</param>
        /// <returns></returns>
        private IMoveReport GetReportData(Context ctx, string rptFormId, string rptFilterFormId, string schemeId, string F_LQKJ_OrgId, string F_LQKJ_StartDate, string F_LQKJ_EndDate, int currentPosition)
        {
            //删除物料收发明细表临时表
            DBServiceHelper.DropTable(Context, new HashSet<string>() { tmpTableName });
            string sql = "";
            ISysReportService sysReporSservice = ServiceFactory.GetSysReportService(ctx);
            var filterMetadata = FormMetaDataCache.GetCachedFilterMetaData(ctx);//加载字段比较条件元数据。
            var reportMetadata = FormMetaDataCache.GetCachedFormMetaData(ctx, rptFormId);//加载存货收发存汇总表元数据。标准成本  最新成本：采购订单最新不含税单价
            var reportFilterMetadata = FormMetaDataCache.GetCachedFormMetaData(ctx, rptFilterFormId);//加载存货收发存汇总表过滤条件元数据。
            var reportFilterServiceProvider = reportFilterMetadata.BusinessInfo.GetForm().GetFormServiceProvider();
            var model = new SysReportFilterModel();
            model.SetContext(ctx, reportFilterMetadata.BusinessInfo, reportFilterServiceProvider);
            model.FormId = reportFilterMetadata.BusinessInfo.GetForm().Id;
            model.FilterObject.FilterMetaData = filterMetadata;
            model.InitFieldList(reportMetadata, reportFilterMetadata);
            model.GetSchemeList();
            //过滤方案的主键值，可通过该SQL语句查询得到：SELECT * FROM T_BAS_FILTERSCHEME
            var entity = model.Load(schemeId);
            var dyn = DeserializeCustomFilter(reportFilterMetadata.BusinessInfo, entity.CustomFilterSetting);
            model.DataObject = dyn;
            var filter = model.GetFilterParameter();

            //long ForgId = F_LQKJ_OrgId == null ? 0 : Convert.ToInt64(F_LQKJ_OrgId);
            DynamicObject filterObj = filter.CustomFilter;
            filterObj["StockOrgId"] = F_LQKJ_OrgId;
            if (!string.IsNullOrEmpty(F_LQKJ_StartDate) && F_LQKJ_StartDate != "")
            {
                filterObj["BeginDate"] = F_LQKJ_StartDate;
            }
            if (!string.IsNullOrEmpty(F_LQKJ_EndDate) && F_LQKJ_EndDate != "")
            {
                filterObj["EndDate"] = F_LQKJ_EndDate;
            }
            IRptParams rptParam = new RptParams();
            rptParam.FormId = reportFilterMetadata.BusinessInfo.GetForm().Id;
            rptParam.CurrentPosition = currentPosition;//分页账表当前位置
            rptParam.StartRow = 1;
            rptParam.EndRow = int.MaxValue;//StartRow和EndRow是报表数据分页的起始行数和截至行数，一般取所有数据，所以EndRow取int最大值。
            rptParam.FilterParameter = filter;
            rptParam.FilterFieldInfo = model.FilterFieldInfo;
            // var dic = new Dictionary<string, object>();
            var openParameter = new Dictionary<string, object>();

            var parameterDataFormId = reportMetadata.BusinessInfo.GetForm().ParameterObjectId;
            var parameterDataMetadata = FormMetaDataCache.GetCachedFormMetaData(ctx, parameterDataFormId);
            var parameterData = UserParamterServiceHelper.Load(ctx, parameterDataMetadata.BusinessInfo, ctx.UserId, rptFormId, KeyConst.USERPARAMETER_KEY);
            foreach (var itemProp in parameterData.DynamicObjectType.Properties)
            {
                openParameter[itemProp.Name] = parameterData[itemProp.Name];
            }
            rptParam.CustomParams.Add(KeyConst.OPENPARAMETER_KEY, openParameter);
            rptParam.ParameterData = parameterData;
            MoveReportServiceParameter param = new MoveReportServiceParameter(ctx, reportMetadata.BusinessInfo, Guid.NewGuid().ToString(), rptParam);
            using (DataTable dt = sysReporSservice.GetListAndReportData(param).DataSource)
            {
                if (dt == null || dt.Rows.Count == 0)
                {
                    string SQLcj = @"/*dialect*/CREATE TABLE CreditStatus (
                                    FDate DATETIME,               -- 日期字段
                                    FSTOCKORGID NVARCHAR(255),    -- 库存组织ID字段
                                    FMATERIALNUMBER NVARCHAR(255),-- 物料编码字段
                                    FSTOCKNUMBER NVARCHAR(255),   -- 库存编号字段
                                    FSTOCKQCQTY DECIMAL(18, 2),   -- 库存品质数量字段
                                    FSTOCKJCQTY DECIMAL(18, 2),   -- 库存件数数量字段
                                    FSTOCKINQTY DECIMAL(18, 2),   -- 入库数量字段
                                    FSTOCKOUTQTY DECIMAL(18, 2)   -- 出库数量字段
                                );";
                    DBUtils.ExecuteDynamicObject(this.Context, SQLcj);
                }
                else
                {
                    if (!checkTableIsExist(this.Context))
                    {
                        tmpTableName = createTmpTable(dt, this.Context);
                    }
                    else
                    {
                        dt.TableName = "CreditStatus";
                    }
                    //向表插入数据
                    using (KDTransactionScope scope = new KDTransactionScope(TransactionScopeOption.Required))
                    {
                        DBUtils.BulkInserts(this.Context, dt);
                        scope.Complete();
                    }
                }
                
            }
            return sysReporSservice.GetListAndReportData(param);
        }
        /// <summary>
        /// 获取自定义参数
        /// </summary>
        /// <param name="businessInfo">过滤方案元数据</param>
        /// <param name="xml"></param>
        /// <returns></returns>
        private DynamicObject DeserializeCustomFilter(BusinessInfo businessInfo, string xml)
        {
            DcxmlBinder binder = new DynamicObjectDcxmlBinder(businessInfo);
            binder.OnlyDbProperty = false;
            DcxmlSerializer target = new DcxmlSerializer(binder);
            //切换到中性语言，获取主差量
            //CultureInfo inv = new CultureInfo(2052); //中性语言
            binder.Culture = CultureInfo.InvariantCulture;// inv;
                                                          // 集合忽略主键冲突
            target.ColloctionIgnorePKValue = true;
            DynamicObject obj = (DynamicObject)target.DeserializeFromString(xml, null);
            return obj;
        }
        //创建临时表,把数据插入到临时表中
        public string createTmpTable(DataTable data, Context context)
        {
            string fieldColumnSql = GetCreateTmpTableNameSql(data.Columns);
            string tmpTableName = "CreditStatus";
            data.TableName = tmpTableName;
            TableName = tmpTableName;
            var createTmpTableSql = string.Format("create table {0} {1}", tmpTableName, fieldColumnSql);
            try
            {
                DBServiceHelper.ExecuteDataSet(context, createTmpTableSql);
            }
            catch (Exception ex)
            {
                //DBServiceHelper.Execute(context, $"DROP TABLE CreditStatus");
                //DBServiceHelper.ExecuteDataSet(context, createTmpTableSql);
            }

            return tmpTableName;
        }
        private string GetCreateTmpTableNameSql(DataColumnCollection fieldColumn)
        {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.AppendLine("(");
            List<string> listStr = new List<string>();
            foreach (var field in fieldColumn)
            {
                listStr.Add(Convert.ToString(field).Trim() + " nvarchar(1000)");
            }
            stringBuilder.AppendLine(String.Join(",", listStr.Distinct()));
            stringBuilder.AppendLine(")");
            return stringBuilder.ToString();
        }
        public bool checkTableIsExist(Context context)
        {
            string sql = "/*dialect*/select top 1 * from sysObjects where Id=OBJECT_ID(N'CreditStatus') and xtype='U'";
            DynamicObjectCollection dynamics = DBServiceHelper.ExecuteDynamicObject(context, sql);
            if (dynamics.Count > 0)
            {
                return true;
            }
            return false;
        }
        // 临时表字段信息的类
        public class CreateTmpTableZD
        {
            // 字段名
            public string zdName { get; set; }
            // 字段类型（1: 整数，2: 字符串，3: 小数）
            public int type { get; set; }
            // 字段长度/精度
            public int zdcd { get; set; }
            // 字段显示名称
            public string zwName { get; set; }
            // 字段所属实体列表
            public List<Entity> EntityList { get; set; }
        }

        // 用于定义实体类的字段
        public class Entity
        {
            // 采购订单
            public string CGDD { get; set; }
        }
    }
}
