﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.Bill;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Util;
using Kingdee.BOS.Web.Bill;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;

namespace LQKJ.K3.CZXT.Pluglus
{
    [Description("设置费用是否确认"), HotUpdate]
    public class LQKJ_Warehouserentexpenses_PLTJ : AbstractDynamicFormPlugIn
    {
        public override void AfterBindData(EventArgs e)
        {
            base.AfterBindData(e);
        }
        public override void ButtonClick(ButtonClickEventArgs e)
        {

            if (e.Key == "F_LQKJ_CONFIRMSAVE")
            {
                IBillView billView = null;
                DynamicObject rowData = this.View.Model.DataObject;
                decimal F_LQKJ_Scanfee = Convert.ToDecimal(rowData["F_LQKJ_Scanfee"]);//一物一码扫码出库费
                decimal F_LQKJ_JDchannelfee = Convert.ToDecimal(rowData["F_LQKJ_JDchannelfee"]);//京东渠道贴标费
                decimal F_LQKJ_Breturnfees = Convert.ToDecimal(rowData["F_LQKJ_Breturnfees"]);//B2B退货挑选费
                decimal F_LQKJ_Specialloading = Convert.ToDecimal(rowData["F_LQKJ_Specialloading"]);//特殊装货
                decimal F_LQKJ_Inspectionfee = Convert.ToDecimal(rowData["F_LQKJ_Inspectionfee"]);//检查及包装费
                decimal F_LQKJ_Wdbczce = Convert.ToDecimal(rowData["F_LQKJ_Wdbczce"]);//未达标仓租差额
                DateTime F_LQKJ_FDATE = Convert.ToDateTime(Convert.ToString(rowData["F_LQKJ_Date"]));//日期
                string F_LQKJ_FDATEyf = F_LQKJ_FDATE.ToString("yyyy/MM");//设置费用的年月
               // 动态获取当前日期
                DateTime currentDate = DateTime.Now;
                // 获取当前月份
                int currentMonth = currentDate.Month;
                // 从数据行中获取用户选择的日期
                DateTime selectedDate = Convert.ToDateTime(Convert.ToString(rowData["F_LQKJ_Date"]));
                // 判断逻辑
                if (selectedDate > currentDate)
                {
                    // 如果选择的日期超过当前日期，则不允许
                    this.View.ShowMessage($"只能录入{currentMonth}月之前的数据");
                }
                else if (selectedDate.Year == currentDate.Year) // 如果选择的日期是当前年份
                {
                    if (selectedDate.Month > currentDate.Month)
                    {
                        // 如果选择的日期月份超过当前月份，则不允许
                        this.View.ShowMessage($"只能录入{currentMonth}月之前的数据");
                    }
                    else if (selectedDate.Month == currentDate.Month)
                    {
                        // 如果选择的日期是当前月份，则不允许
                        this.View.ShowMessage($"只能录入{currentMonth}月之前的数据");
                    }
                    else if (selectedDate.Month == currentDate.Month - 1)
                    {
                        // 如果选择的日期是上一个月的日期，则允许
                        //Console.WriteLine("选择的日期有效。");
                    }
                }
                else if (selectedDate.Year < currentDate.Year)
                {
                    // 如果选择的日期是之前年份的日期，则允许
                    //Console.WriteLine("选择的日期有效。");
                }
                else
                {
                    // 其他情况（例如选择的日期年份超过当前年份），则不允许
                    this.View.ShowMessage($"只能录入{currentMonth}月之前的数据");
                }

                DynamicObject entityCollection = rowData["F_LQKJ_OrgId"] as DynamicObject;
                string F_LQKJ_ORGID = Convert.ToString(entityCollection["Name"]);//组织


                string sql = (@"/*dialect*/SELECT F_LQKJ_FDATE,F_LQKJ_ORGID FROM T_LQKJ_CZexpenses");
                DynamicObjectCollection dynamics = DBUtils.ExecuteDynamicObject(Context, sql);
                List<string> resultDictionary = new List<string>();
                if (dynamics.Count > 0)
                {
                    foreach (var item in dynamics)
                    {
                        DateTime parsedDate = Convert.ToDateTime(Convert.ToString(item["F_LQKJ_FDATE"]));
                        // 将其格式化为 "yyyy/MM/dd"
                        string formattedDate = parsedDate.ToString("yyyy/MM");
                        string key = formattedDate + "_" + Convert.ToString(item["F_LQKJ_ORGID"]);
                        // 将拼接后的字符串存入字典，key 为拼接后的字符串，value 可以根据需求设置（例如存储为字段的原始值，或者是某种标识符）
                        resultDictionary.Add(key);  // 或者根据需求可以存储不同的值
                    }
                }
                string dawdsfgs = string.Empty;
                dawdsfgs = F_LQKJ_FDATEyf + "_" + F_LQKJ_ORGID;// 如果报表明细日期为空，默认日期为报表单据头日期
                //// 判断 dawdsfgs 是否在 resultDictionary 中
                if (resultDictionary.Contains(dawdsfgs))
                {
                    string sqlupdate = $@"/*dialect*/UPDATE T_LQKJ_CZexpenses SET F_LQKJ_SCANFEE={F_LQKJ_Scanfee} ,F_LQKJ_JDCHANNELFEE={F_LQKJ_JDchannelfee} ,F_LQKJ_BRETURNFEES={F_LQKJ_Breturnfees} 
,F_LQKJ_SPECIALLOADING={F_LQKJ_Specialloading},F_LQKJ_INSPECTIONFEE={F_LQKJ_Inspectionfee},F_LQKJ_WDBCZCE={F_LQKJ_Wdbczce}
WHERE FORMAT(F_LQKJ_FDATE, 'yyyy/MM')='{F_LQKJ_FDATEyf}' AND F_LQKJ_ORGID='{F_LQKJ_ORGID}'";
                    //DBUtils.Execute(this.Context, sqlupdate);
                    try
                    {
                        int rowsAffected = DBUtils.Execute(this.Context, sqlupdate);
                        if (rowsAffected > 0)
                        {
                            this.View.ShowMessage("修改成功！");
                        }
                        else
                        {
                            this.View.ShowMessage("修改失败，未影响任何行！");
                        }
                    }
                    catch (Exception ex)
                    {
                        this.View.ShowMessage($"执行更新时出错: {ex.Message}");
                    }
                }
                else
                {
                    billView = CreateBillView(this.Context, "LQKJ_Warehouserentexpenses");
                    ((IBillViewService)billView).LoadData();
                    // 设置单据头部分的值

                    billView.Model.SetValue("F_LQKJ_FDate", F_LQKJ_FDATEyf, 0);// 业务日期
                    billView.Model.SetValue("F_LQKJ_OrgId", F_LQKJ_ORGID, 0);//业务组织
                    billView.Model.SetValue("F_LQKJ_Scanfee", F_LQKJ_Scanfee, 0);//一物一码扫码出库费
                    billView.Model.SetValue("F_LQKJ_JDchannelfee", F_LQKJ_JDchannelfee, 0);//京东渠道贴标费
                    billView.Model.SetValue("F_LQKJ_Breturnfees", F_LQKJ_Breturnfees, 0);//B2B退货挑选费
                    billView.Model.SetValue("F_LQKJ_Specialloading", F_LQKJ_Specialloading, 0);//特殊装货
                    billView.Model.SetValue("F_LQKJ_Inspectionfee", F_LQKJ_Inspectionfee, 0);//检查及包装费
                    billView.Model.SetValue("F_LQKJ_Wdbczce", F_LQKJ_Wdbczce, 0);//未达标仓租差额
                    //IOperationResult saveResult = billView.Model.Save();//保存单据
                    //billView.InvokeFormOperation("Submit");//提交单据
                    try
                    {
                        IOperationResult saveResult = billView.Model.Save(); // 保存单据
                        if (saveResult.IsSuccess)
                        {
                            this.View.ShowMessage("保存成功！");
                            billView.InvokeFormOperation("Submit"); // 提交单据
                        }
                        else
                        {
                            this.View.ShowMessage("保存失败: ");
                        }
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine($"保存单据时出错: {ex.Message}");
                    }
                }
            }
        }
        public override void FormClosed(FormClosedEventArgs e)
        {
            base.FormClosed(e);
            this.View.SendAynDynamicFormAction(this.View.ParentFormView);
            this.View.ParentFormView.UpdateView();
            this.View.ParentFormView.Refresh();
        }
        private BillView CreateBillView(Context ctx, string formId, string layoutId = null, object pkId = null)
        {
            var meta = (FormMetadata)Kingdee.BOS.ServiceHelper.MetaDataServiceHelper.Load(ctx, formId); //单据唯一标识
            var form = meta.BusinessInfo.GetForm();
            var param = new BillOpenParameter(formId, layoutId);
            param.Context = ctx;
            param.FormMetaData = meta;
            if (pkId != null && !string.IsNullOrWhiteSpace(pkId.ToString()))
            {
                param.Status = OperationStatus.EDIT;
                param.InitStatus = OperationStatus.EDIT;
                param.PkValue = pkId; //单据主键内码FID
            }
            else
            {
                param.Status = OperationStatus.ADDNEW;
                param.InitStatus = OperationStatus.ADDNEW;
            }
            param.SetCustomParameter("formID", form.Id);
            param.SetCustomParameter("PlugIns", form.CreateFormPlugIns()); //插件实例模型
            param.SetCustomParameter("ShowConfirmDialogWhenChangeOrg", false);
            param.NetCtrlDisable = true; // 禁用网控
            var provider = form.GetFormServiceProvider();
            var billview = (BillView)provider.GetService(typeof(IDynamicFormView));
            billview.Initialize(param, provider); //初始化
            billview.LoadData(); //加载单据数据
            return billview;
        }
    }
}
