﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.Bill;
using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;

namespace LQKJ.K3.CZXT.Pluglus
{
    [Description("加载设置费用"), HotUpdate]
    public class LQKJ_Setupfeesschedule_Edit : AbstractDynamicFormPlugIn
    {
        public override void AfterBindData(EventArgs e)
        {
            base.AfterBindData(e);

            SetF_BHR_BCGLJE(this.Context);
        }
        public override void DataChanged(DataChangedEventArgs e)
        {
            base.DataChanged(e);

            switch (e.Field.Key)
            {
                case "F_LQKJ_Date":  //收款条件
                    SetF_BHR_BCGLJE(this.Context);
                    break;
                case "F_LQKJ_OrgId":  //收款条件
                    SetF_BHR_BCGLJE(this.Context);
                    break;
            }
        }
        private void SetF_BHR_BCGLJE(Context ctx)
        {
            string F_LQKJ_FDATEyf = string.Empty;
            string F_LQKJ_ORGID = string.Empty;
            //List<DataRow> FilterValues = this.View.OpenParameter.GetCustomParameter("listData") as List<DataRow>;
            // 假设 this 是一个视图对象

            // 获取 F_LQKJ_OrgId 的值

            DynamicObject entityCollection = this.View.Model.GetValue("F_LQKJ_OrgId") as DynamicObject;
            if (entityCollection != null)
            {
                F_LQKJ_ORGID = Convert.ToString(entityCollection["Name"]); // 组织
                                                                           // 后续处理
            }

            object dateValue = this.View.Model.GetValue("F_LQKJ_Date");

            // 判断 F_LQKJ_FDATE 是否为空或无效
            DateTime F_LQKJ_FDATE;
            if (dateValue != null)
            {
                F_LQKJ_FDATE = Convert.ToDateTime(dateValue);
                // 格式化日期为年月
                F_LQKJ_FDATEyf = F_LQKJ_FDATE.ToString("yyyy/MM"); // 年月
            }
            if (!string.IsNullOrEmpty(F_LQKJ_ORGID) && !string.IsNullOrEmpty(F_LQKJ_FDATEyf))
            {
                string sql = $@"/*dialect*/SELECT * FROM T_LQKJ_CZexpenses WHERE FORMAT(F_LQKJ_FDATE, 'yyyy/MM')='{F_LQKJ_FDATEyf}' AND F_LQKJ_ORGID='{F_LQKJ_ORGID}'";
                DynamicObjectCollection dynamics = DBUtils.ExecuteDynamicObject(Context, sql);
                if (dynamics.Count > 0)
                {
                    this.View.Model.SetValue("F_LQKJ_Scanfee", Convert.ToString(dynamics[0]["F_LQKJ_Scanfee"]));
                    this.View.Model.SetValue("F_LQKJ_JDchannelfee", Convert.ToString(dynamics[0]["F_LQKJ_JDchannelfee"]));
                    this.View.Model.SetValue("F_LQKJ_Breturnfees", Convert.ToString(dynamics[0]["F_LQKJ_Breturnfees"]));
                    this.View.Model.SetValue("F_LQKJ_Specialloading", Convert.ToString(dynamics[0]["F_LQKJ_Specialloading"]));
                    this.View.Model.SetValue("F_LQKJ_Inspectionfee", Convert.ToString(dynamics[0]["F_LQKJ_Inspectionfee"]));
                    this.View.Model.SetValue("F_LQKJ_Wdbczce", Convert.ToString(dynamics[0]["F_LQKJ_Wdbczce"]));
                }
                this.View.UpdateView("F_LQKJ_Scanfee"); // 更新视图
                this.View.UpdateView("F_LQKJ_JDchannelfee");
                this.View.UpdateView("F_LQKJ_Breturnfees");
                this.View.UpdateView("F_LQKJ_Specialloading");
                this.View.UpdateView("F_LQKJ_Inspectionfee");
                this.View.UpdateView("F_LQKJ_Wdbczce");
            }
            else
            {
                this.View.Model.SetValue("F_LQKJ_Scanfee", null);
                this.View.Model.SetValue("F_LQKJ_JDchannelfee", null);
                this.View.Model.SetValue("F_LQKJ_Breturnfees", null);
                this.View.Model.SetValue("F_LQKJ_Specialloading", null);
                this.View.Model.SetValue("F_LQKJ_Inspectionfee", null);
                this.View.Model.SetValue("F_LQKJ_Wdbczce", null);
            }
        }
    }
}
