﻿using System.ComponentModel;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Util;
using Kingdee.BOS.Core.Report.PlugIn;
using System.Globalization;
using Kingdee.BOS.Core.Report.PlugIn.Args;
using System;

namespace LQKJ.K3.CZXT.Pluglus
{
    [Description("打开设置参数动态表单"), HotUpdate]
    public class LQKJ_Setparameters_TCBD : AbstractSysReportPlugIn
    {
        public override void BarItemClick(Kingdee.BOS.Core.DynamicForm.PlugIn.Args.BarItemClickEventArgs e)
        {
            //点击按钮事件
            base.BarItemClick(e);
            //当点击这个按钮,触发
            if (e.BarItemKey.Equals("LQKJ_Openit"))
            {
                //调用,动态表单
                DynamicFormShowParameter parameter = new DynamicFormShowParameter();
                parameter.OpenStyle.ShowType = ShowType.Floating;
                //调用哪个表单
                parameter.FormId = "LQKJ_Setparameters";
                //通过销售订单编号,当前打开单据的单据编号查询后台数据库
                parameter.CustomComplexParams.Add("FENTRYID", "");
                //打开的动态表单,加载进来
                this.View.ShowForm(parameter);
            }
        }

        /// <summary>
        /// 格式化单元格
        /// </summary>
        /// <param name="args"></param>
        public override void FormatCellValue(FormatCellValueArgs args)
        {
            base.FormatCellValue(args);
            if (IsFormatField(args.Header.Key))
            {
                // 格式化数字（指定小数位数+千分位符）
                args.FormateValue = GetDecimalFormatString(Convert.ToDecimal(args.DataRow[args.Header.Key]), 8);
            }
        }

        private bool IsFormatField(string fieldKey)
        {
            if (fieldKey.Equals("FSTOCKQCQTY", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("FSTOCKINQTY", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("FSTOCKOUTQTY", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("FSTOCKJCQTY", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_Openingvolume", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_Inboundvolume", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_Outboundvolume", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_Totalvolume", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_Warehouse", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_Unloading", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_Loading", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_Sorting", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_Scanfee", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_JDchannelfee", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_Breturnfees", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_Specialloading", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_Inspectionfee", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_Wdbczce", StringComparison.OrdinalIgnoreCase)) return true;
            if (fieldKey.Equals("F_LQKJ_Totalcosts", StringComparison.OrdinalIgnoreCase)) return true;

            return false;
        }



        /// <summary>
        /// 格式化数字（指定小数位数+千分位符）
        /// </summary>
        /// <param name="value"></param>
        /// <param name="digits"></param>
        /// <returns></returns>
        public static string GetDecimalFormatString(decimal value, int digits = 0)
        {
            if (digits < 0 || digits > 99) return ObjectUtils.Object2String(value);

            var formatString = "N" + digits;
            var format = (NumberFormatInfo)NumberFormatInfo.CurrentInfo.Clone();
            format.NumberNegativePattern = 1;
            format.NumberDecimalDigits = digits;
            return value.ToString(formatString, format);
        }
    }
}
