import clr
clr.AddReference('Kingdee.BOS.App')
clr.AddReference('Kingdee.BOS.Core')
clr.AddReference('Kingdee.BOS.Orm.DataEntity')

from Kingdee.BOS import *
from Kingdee.BOS.App.Data import DBUtils
from Kingdee.BOS.App.Report import ReportUtils
from Kingdee.BOS.Core import *
from Kingdee.BOS.Core.DynamicForm import *
from Kingdee.BOS.Core.DynamicForm.PlugIn import *
from Kingdee.BOS.Core.DynamicForm.PlugIn.Args import *
from Kingdee.BOS.Core.Report import *
from Kingdee.BOS.Core.Report.PlugIn import *
from Kingdee.BOS.Core.Report.PlugIn.Args import *
from Kingdee.BOS.Orm.DataEntity import DynamicObject, DynamicObjectCollection
from Kingdee.BOS.Util import *
from System import *
from System.Collections.Generic import Dictionary, KeyValuePair, List
from System.Data import DataSet, DataTable, DataRow
from System.IO import StringReader
from System.Xml.Serialization import XmlSerializer


[Description("计划任务")]
[HotUpdate]
class Executetheplan(AbstractDynamicFormPlugIn, IScheduleService):
    def Run(self, Context, SchedulePlanContext):
        """定时任务执行逻辑"""
        # 1. 获取STK_StockDetailRpt的数据
        sql = "/*dialect*/delete from T_LQKJ_CZDataSheet"
        DBUtils.Execute(Context, sql)
        sql = "/*dialect*/SELECT * FROM T_LQKJ_CZXT"
        dynamics = DBUtils.ExecuteDynamicObject(Context, sql)
        for dynamicObject in dynamics:
            F_LQKJ_StartTime = Convert.ToDateTime(dynamicObject["F_LQKJ_StartTime"])
            F_LQKJ_EndTime = Convert.ToDateTime(dynamicObject["F_LQKJ_EndTime"])
            F_LQKJ_Warehouse = Convert.ToString(dynamicObject["F_LQKJ_Warehouse"])
            F_LQKJ_Parameter = Convert.ToString(dynamicObject["F_LQKJ_Parameter"])
            F_LQKJ_Parameter2 = Convert.ToString(dynamicObject["F_LQKJ_Parameter2"])
            F_LQKJ_Parameter3 = Convert.ToString(dynamicObject["F_LQKJ_Parameter3"])
            F_LQKJ_Parameter4 = Convert.ToString(dynamicObject["F_LQKJ_Parameter4"])
            F_LQKJ_Parameter5 = Convert.ToString(dynamicObject["F_LQKJ_Parameter5"])
            F_LQKJ_Parameter6 = Convert.ToString(dynamicObject["F_LQKJ_Parameter6"])
            F_LQKJ_Parameter7 = Convert.ToString(dynamicObject["F_LQKJ_Parameter7"])
            F_LQKJ_Parameter8 = Convert.ToString(dynamicObject["F_LQKJ_Parameter8"])
            if F_LQKJ_StartTime <= DateTime.Now and F_LQKJ_EndTime >= DateTime.Now:
                if F_LQKJ_Warehouse == "仓租数据更新":
                    sql = "/*dialect*/exec SP_STK_STOCKDETAILRPT_GRP @FBEGINDATE='{0}',@FENDDATE='{1}',@FINCLUDESUPPLIER='{2}',@FCALCULATEMODE='{3}',@FORGID='{4}',@FSTORERID='{5}',@FINCLUDEUNREVIEW='{6}',@FINCLUDELOCK='{7}',@FSTOCKLOCID='{8}'".format(F_LQKJ_Parameter, F_LQKJ_Parameter2, F_LQKJ_Parameter3, F_LQKJ_Parameter4, F_LQKJ_Parameter5, F_LQKJ_Parameter6, F_LQKJ_Parameter7, F_LQKJ_Parameter8, "")
                    dataSet = DBUtils.ExecuteDataSet(Context, sql)
                    if dataSet.Tables.Count > 0:
                        table = dataSet.Tables[0]
                        for row in table.Rows:
                            F_LQKJ_StockId = Convert.ToString(row["F_LQKJ_StockId"])
                            F_LQKJ_StockNo = Convert.ToString(row["F_LQKJ_StockNo"])
                            F_LQKJ_StockName = Convert.ToString(row["F_LQKJ_StockName"])
                            F_LQKJ_StockUnit = Convert.ToString(row["F_LQKJ_StockUnit"])
                            F_LQKJ_StockQty = Convert.ToDouble(row["F_LQKJ_StockQty"])
                            F_LQKJ_FDate = Convert.ToString(row["F_LQKJ_FDate"])
                            F_LQKJ_WarehouseId = Convert.ToString(row["F_LQKJ_WarehouseId"])
                            F_LQKJ_WarehouseNo = Convert.ToString(row["F_LQKJ_WarehouseNo"])
                            F_LQKJ_WarehouseName = Convert.ToString(row["F_LQKJ_WarehouseName"])
                            F_LQKJ_SupplierId = Convert.ToString(row["F_LQKJ_SupplierId"])
                            F_LQKJ_SupplierNo = Convert.ToString(row["F_LQKJ_SupplierNo"])
                            F_LQKJ_SupplierName = Convert.ToString(row["F_LQKJ_SupplierName"])
                            F_LQKJ_UnitCube = Convert.ToDouble(row["F_LQKJ_UnitCube"])
                            F_LQKJ_UnitWeight = Convert.ToDouble(row["F_LQKJ_UnitWeight"])
                            F_LQKJ_TotalCube = Convert.ToDouble(row["F_LQKJ_TotalCube"])
                            F_LQKJ_TotalWeight = Convert.ToDouble(row["F_LQKJ_TotalWeight"])
                            F_LQKJ_CreateOrgId = Convert.ToString(row["F_LQKJ_CreateOrgId"])
                            F_LQKJ_UseOrgId = Convert.ToString(row["F_LQKJ_UseOrgId"])
                            F_LQKJ_OrganizationId = Convert.ToString(row["F_LQKJ_OrganizationId"])
                            sql = "/*dialect*/INSERT INTO T_LQKJ_CZDataSheet (F_LQKJ_StockId, F_LQKJ_StockNo, F_LQKJ_StockName, F_LQKJ_StockUnit, F_LQKJ_StockQty, F_LQKJ_FDate, F_LQKJ_WarehouseId, F_LQKJ_WarehouseNo, F_LQKJ_WarehouseName, F_LQKJ_SupplierId, F_LQKJ_SupplierNo, F_LQKJ_SupplierName, F_LQKJ_UnitCube, F_LQKJ_UnitWeight, F_LQKJ_TotalCube, F_LQKJ_TotalWeight, F_LQKJ_CreateOrgId, F_LQKJ_UseOrgId, F_LQKJ_OrganizationId) VALUES ('{0}', '{1}', '{2}', '{3}', '{4}', '{5}', '{6}', '{7}', '{8}', '{9}', '{10}', '{11}', '{12}', '{13}', '{14}', '{15}', '{16}', '{17}', '{18}')"
                            DBUtils.Execute(Context, sql.format(F_LQKJ_StockId, F_LQKJ_StockNo, F_LQKJ_StockName, F_LQKJ_StockUnit, F_LQKJ_StockQty, F_LQKJ_FDate, F_LQKJ_WarehouseId, F_LQKJ_WarehouseNo, F_LQKJ_WarehouseName, F_LQKJ_SupplierId, F_LQKJ_SupplierNo, F_LQKJ_SupplierName, F_LQKJ_UnitCube, F_LQKJ_UnitWeight, F_LQKJ_TotalCube, F_LQKJ_TotalWeight, F_LQKJ_CreateOrgId, F_LQKJ_UseOrgId, F_LQKJ_OrganizationId))

    def GetReportData(self, formId, filter, Context):
        """
        获取指定报表的数据
        """
        # 1. 反序列化过滤条件
        customFilter = self.DeserializeCustomFilter(filter)

        # 2. 设置报表参数
        reportParams = ReportUtils.GetReportParameter(formId, Context)
        if customFilter is not None and customFilter.Count > 0:
            for key, value in customFilter:
                reportParams.Params.Add(key, value)

        # 3. 执行报表查询
        dataSet = ReportUtils.ExecuteReportDataSet(formId, reportParams, Context)

        # 4. 处理报表数据
        if dataSet is not None and dataSet.Tables.Count > 0:
            # 这里可以添加对报表数据的处理逻辑
            pass

        return dataSet

    def DeserializeCustomFilter(self, filter):
        """
        反序列化自定义过滤条件
        """
        if filter is None or len(filter) == 0:
            return None

        try:
            serializer = XmlSerializer(type(Dictionary))
            with StringReader(filter) as reader:
                return serializer.Deserialize(reader)
        except Exception as ex:
            # 处理反序列化异常
            return None