import clr
clr.AddReference('Kingdee.BOS.App')
clr.AddReference('Kingdee.BOS.Core')
clr.AddReference('Kingdee.BOS.Orm.DataEntity')

from Kingdee.BOS import *
from Kingdee.BOS.App.Data import DBUtils
from Kingdee.BOS.Core import *
from Kingdee.BOS.Core.DynamicForm import *
from Kingdee.BOS.Core.DynamicForm.PlugIn import *
from Kingdee.BOS.Core.DynamicForm.PlugIn.Args import *
from Kingdee.BOS.Orm.DataEntity import DynamicObjectCollection
from Kingdee.BOS.Util import *
from System import *


[Description("加载设置参数")]
[HotUpdate]
class LQKJ_Setparameters_Edit(AbstractDynamicFormPlugIn):
    def AfterBindData(self, e):
        super(LQKJ_Setparameters_Edit, self).AfterBindData(e)

        self.SetF_BHR_BCGLJE(self.Context)

    def DataChanged(self, e):
        super(LQKJ_Setparameters_Edit, self).DataChanged(e)

        if e.Field.Key == "":  # 收款条件
            self.SetF_BHR_BCGLJE(self.Context)

    def SetF_BHR_BCGLJE(self, ctx):
        sql = "/*dialect*/SELECT * FROM LQKJ_SettupParameters"
        dynamics = DBUtils.ExecuteDynamicObject(Context, sql)
        if dynamics.Count > 0:
            # self.View.Model.SetValue("F_LQKJ_Unitvolume", Convert.ToString(dynamics[0]["F_LQKJ_Unitvolume"]))
            self.View.Model.SetValue("F_LQKJ_Warehouserent", Convert.ToString(dynamics[0]["F_LQKJ_Warehouserent"]))
            self.View.Model.SetValue("F_LQKJ_Unloadingfee", Convert.ToString(dynamics[0]["F_LQKJ_Unloadingfee"]))
            self.View.Model.SetValue("F_LQKJ_Loadingfee", Convert.ToString(dynamics[0]["F_LQKJ_Loadingfee"]))
            self.View.Model.SetValue("F_LQKJ_Sortingfees", Convert.ToString(dynamics[0]["F_LQKJ_Sortingfees"]))
        # self.View.UpdateView("F_LQKJ_Unitvolume")  # 更新视图
        self.View.UpdateView("F_LQKJ_Warehouserent")
        self.View.UpdateView("F_LQKJ_Unloadingfee")
        self.View.UpdateView("F_LQKJ_Loadingfee")
        self.View.UpdateView("F_LQKJ_Sortingfees")