import clr
clr.AddReference('Kingdee.BOS.Core')
clr.AddReference('Kingdee.BOS.Orm.DataEntity')

from Kingdee.BOS import *
from Kingdee.BOS.Core import *
from Kingdee.BOS.Core.DynamicForm import *
from Kingdee.BOS.Core.DynamicForm.PlugIn import *
from Kingdee.BOS.Core.DynamicForm.PlugIn.Args import *
from Kingdee.BOS.Core.Report.PlugIn import *
from Kingdee.BOS.Core.Report.PlugIn.Args import *
from Kingdee.BOS.Util import *
from System import *
from System.Globalization import NumberFormatInfo


[Description("打开设置参数动态表单")]
[HotUpdate]
class LQKJ_Setparameters_TCBD(AbstractSysReportPlugIn):
    def BarItemClick(self, e):
        # 点击按钮事件
        super(LQKJ_Setparameters_TCBD, self).BarItemClick(e)
        # 当点击这个按钮,触发
        if e.BarItemKey.Equals("LQKJ_Openit"):
            # 调用,动态表单
            parameter = DynamicFormShowParameter()
            parameter.OpenStyle.ShowType = ShowType.Floating
            # 调用哪个表单
            parameter.FormId = "LQKJ_Setparameters"
            # 通过销售订单编号,当前打开单据的单据编号查询后台数据库
            parameter.CustomComplexParams.Add("FENTRYID", "")
            # 打开的动态表单,加载进来
            self.View.ShowForm(parameter)

    def FormatCellValue(self, args):
        super(LQKJ_Setparameters_TCBD, self).FormatCellValue(args)
        if self.IsFormatField(args.Header.Key):
            # 格式化数字（指定小数位数+千分位符）
            args.FormateValue = self.GetDecimalFormatString(Convert.ToDecimal(args.DataRow[args.Header.Key]), 8)

    def IsFormatField(self, fieldKey):
        if fieldKey.Equals("FSTOCKQCQTY", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("FSTOCKINQTY", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("FSTOCKOUTQTY", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("FSTOCKJCQTY", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_Openingvolume", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_Inboundvolume", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_Outboundvolume", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_Totalvolume", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_Warehouse", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_Unloading", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_Loading", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_Sorting", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_Scanfee", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_JDchannelfee", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_Breturnfees", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_Specialloading", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_Inspectionfee", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_Wdbczce", StringComparison.OrdinalIgnoreCase):
            return True
        if fieldKey.Equals("F_LQKJ_Totalcosts", StringComparison.OrdinalIgnoreCase):
            return True
        return False

    @staticmethod
    def GetDecimalFormatString(value, digits=0):
        if digits < 0 or digits > 99:
            return ObjectUtils.Object2String(value)

        formatString = "N" + str(digits)
        formatInfo = NumberFormatInfo.CurrentInfo.Clone()
        formatInfo.NumberNegativePattern = 1
        formatInfo.NumberDecimalDigits = digits
        return value.ToString(formatString, formatInfo)