import clr
clr.AddReference('Kingdee.BOS.App')
clr.AddReference('Kingdee.BOS.Core')
clr.AddReference('Kingdee.BOS.Orm.DataEntity')

from Kingdee.BOS import *
from Kingdee.BOS.App.Data import DBUtils
from Kingdee.BOS.Core import *
from Kingdee.BOS.Core.DynamicForm import *
from Kingdee.BOS.Core.DynamicForm.PlugIn import *
from Kingdee.BOS.Core.DynamicForm.PlugIn.Args import *
from Kingdee.BOS.Orm.DataEntity import DynamicObject, DynamicObjectCollection
from Kingdee.BOS.Util import *
from System import *
from System.Data import DataRow


[Description("加载设置费用")]
[HotUpdate]
class LQKJ_Setupfeesschedule_Edit(AbstractDynamicFormPlugIn):
    def AfterBindData(self, e):
        super(LQKJ_Setupfeesschedule_Edit, self).AfterBindData(e)
        self.SetF_BHR_BCGLJE(self.Context)

    def DataChanged(self, e):
        super(LQKJ_Setupfeesschedule_Edit, self).DataChanged(e)

        if e.Field.Key == "F_LQKJ_Date":  # 收款条件
            self.SetF_BHR_BCGLJE(self.Context)
        elif e.Field.Key == "F_LQKJ_OrgId":  # 收款条件
            self.SetF_BHR_BCGLJE(self.Context)

    def SetF_BHR_BCGLJE(self, ctx):
        F_LQKJ_FDATEyf = ""
        F_LQKJ_ORGID = ""

        # 获取 F_LQKJ_OrgId 的值
        entityCollection = self.View.Model.GetValue("F_LQKJ_OrgId")
        if entityCollection is not None:
            F_LQKJ_ORGID = Convert.ToString(entityCollection["Name"])  # 组织

        dateValue = self.View.Model.GetValue("F_LQKJ_Date")

        # 判断 F_LQKJ_FDATE 是否为空或无效
        F_LQKJ_FDATE = None
        if dateValue is not None:
            F_LQKJ_FDATE = Convert.ToDateTime(dateValue)
            # 格式化日期为年月
            F_LQKJ_FDATEyf = F_LQKJ_FDATE.ToString("yyyy/MM")  # 年月

        if F_LQKJ_ORGID and F_LQKJ_FDATEyf:
            sql = "/*dialect*/SELECT * FROM T_LQKJ_CZexpenses WHERE FORMAT(F_LQKJ_FDATE, 'yyyy/MM')='{0}' AND F_LQKJ_ORGID='{1}'".format(F_LQKJ_FDATEyf, F_LQKJ_ORGID)
            dynamics = DBUtils.ExecuteDynamicObject(Context, sql)
            if dynamics.Count > 0:
                self.View.Model.SetValue("F_LQKJ_Scanfee", Convert.ToString(dynamics[0]["F_LQKJ_Scanfee"]))
                self.View.Model.SetValue("F_LQKJ_JDchannelfee", Convert.ToString(dynamics[0]["F_LQKJ_JDchannelfee"]))
                self.View.Model.SetValue("F_LQKJ_Breturnfees", Convert.ToString(dynamics[0]["F_LQKJ_Breturnfees"]))
                self.View.Model.SetValue("F_LQKJ_Specialloading", Convert.ToString(dynamics[0]["F_LQKJ_Specialloading"]))
                self.View.Model.SetValue("F_LQKJ_Inspectionfee", Convert.ToString(dynamics[0]["F_LQKJ_Inspectionfee"]))
                self.View.Model.SetValue("F_LQKJ_Wdbczce", Convert.ToString(dynamics[0]["F_LQKJ_Wdbczce"]))

            self.View.UpdateView("F_LQKJ_Scanfee")  # 更新视图
            self.View.UpdateView("F_LQKJ_JDchannelfee")
            self.View.UpdateView("F_LQKJ_Breturnfees")
            self.View.UpdateView("F_LQKJ_Specialloading")
            self.View.UpdateView("F_LQKJ_Inspectionfee")
            self.View.UpdateView("F_LQKJ_Wdbczce")
        else:
            self.View.Model.SetValue("F_LQKJ_Scanfee", None)
            self.View.Model.SetValue("F_LQKJ_JDchannelfee", None)
            self.View.Model.SetValue("F_LQKJ_Breturnfees", None)
            self.View.Model.SetValue("F_LQKJ_Specialloading", None)
            self.View.Model.SetValue("F_LQKJ_Inspectionfee", None)
            self.View.Model.SetValue("F_LQKJ_Wdbczce", None)