import clr
clr.AddReference('Kingdee.BOS.App')
clr.AddReference('Kingdee.BOS.Core')
clr.AddReference('Kingdee.BOS.Orm.DataEntity')

from Kingdee.BOS import *
from Kingdee.BOS.App.Data import DBUtils
from Kingdee.BOS.Core import *
from Kingdee.BOS.Core.DynamicForm import *
from Kingdee.BOS.Core.DynamicForm.PlugIn import *
from Kingdee.BOS.Core.DynamicForm.PlugIn.Args import *
from Kingdee.BOS.Orm.DataEntity import DynamicObject, DynamicObjectCollection
from Kingdee.BOS.Util import *
from System import *
from System.Data import DataRow


[Description("[表单插件]仓租费用批量提交")]
[HotUpdate]
class LQKJ_Warehouserentexpenses_PLTJ(AbstractDynamicFormPlugIn):
    def ButtonClick(self, e):
        super(LQKJ_Warehouserentexpenses_PLTJ, self).ButtonClick(e)
        if e.Key.Equals("F_BTN_ConfirmSave"):
            self.ConfirmSave(e)

    def ConfirmSave(self, e):
        """确认保存"""
        # 获取表头数据
        rowData = self.View.Model.DataObject
        F_LQKJ_Date = Convert.ToString(rowData["F_LQKJ_Date"])
        F_LQKJ_OrgId = Convert.ToString(rowData["F_LQKJ_OrgId"])

        # 获取表体数据
        collection = self.View.Model.GetEntryDataEntity("FEntity")

        # 检查是否有数据
        if collection.Count < 1:
            self.View.ShowMessage("没有需要提交的数据！")
            return

        # 遍历表体数据
        for entity in collection:
            if entity.IsDeleted is False:
                # 获取表体字段值
                F_LQKJ_Remarks = Convert.ToString(entity["F_LQKJ_Remarks"])
                F_LQKJ_Scanfee = Convert.ToDecimal(entity["F_LQKJ_Scanfee"])
                F_LQKJ_JDchannelfee = Convert.ToDecimal(entity["F_LQKJ_JDchannelfee"])
                F_LQKJ_Breturnfees = Convert.ToDecimal(entity["F_LQKJ_Breturnfees"])
                F_LQKJ_Specialloading = Convert.ToDecimal(entity["F_LQKJ_Specialloading"])
                F_LQKJ_Inspectionfee = Convert.ToDecimal(entity["F_LQKJ_Inspectionfee"])
                F_LQKJ_Wdbczce = Convert.ToDecimal(entity["F_LQKJ_Wdbczce"])

                # 查询是否已经存在相同的年月和组织
                sql = "/*dialect*/SELECT * FROM T_LQKJ_CZexpenses WHERE FORMAT(F_LQKJ_FDATE, 'yyyy/MM')='{0}' AND F_LQKJ_ORGID='{1}'".format(F_LQKJ_Date, F_LQKJ_OrgId)
                dynamics = DBUtils.ExecuteDynamicObject(self.Context, sql)
                if dynamics.Count > 0:
                    # 更新数据
                    sql = "/*dialect*/UPDATE T_LQKJ_CZexpenses SET F_LQKJ_Remarks='{0}', F_LQKJ_Scanfee='{1}', F_LQKJ_JDchannelfee='{2}', F_LQKJ_Breturnfees='{3}', F_LQKJ_Specialloading='{4}', F_LQKJ_Inspectionfee='{5}', F_LQKJ_Wdbczce='{6}' WHERE FORMAT(F_LQKJ_FDATE, 'yyyy/MM')='{7}' AND F_LQKJ_ORGID='{8}'"
                    DBUtils.Execute(self.Context, sql.format(F_LQKJ_Remarks, F_LQKJ_Scanfee, F_LQKJ_JDchannelfee, F_LQKJ_Breturnfees, F_LQKJ_Specialloading, F_LQKJ_Inspectionfee, F_LQKJ_Wdbczce, F_LQKJ_Date, F_LQKJ_OrgId))
                else:
                    # 插入数据
                    sql = "/*dialect*/INSERT INTO T_LQKJ_CZexpenses (F_LQKJ_FDATE, F_LQKJ_ORGID, F_LQKJ_Remarks, F_LQKJ_Scanfee, F_LQKJ_JDchannelfee, F_LQKJ_Breturnfees, F_LQKJ_Specialloading, F_LQKJ_Inspectionfee, F_LQKJ_Wdbczce) VALUES ('{0}', '{1}', '{2}', '{3}', '{4}', '{5}', '{6}', '{7}', '{8}')"
                    DBUtils.Execute(self.Context, sql.format(F_LQKJ_Date, F_LQKJ_OrgId, F_LQKJ_Remarks, F_LQKJ_Scanfee, F_LQKJ_JDchannelfee, F_LQKJ_Breturnfees, F_LQKJ_Specialloading, F_LQKJ_Inspectionfee, F_LQKJ_Wdbczce))

        # 显示保存成功信息
        self.View.ShowMessage("保存成功！")
        # 关闭当前表单
        self.View.Close()