import clr
clr.AddReference('Kingdee.BOS.App')
clr.AddReference('Kingdee.BOS.Core')
clr.AddReference('Kingdee.BOS.Orm.DataEntity')

from Kingdee.BOS import *
from Kingdee.BOS.App.Data import DBUtils
from Kingdee.BOS.Core import *
from Kingdee.BOS.Core.DynamicForm import *
from Kingdee.BOS.Core.DynamicForm.PlugIn import *
from Kingdee.BOS.Core.DynamicForm.PlugIn.Args import *
from Kingdee.BOS.Core.Report import *
from Kingdee.BOS.Core.Report.PlugIn import *
from Kingdee.BOS.Core.Report.PlugIn.Args import *
from Kingdee.BOS.Util import *
from System import *
from System.Collections.Generic import List
from System.Data import DataRow


[Description("[表单插件]仓租汇总报表双击某一行打开仓租明细报表")]
[HotUpdate]
class OpenitWarehousedetails(AbstractSysReportPlugIn):
    def CellDbClick(self, Args):
        super(OpenitWarehousedetails, self).CellDbClick(Args)
        # 获取选中的行
        rows = ISysReportView(self.View).SelectedDataRows
        F_LQKJ_FDate = Convert.ToString(rows[0]["F_LQKJ_FDate"])
        F_LQKJ_OrgId = Convert.ToString(rows[0]["F_LQKJ_OrgId"])
        sql = "/*dialect*/SELECT FORGID FROM T_ORG_ORGANIZATIONS_L WHERE FNAME='{0}' AND FLOCALEID=2052".format(F_LQKJ_OrgId)
        dataTable = DBUtils.ExecuteDataSet(self.Context, sql).Tables[0]
        FORGID = ""
        if dataTable.Rows.Count > 0:
            FORGID = Convert.ToString(dataTable.Rows[0][0])
        # 配置报告参数
        rptShowParam = SysReportShowParameter()
        rptShowParam.FormId = "LQKJ_Warehouserentdetails"
        rptShowParam.IsShowFilter = False
        rptShowParam.CustomParams.Add("data", F_LQKJ_FDate)
        rptShowParam.CustomParams.Add("orgId", FORGID)
        rptShowParam.OpenStyle.ShowType = ShowType.MainNewTabPage
        self.View.ShowForm(rptShowParam)