import clr
clr.AddReference('Kingdee.BOS.App')
clr.AddReference('Kingdee.BOS.Core')
clr.AddReference('Kingdee.BOS.Orm.DataEntity')

from Kingdee.BOS import *
from Kingdee.BOS.App.Data import DBUtils
from Kingdee.BOS.Core import *
from Kingdee.BOS.Core.DynamicForm import *
from Kingdee.BOS.Core.DynamicForm.PlugIn import *
from Kingdee.BOS.Core.DynamicForm.PlugIn.Args import *
from Kingdee.BOS.Core.Report import *
from Kingdee.BOS.Core.Report.PlugIn import *
from Kingdee.BOS.Core.Report.PlugIn.Args import *
from Kingdee.BOS.Util import *
from System import *
from System.Collections.Generic import Dictionary, KeyValuePair, List
from System.Data import DataRow


[Description("[表单插件]库存汇总报表")]
[HotUpdate]
class STK_StockSummaryRpt(StockSummaryRpt):
    def BuilderReportSqlAndArgs(self, e):
        super(STK_StockSummaryRpt, self).BuilderReportSqlAndArgs(e)
        # 获取 SQL
        sql = e.Sql.ToString()
        # 增加字段
        sql = sql.replace("t0.FQtyStockBase,", "t0.FQtyStockBase, t1.FUnitCube, t1.FUnitWeight, t0.FQtyStockBase * t1.FUnitCube AS FTotalCube, t0.FQtyStockBase * t1.FUnitWeight AS FTotalWeight, 0 AS F_Rent")
        # 增加联表
        sql = sql.replace("JOIN T_BD_MATERIAL_L T2 ON T0.FMATERIALID = T2.FMATERIALID AND T2.FLOCALEID = @FLOCALEID", "JOIN T_BD_MATERIAL_L T2 ON T0.FMATERIALID = T2.FMATERIALID AND T2.FLOCALEID = @FLOCALEID JOIN T_BD_MATERIAL T1 ON T0.FMATERIALID = T1.FMATERIALID")
        # 修改 SQL
        e.Sql = sql

    def AfterBindData(self, e):
        super(STK_StockSummaryRpt, self).AfterBindData(e)
        # 计算仓租
        self.CalculateRent(e)

    def CalculateRent(self, e):
        """计算仓租"""
        # 获取数据表格
        table = self.reportData.Tables[0]
        if table.Rows.Count > 0:
            # 查询参数
            sql = "/*dialect*/SELECT F_LQKJ_Warehouserent FROM T_LQKJ_SettupParameters"
            dynamics = DBUtils.ExecuteDynamicObject(Context, sql)
            if dynamics.Count > 0:
                F_LQKJ_Warehouserent = Convert.ToDecimal(dynamics[0]["F_LQKJ_Warehouserent"])
                # 遍历数据行
                for row in table.Rows:
                    FTotalCube = Convert.ToDecimal(row["FTotalCube"])
                    row["F_Rent"] = FTotalCube * F_LQKJ_Warehouserent