import clr
clr.AddReference('Kingdee.BOS.App')
clr.AddReference('Kingdee.BOS.Core')
clr.AddReference('Kingdee.BOS.Orm.DataEntity')

from Kingdee.BOS import *
from Kingdee.BOS.App.Data import DBUtils
from Kingdee.BOS.Core import *
from Kingdee.BOS.Core.DynamicForm import *
from Kingdee.BOS.Core.DynamicForm.PlugIn import *
from Kingdee.BOS.Core.DynamicForm.PlugIn.Args import *
from Kingdee.BOS.Orm.DataEntity import DynamicObject, DynamicObjectCollection
from Kingdee.BOS.Util import *
from System import *
from System.Data import DataRow


[Description("[表单插件]参数设置")]
[HotUpdate]
class Setupparameter(AbstractDynamicFormPlugIn):
    def ButtonClick(self, e):
        super(Setupparameter, self).ButtonClick(e)
        if e.Key.Equals("FBtnConfirmModify"):
            self.ConfirmModify(e)

    def ConfirmModify(self, e):
        """确认修改"""
        # 获取参数设置表单中的值
        rowData = self.View.Model.DataObject
        F_LQKJ_Warehouserent = Convert.ToDecimal(rowData["F_LQKJ_Warehouserent"])
        F_LQKJ_Handlingcharge = Convert.ToDecimal(rowData["F_LQKJ_Handlingcharge"])
        F_LQKJ_Handlingcharge2 = Convert.ToDecimal(rowData["F_LQKJ_Handlingcharge2"])
        F_LQKJ_Weighingfee = Convert.ToDecimal(rowData["F_LQKJ_Weighingfee"])
        F_LQKJ_Inspectionfee = Convert.ToDecimal(rowData["F_LQKJ_Inspectionfee"])
        F_LQKJ_Forkliftusagefee = Convert.ToDecimal(rowData["F_LQKJ_Forkliftusagefee"])
        F_LQKJ_Loadingandunloadingfee = Convert.ToDecimal(rowData["F_LQKJ_Loadingandunloadingfee"])
        F_LQKJ_Trailerusagefee = Convert.ToDecimal(rowData["F_LQKJ_Trailerusagefee"])
        F_LQKJ_Trailerusagefee2 = Convert.ToDecimal(rowData["F_LQKJ_Trailerusagefee2"])
        F_LQKJ_Stickerfee = Convert.ToDecimal(rowData["F_LQKJ_Stickerfee"])
        F_LQKJ_Palletusagefee = Convert.ToDecimal(rowData["F_LQKJ_Palletusagefee"])
        F_LQKJ_Palletusagefee2 = Convert.ToDecimal(rowData["F_LQKJ_Palletusagefee2"])

        # 验证参数值
        if F_LQKJ_Warehouserent < 0 or F_LQKJ_Handlingcharge < 0 or F_LQKJ_Handlingcharge2 < 0 or F_LQKJ_Weighingfee < 0 or F_LQKJ_Inspectionfee < 0 or F_LQKJ_Forkliftusagefee < 0 or F_LQKJ_Loadingandunloadingfee < 0 or F_LQKJ_Trailerusagefee < 0 or F_LQKJ_Trailerusagefee2 < 0 or F_LQKJ_Stickerfee < 0 or F_LQKJ_Palletusagefee < 0 or F_LQKJ_Palletusagefee2 < 0:
            self.View.ShowMessage("参数值不能为负数！")
            return

        # 更新参数设置
        sql = "/*dialect*/UPDATE T_LQKJ_SettupParameters SET F_LQKJ_Warehouserent='{0}', F_LQKJ_Handlingcharge='{1}', F_LQKJ_Handlingcharge2='{2}', F_LQKJ_Weighingfee='{3}', F_LQKJ_Inspectionfee='{4}', F_LQKJ_Forkliftusagefee='{5}', F_LQKJ_Loadingandunloadingfee='{6}', F_LQKJ_Trailerusagefee='{7}', F_LQKJ_Trailerusagefee2='{8}', F_LQKJ_Stickerfee='{9}', F_LQKJ_Palletusagefee='{10}', F_LQKJ_Palletusagefee2='{11}'"
        DBUtils.Execute(self.Context, sql.format(F_LQKJ_Warehouserent, F_LQKJ_Handlingcharge, F_LQKJ_Handlingcharge2, F_LQKJ_Weighingfee, F_LQKJ_Inspectionfee, F_LQKJ_Forkliftusagefee, F_LQKJ_Loadingandunloadingfee, F_LQKJ_Trailerusagefee, F_LQKJ_Trailerusagefee2, F_LQKJ_Stickerfee, F_LQKJ_Palletusagefee, F_LQKJ_Palletusagefee2))

        # 显示修改成功信息
        self.View.ShowMessage("参数修改成功！")