import { http } from '@/common/service/service.js' 
import configService from '@/common/service/config.service.js';
const apiService = {
	 
	 /**
	  * 登录
	  */
	login(params) {
		return http.post('/sys/login',params)	
	},
	/**
	  * 手机号码登录
	  */
	phoneNoLogin(params) {
		return http.post('/sys/phoneLogin',params);
	},
	/**
	  * 退出
	  */
	logout(params) {
		return http.post('/sys/logout',params);
	},
	/**
	 * 入库定位保存判断
	 */
	wareHouseAtSave(params){
		return http.post('/basedata/locationready/checkislocation',params)
	},
	/**
	 * 入库定位提交数据
	 */
	wareHouseAtSend(params){
		return http.post('/basedata/warehousing/addList',params)
	},
	/**
	 * 移库数据提交
	 */
	wareHouseMove(params){
		return http.put('/basedata/warehousing/updatemove',params)
	},
	/**
	 * 获取拣货数据
	 */
	getPickInfo(params){
		return http.get('/basedata/saledetailed/querypositionid?Pickingid='+params)
	},
	/**
	 * 拣货数据提交
	 */
	pickSendData(params){
		return http.put('/basedata/saledetailed/updatepicking',params)
	},
	/**
	 * 根据仓位号查询产品
	 */
	wareSelectByPositionNo(params){
		return http.get('/basedata/warehousing/querypositionid?positionid='+params.positionId+'&warehouseId='+params.warehouseId)
	},
	/**
	 * 根据产品编号查询产品
	 */
	wareSelectByWareNo(params){
		return http.get('/basedata/warehousing/seletlist?productcodeId='+params.productcodeId+'&productname='+params.productname)
	},
	/**
	 * 获取文件访问路径
	 * @param avatar
	 * @param subStr
	 * @returns {*}
	 */
	getFileAccessHttpUrl(avatar,subStr){
	    if(!subStr) subStr = 'http'
	    if(avatar && avatar.startsWith(subStr)){
	        return avatar;
	    }else{
	        return configService.staticDomainURL + "/" + avatar;
	    }
	}
};

export default apiService;
