import { http } from '@/common/service/service.js' 
import configService from '@/common/service/config.service.js';
const apiService = { 
	/**
	 * 登录
	 */
	login(params) {
		return http.post('/sys/login',params)	
	},
	/**
	  * 手机号码登录
	  */
	phoneNoLogin(params) {
		return http.post('/sys/phoneLogin',params);
	},
	/**
	  * 退出
	  */
	logout(params) {
		return http.post('/sys/logout',params);
	},
	/**
	 * 加载仓库列表-查询所有仓库
	 */
	loadingWareHouse(){
		return http.get('/basedata/warehouse/querywareAllhouseid')
	},
	/**
	 * 根据仓库查询所有仓位
	 */
	querywarehousebyid(params){
		return http.get('/basedata/warehousinglocation/QueryWareHouseId',{params})
	},
	/**
	 * 扫描仓位获取仓库仓位信息
	 */
	querywarehouseid(params){
		return http.get('/basedata/warehouse/querywarehouseid',{params})
	},
	/**
	 * 根据仓库,仓位查询产品
	 */
	queryWarehouseidAndPositionid(params){
		return http.get('/basedata/warehouse/queryWarehouseidAndPositionid',{params})
	},
	/**
	 * 根据产品编码,产品名称,仓库查询产品
	 */
	queryByProductMsg(params){
		return http.get('/basedata/warehouse/queryByProductMsg',{params})
	},
	/**
	 * 通过储位id查询
	 */
	queryByPositionId(params){
		return http.get('/basedata/warehousing/queryByPositionId',{params})
	},
	/**
	 * 移库数据提交
	 */
	updateHouseWareHouse(params){
		return http.post('/basedata/warehousing/updateHouseWareHouse',params)
	},
	/**
	 * 根据入库单号和仓库查询入库单的产品列表
	 */
	queryproductlist(params){
		return http.get('/basedata/warehousinglocation/QueryProductList',{params})
	}
};

export default apiService;
