import store from '../store/index.js'
const baseUrl = "http://192.168.1.24:8080/wmssystem"
function getRequest(url,params){
	let promise = new Promise( (resolve,reject) => {
		let data = params
		uni.request({
			url:baseUrl + url,
			data:data,
			method:"GET",
			header:{
				"content-type":'application/json;charset=UTF-8',
				"X-Access-Token":store.state.token
			},
			success:function(res){
				resolve(res)
			},
			fail:function(err){
				reject(err)
			}
		})
	} )
	return promise
}

function postRequest(url,params){
	let promise = new Promise( (resolve,reject) => {
		let data = JSON.parse(params)
		uni.request({
			url:baseUrl + url,
			data:data,
			method:"POST",
			header:{
				"content-type":'application/json;charset=UTF-8',
				"X-Access-Token":store.state.token
			},
			success:function(res){
				resolve(res)
			},
			fail:function(err){
				reject(err)
			}
		})
	} )
	return promise
}

module.exports = {
	getRequest,
	postRequest
}