import Request from '@/common/luch-request/index.js'
import {ACCESS_TOKEN} from '@/common/util/constants.js'
import configService from './config.service.js'
import store from '@/store/index.js';
import tips from '@/api/my-tips.js'

let apiUrl = configService.apiUrl;
const getTokenStorage = () => {
	let token = ''
	try{
		token = uni.getStorageSync(ACCESS_TOKEN)
	}catch(e){
		//TODO handle the exception
	}
	return token
}



const http = new Request()
http.setConfig((config) => { /* 设置全局配置 */
  config.baseUrl = apiUrl /* 根域名不同 */
  config.header = {
    ...config.header
  }
  return config
})

/**
 * 自定义验证器，如果返回true 则进入响应拦截器的响应成功函数(resolve)，否则进入响应拦截器的响应错误函数(reject)
 * @param { Number } statusCode - 请求响应体statusCode（只读）
 * @return { Boolean } 如果为true,则 resolve, 否则 reject
 */
// 有默认，非必写
http.validateStatus = (statusCode) => {
  return statusCode === 200
}

http.interceptor.request((config, cancel) => { /* 请求之前拦截器 */
  config.header = {
    ...config.header,
    'X-Access-Token':getTokenStorage()
  }
  /*
  if (!token) { // 如果token不存在，调用cancel 会取消本次请求，但是该函数的catch() 仍会执行
    cancel('token 不存在') // 接收一个参数，会传给catch((err) => {}) err.errMsg === 'token 不存在'
  }
  */
  return config
})

// 必须使用异步函数，注意
http.interceptor.response(async (response) => { /* 请求之后拦截器 */
  // if (response.data.code !== 200) { // 服务端返回的状态码不等于200，则reject()
  //   return Promise.reject(response)
  // }
  return response
}, (response) => {
	// 请求错误做点什么
	if(response){
		console.log(response)
		const token = uni.getStorageSync('token')
		if(response.statusCode == 404){
			tips.errorTip("请求页不存在!!!(404)")
			store.state.loading = false
			return response
		}
		if(response.errMsg == "request:fail"){
			tips.errorTip("请求失败,请检查网络")
			store.state.loading = false
			return response
		}
		switch(response.data.status) {
			case 403:
				tips.errorTip("拒绝访问");
				store.state.loading = false
				break
			case 500:
				if(!token || response.data.message == "Token失效，请重新登录"){
					let timeout = setTimeout(tips.errorTip('登陆已过期'),5000)
					store.dispatch('Logout').then( () => {
						clearTimeout(timeout)
						window.location.reload()
					})
				}
				break
			case 404:
				tips.errorTip("页面不存在(404)")
				store.state.loading = false
				break
			case 504:
				tips.errorTip("网关超时(504)")
				store.state.loading = false
				break
			case "request:fail":
				tips.errorTip("连接超时(TIME_OUT)")
				store.state.loading = false
				break
		}
		return response
	}else{
		tips.errorTip("请求失败,请稍后重试")
	}
})

export {
  http
}
