// router.js
import {RouterMount,createRouter} from 'uni-simple-router';
import { ACCESS_TOKEN,USER_NAME,USER_INFO } from "@/common/util/constants"
const router = createRouter({
	platform: process.env.VUE_APP_PLATFORM,  
	routes: [...ROUTES]
});

const whiteList = ['/pages/login/login']
//全局路由前置守卫
router.beforeEach((to, from, next) => {
	let LocalToken = uni.getStorageSync('token')
	if(LocalToken || uni.getStorageSync(ACCESS_TOKEN)){
		next();
	}else{
		if(whiteList.indexOf(to.path) !== -1){
			next();
		}else{
			next({ path: '/pages/login/login'})
			uni.removeStorageSync('token')
			uni.removeStorageSync(ACCESS_TOKEN)
		}
	}
});
// 全局路由后置守卫
router.afterEach((to, from) => {
    
})

export {
	router,
	RouterMount
}