import Vue from 'vue';
import Vuex from 'vuex';
import createPersistedState from 'vuex-persistedstate';

// 用户模块
import user from './modules/user';

// 商品模板
import templateModule from './modules/template';

// 发布订单
import publish from './modules/publish';

// 订单相关
import order from './modules/order';

Vue.use(Vuex);

const vuexPersisted = new createPersistedState({
    storage: {
        getItem: key => uni.getStorageSync(key),
        setItem: (key, value) => uni.setStorageSync(key, value),
        removeItem: key => uni.removeStorageSync(key)
    }
});

const store = new Vuex.Store({
    plugins: [vuexPersisted],
    modules: {
        user,
        templateModule,
        publish,
        order
    }
});

Vue.prototype.$store = store;
export default store;
