const state = {
    detail: null,
    address: null,
    templates: []
};

const mutations = {
    UPDATE_DETAIL: (state, provider) => {
        state.detail = provider;
    },
    UPDATE_ADDRESS: (state, provider) => {
        state.address = provider;
    },
    IMPORT_TEMPLATES:(state, provider) => {
        state.templates = provider;
    },
    CLEAR: state => {
        state.detail = null;
        state.address = null;
    }
};

const actions = {
    updatePublishDetail({ commit }, data) {
        commit('UPDATE_DETAIL', data);
    },
    updatePublishAddress({ commit }, data) {
        commit('UPDATE_ADDRESS', data);
    },
    importTemplates({ commit }, data) {
        commit('IMPORT_TEMPLATES', data);
    },
    clearPublish({ commit }) {
        commit('CLEAR');
    }
};

const getters = {
    publishDetail: state => state.detail,
    publishAddress: state => state.address,
    templates: state => state.templates
};

export default {
    namespaced: true,
    state,
    mutations,
    actions,
    getters
};
