const state = {
    list: [],
    current: null
};

const mutations = {
    UPDATE_LIST: (state, provider) => {
        state.list = provider;
    },
    UPDATE_CURRENT: (state, provider) => {
        state.current = provider;
    },
    CLEAR: state => {
        state.list = [];
        state.current = null;
    }
};

const actions = {
    updateTemplateList({ commit }, data) {
        commit('UPDATE_LIST', data);
    },
    updateCurrentTemplate({ commit }, data) {
        commit('UPDATE_CURRENT', data);
    },
    clearTemplate({ commit }) {
        commit('CLEAR');
    }
};

const getters = {
    templates: state => state.list,
    currentTemplate: state => state.current
};

export default {
    namespaced: true,
    state,
    mutations,
    actions,
    getters
};
