import Vue from "vue";
import mandMobile from "mand-mobile/lib/mand-mobile.esm";
import "mand-mobile/lib/mand-mobile.css";
import ElementUI from 'element-ui';
import 'element-ui/lib/theme-chalk/index.css';
import VueAMap from 'vue-amap';
import App from "./App.vue";
import router from "./router";
import store from "./store";
import "normalize.css";

Vue.config.productionTip = false;

Vue.use(mandMobile);
Vue.use(ElementUI);
Vue.use(VueAMap);

VueAMap.initAMapApiLoader({
  key: 'd0e9772a7ff78b0eda90ef747eb7e642',
  plugin: ['AMap.Autocomplete', 'AMap.PlaceSearch', 'AMap.Scale', 'AMap.OverView', 'AMap.ToolBar', 'AMap.MapType', 'AMap.PolyEditor', 'AMap.CircleEditor'],
  // 默认高德 sdk 版本为 1.4.4
  v: '1.4.4'
});

new Vue({
  router,
  store,
  render: (h) => h(App),
}).$mount("#app");
