const state = {
    currentOrder: null,
    currentWorker: null,
    currentStatus: 0
};

const mutations = {
    UPDATE_CURRENT: (state, provider) => {
        state.currentOrder = provider;
    },
    UPDATE_WORKER: (state, provider) => {
        state.currentWorker = provider;
    },
    CLEAR: state => {
        state.currentOrder = null;
        state.currentWorker = null;
    },
    UPDATE_CURRENT_STATUS: (state, provider)  => {
        state.currentStatus = provider;
    },
};

const actions = {
    updateCurrentOrder({ commit }, data) {
        commit('UPDATE_CURRENT', data);
    },
    updateCurrentWorker({ commit }, data) {
        commit('UPDATE_WORKER', data);
    },
    clearOrder({ commit }) {
        commit('CLEAR');
    },
    updateCurrentStatus({ commit }, data) {
        commit('UPDATE_CURRENT_STATUS', data);
    },
};

const getters = {
    currentOrder: state => state.currentOrder,
    currentWorker: state => state.currentWorker,
    currentStatus: state => state.currentStatus,
};

export default {
    namespaced: true,
    state,
    mutations,
    actions,
    getters
};
