const state = {
    login: false,
    wxDetail: null,
    isRegister: false,
    other: {
        Id: '',
        Number: ''
    },
    userDetail: null
};

const mutations = {
    LOGIN: (state, provider) => {
        state.login = true;
        state.isRegister = provider.isRegister;
        state.userDetail = provider.userDetail;
    },
    LOGOUT: state => {
        state.login = false;
        state.wxDetail = null;
        state.isRegister = false;
        state.apiToken = '';
        state.other = {
            Id: '',
            Number: ''
        };
        state.userDetail = null;
        state.extra = null;
    },
    UPDATE_WXINFO: (state, provider) => {
        state.wxDetail = provider;
    },
    UPDATE_OTHER: (state, provider) => {
        state.other = provider;
    },
    UPDATE_REGISTER_STATUS: (state, provider) => {
        state.isRegister = provider;
    },
    UPDATE_USER_DETAIL: (state, provider) => {
        state.userDetail = provider;
    }
};

const actions = {
    login({ commit }, data) {
        commit('LOGIN', data);
    },
    logout({ commit }) {
        commit('LOGOUT');
    },
    updateWXInfo({ commit }, data) {
        commit('UPDATE_WXINFO', data);
    },
    updateOtherInfo({ commit }, data) {
        commit('UPDATE_OTHER', data);
    },
    updateRegisterStatus({ commit }, status) {
        commit('UPDATE_REGISTER_STATUS', status);
    },
    updateUserDetail({ commit }, data) {
        commit('UPDATE_USER_DETAIL', data);
    }
};

const getters = {
    login: state => state.login,
    wxDetail: state => state.wxDetail,
    isRegister: state => state.isRegister,
    userDetail: state => state.userDetail,
    displayUserInfo: state => {
        if (!state.userDetail) {
            return {
                name: '',
                phone: '',
                balance: 0
            };
        }
        const currentUser = state.userDetail.FCustBusinessMember.length > 1 ? state.userDetail.FCustBusinessMember.find(x => x.FIsManager) : state.userDetail.FCustBusinessMember[0];
        return {
            name: currentUser.FRealName,
            phone: currentUser.FPHONE,
            balance: state.userDetail.FBalanceAmount,
            userType: state.userDetail.FUserType === '1' ? '个人' : '企业用户',
            isManager: currentUser.FIsManager,
            avator: currentUser.FUserImage
        };
    }
};

export default {
    namespaced: true,
    state,
    mutations,
    actions,
    getters
};
