module.exports = {
		// 基本路径 baseURL已经过时
		publicPath: './',
		// 输出文件目录
		outputDir: 'dist',
		// eslint-loader 是否在保存的时候检查
		lintOnSave: true,
		// use the full build with in-browser compiler?
		// https://vuejs.org/v2/guide/installation.html#Runtime-Compiler-vs-Runtime-only
		// compiler: false,
		// webpack配置
		// see https://github.com/vuejs/vue-cli/blob/dev/docs/webpack.md
		chainWebpack: () => {},
		configureWebpack: () => {},
		// vue-loader 配置项
		// https://vue-loader.vuejs.org/en/options.html
		// vueLoader: {},
		// 生产环境是否生成 sourceMap 文件
		productionSourceMap: true,
		// css相关配置
		css: {
			// 是否使用css分离插件 ExtractTextPlugin
			extract: true,
			// 开启 CSS source maps?
			sourceMap: false,
			// css预设器配置项
			loaderOptions: {},
			// 启用 CSS modules for all css / pre-processor files.
			modules: false
		},
		// use thread-loader for babel & TS in production build
		// enabled by default if the machine has more than 1 cores
		parallel: require('os').cpus().length > 1,
		// 是否启用dll
		// See https://github.com/vuejs/vue-cli/blob/dev/docs/cli-service.md#dll-mode
		// dll: false,
		// PWA 插件相关配置
		// see https://github.com/vuejs/vue-cli/tree/dev/packages/%40vue/cli-plugin-pwa
		pwa: {},
		// webpack-dev-server 相关配置
		devServer: {
			// proxy: {
			// 	'/baiduApi': {
			// 		target: 'https://aip.baidubce.com', //访问地址
			// 		changeOrigin: true,
			// 		secure: false, //只有代理https 地址需要次选项
			// 		pathRewrite: {
			// 			'^/baiduApi': '/'
			// 		}
			// 	},
			// },
			// overlay: { // 让浏览器 overlay 同时显示警告和错误
			// 	warnings: true,
			// 	errors: true
			// },
			// host: "localhost",
			// port: 8080, // 端口号
			// https: false, // https:{type:Boolean}
			// open: false, //配置后自动启动浏览器
			// hotOnly: true, // 热更新
			// // proxy: 'http://localhost:8080',  // 配置跨域处理,只有一个代理
			// proxy: { //配置多个代理
			// 	// "/testIp": {
			// 	// 	target: "http://197.0.0.1:8088",
			// 	// 	changeOrigin: true,
			// 	// 	ws: true, //websocket支持
			// 	// 	secure: false,
			// 	// 	pathRewrite: {
			// 	// 		"^/testIp": "/"
			// 	// 	}
			// 	// },
			// 	// "/elseIp": {
			// 	// 	target: "http://197.0.0.2:8088",
			// 	// 	changeOrigin: true,
			// 	// 	//ws: true,//websocket支持
			// 	// 	secure: false,
			// 	// 	pathRewrite: {
			// 	// 		"^/elseIp": "/"
			// 	// 	},

			// 	// },
			// 	"/baiduApi": {
			// 	target: "https://aip.baidubce.com", //访问地址
			// 	changeOrigin: true,
			// 	ws: true,
			// 	secure: false, //只有代理https 地址需要次选项
			// 	pathRewrite: {
			// 		'^/baiduApi': '/'
			// 		}
			// 	},
		// }
	},
	// 第三方插件配置
	pluginOptions: {
		// ...
	}
}
