import request from '../request/request'


export function getAction(url, params) {
	return request({
		method: 'GET',
		url: url,
		params: params
	})
}

export function postAction(url, params) {
	return request({
		method: 'POST',
		url: url,
		headers: {
			'Content-Type': 'application/json;charset=UTF-8'
		},
		data: params
	})
}
//地址识别
export function recognizedata(url, params) {
	return request({
		method: 'POST',
		url: url,
		headers: {
			'Content-Type': 'application/json;charset=UTF-8'
		},
		data: params
	})
}
/**
 * 
 * @description 获取行政区信息API(来源:高德地图)
 * @important 如果无法访问,请自行更换API(自己注册,自己搞)
 * @author Ras
 * 
 */
export function getBoroughs() {
	let params = {
		key: '2564f6ab105b9193d25f7a9b8e1facd9',
		address: '中国',
		subdistrict: 3,
		extensions: 'base'
	}
	let url = 'https://restapi.amap.com/v3/config/district'
	return request({
		method: 'GET',
		url: url,
		params: params
	})
}
