import axios from 'axios';
import {Message} from 'element-ui';
import store from '../store/index'
const service = axios.create({
    baseURL:'http://116.62.129.2:8090',
    timeout: 5000
});

//请求拦截器
service.interceptors.request.use((config) => {
    //请求前干点啥
    return config
},(error) => {
    Message({
        message:"请求失败",
        type:"error",
        center:true
    })
    Promise.reject(error)
})


//响应拦截器
service.interceptors.response.use((res) => {
    if(res.status == 200){
        store.state.loading = false
        return res
    }else{
        Message({
            message:res.statusText,
            type:'error'
        })
        return res
    }
},(error) => {
    if(error == 'Error: Network Error'){
        Message({
            message:"网络异常,请检查网络连接状态",
            type:'error',
            center:true
        })
        return Promise.reject(error)
    }else{
        return Promise.reject(error)
    }
})

export default service