﻿using Kingdee.BOS.Core.Log;
using Kingdee.BOS.ServiceHelper;
using Kingdee.BOS.Util;
using Kingdee.BOS.WebApi.Client;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;



namespace LQKJ.K3.IScheduleServicePlugIn
{
    [HotUpdate, Description("执行计划")]
    public class IsCheduleServicePlugIn : Kingdee.BOS.Contracts.IScheduleService
    {
        //public string url = "http://192.168.0.242:89/k3cloud/";
        //public string dbid = "64243c12d1eb7a";
        //public string pwd = "kingdee@123";
        public string url = Kingdee.BOS.KDConfiguration.Current.CommonConfiguration.AppSettings.Settings["Url"].Value;
        public string dbid = Kingdee.BOS.KDConfiguration.Current.CommonConfiguration.AppSettings.Settings["Dbid"].Value;
        public string pwd = Kingdee.BOS.KDConfiguration.Current.CommonConfiguration.AppSettings.Settings["passWord"].Value;
        public string login = Kingdee.BOS.KDConfiguration.Current.CommonConfiguration.AppSettings.Settings["login"].Value;
        //public string url = "http://192.168.0.90/ndr/";
        //public string dbid = "640aea3709a243";
        //public string pwd = "kingdee$2023";
        public void Run(Kingdee.BOS.Context ctx, Kingdee.BOS.Core.Schedule schedule)
        {
            var Hour = DateTime.Now.Hour;
            var Time = DateTime.Now.ToString("yyyyMM");

            var Day = DateTime.Now.Day;
            if (Hour == 12 && Day == 1)
            {
               string sql2 = $"select * from LQKJ_t_KAIZHANGSTATE";
                if (DBServiceHelper.ExecuteDataSet(ctx, sql2).Tables[0].Rows.Count == 0)
                {
                    sql2 = $"insert LQKJ_t_KAIZHANGSTATE(FID, F_LQKJ_TEXT,F_LQKJ_TEXT1,F_LQKJ_TEXT2,F_LQKJ_TEXT3) values(1, 'false','{Time}','false','false')";
                    DBServiceHelper.ExecuteDataSet(ctx, sql2);
                }
                else
                {
                    sql2 = $"update LQKJ_t_KAIZHANGSTATE set F_LQKJ_TEXT='false',F_LQKJ_TEXT1='{Time}',F_LQKJ_TEXT2='false',F_LQKJ_TEXT3='false' where FID=1";
                    DBServiceHelper.ExecuteDataSet(ctx, sql2);
                }
            }
            string date = DateTime.Now.AddMonths(-1).ToString("yyyy-MM");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.Append("{\"Ids\":\"");
            string sql = string.Format("/*dialect*/select FID from LQKJ_T_PROJECTHOURS where convert(varchar(7),F_LQKJ_DATE2,120)='{0}'", date);
            DataTable dt = DBServiceHelper.ExecuteDataSet(ctx, sql).Tables[0];//查表

            if (dt.Rows.Count > 0)
            {
                stringBuilder.Append(dt.Rows[0]["FID"].ToString());
                if (dt.Rows.Count > 1)
                {
                    for (int i = 1; i < dt.Rows.Count; i++)
                    {
                        stringBuilder.Append(","+dt.Rows[i]["FID"].ToString());
                    }
                }
                stringBuilder.Append("\"}");
                string parmeters = JsonConvert.SerializeObject(stringBuilder.ToString());
                string parmeters2 = stringBuilder.ToString();
                //parmeters = JsonConvert.DeserializeObject(parmeters).ToString();
                K3CloudApiClient client = new K3CloudApiClient(url);
                var loginResult = client.ValidateLogin(dbid, "Administrator", pwd, 2052);
                var resultType = JObject.Parse(loginResult)["LoginResultType"].Value<int>();
                if (resultType == 1)
                {
                    JObject result = JObject.Parse(client.Submit("LQKJ_XMGSDJ", parmeters2));
                    string r = "提交失败";
                    if(result["Result"]["ResponseStatus"]["IsSuccess"].ToString() == "True")
                    {
                        r = "提交成功";
                    }
                    var logs = new List<LogObject>();
                    var log = new LogObject();
                    log.pkValue = "0";
                    log.Description = r;
                    log.OperateName = "项目工时";
                    log.ObjectTypeId = "BOS_SCHEDULETYPE";
                    log.SubSystemId = "BOS";
                    log.Environment = OperatingEnvironment.BizOperate;
                    logs.Add(log);
                    new Kingdee.BOS.App.LogService.Log().BatchWriteLog(ctx, logs);
                }
            }
            
        }
    }
}
