﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Log;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Util;
using Kingdee.K3.FIN.GL.App.Report;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;

namespace LQKJ.K3.NDR.NewReportPlugIn
{
    [HotUpdate,Description("科目余额表")]
   public class AccountBalanceReportPlugIn: AccountBalanceService
    {

        public override void BuilderReportSqlAndTempTable(IRptParams filter, string tableName)
        {
            base.BuilderReportSqlAndTempTable(filter, tableName);
        }
        protected override DataTable GetReportData(string tablename, IRptParams filter)
        {
            Dictionary<string, object> fiterstrings = (Dictionary<string, object>)filter.CustomParams.FirstOrDefault().Value;//CustomParams中拿到传过来的参数
            var fiterstring = fiterstrings.Where(e => e.Key == "Flag").ToList();
            if (fiterstring.Count != 0)
            {
                List<SqlObject> sqlObjects = new List<SqlObject>();
                //开始年份
                var StartYear = filter.FilterParameter.CustomFilter[4];
                //截至年份
                var EndYear = filter.FilterParameter.CustomFilter[6];
                //开始期间
                var StartMonth = filter.FilterParameter.CustomFilter[5];
                //截至期间
                var EndMonth = filter.FilterParameter.CustomFilter[7];
                string InsertSql = "";
                string Temporary = $"select * into #temporary from {tablename} ";//将数据插入临时表
                string sql = $" select FCyName,FDETAILID,FDEBITLOCAL,FACCOUNTID from #temporary where FF100003_NUMBER='00000'";//查询临时表的数据
                string DeleteSql = $@"delete from LQKJ_t_KMYESJ where F_LQKJ_STARTYEAR={StartYear} and F_LQKJ_ENDYEAR={EndYear} and F_LQKJ_STARTMONTH={StartMonth} and F_LQKJ_ENDMONTH={EndMonth}";
                DBUtils.Execute(this.Context, DeleteSql);//删掉原来有的数据
                DataTable dt = DBUtils.ExecuteDataSet(this.Context, Temporary + sql).Tables[0];
                foreach (DataRow item in dt.Rows)
                {
                    string FCyName = item["FCyName"].ToString();//币别
                    string FDETAILID = item["FDETAILID"].ToString();//借方金额
                    decimal FDEBITLOCAL = decimal.Parse(item["FDEBITLOCAL"].ToString());//核算维度
                    string FACCOUNTID = item["FACCOUNTID"].ToString();//科目类别
                    InsertSql = $"insert into LQKJ_t_KMYESJ(FID,F_LQKJ_STARTYEAR,F_LQKJ_ENDYEAR,F_LQKJ_STARTMONTH,F_LQKJ_ENDMONTH,F_LQKJ_HSWD,F_LQKJ_BB,F_LQKJ_AMOUNT,F_LQKJ_KM) values(newid(),{StartYear},{EndYear},{StartMonth},{EndMonth},{FDETAILID},'{FCyName}',{FDEBITLOCAL},{FACCOUNTID})";
                    sqlObjects.Add(new SqlObject(InsertSql, new List<SqlParam>()));
                }
                DBUtils.ExecuteBatch(this.Context, sqlObjects);//批量执行数据库语句
            }
            return DBUtils.ExecuteDataSet(this.Context, $"select * from {tablename}").Tables[0];
        }
        public override void CloseReport()
        {
            base.CloseReport(); 
        }
    }
}
