﻿using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.DynamicForm;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Globalization;
using System.Linq;
using System.Text;

namespace LQKJ.K3.NDR.NewReportPlugIn
{
    [HotUpdate,Description("科目余额动态表单")]
   public class AccountDynamic: AbstractDynamicFormPlugIn
    {
        public static bool Flag = false;
        public static string TemporaryName = "";

        public override void AfterUpdateViewState(EventArgs e)
        {
            base.AfterUpdateViewState(e);
            
        }
        public override void BeforeShowImportResultMessage(BeforeShowImportResultMessageArgs e)
        {
            base.BeforeShowImportResultMessage(e);
        }
        
        public override void ButtonClick(ButtonClickEventArgs e)
        {
            base.ButtonClick(e);
            string Date = this.View.Model.GetValue("F_LQKJ_YM").ToString();
            int Year = int.Parse(DateTime.ParseExact(Date, "yyyyMM", CultureInfo.InvariantCulture).Year.ToString());//年
            int Month = int.Parse(DateTime.ParseExact(Date, "yyyyMM", CultureInfo.InvariantCulture).Month.ToString());//期间 
            if (e.Key.Equals("FBTNOK"))
            {
                string SelectAccount = $"select * from LQKJ_t_KMYESJ where {Year} between F_LQKJ_STARTYEAR and F_LQKJ_ENDYEAR and {Month} between F_LQKJ_STARTMONTH and F_LQKJ_ENDMONTH";
                DataTable dt = DBUtils.ExecuteDataSet(this.Context, SelectAccount).Tables[0];
                if (dt.Rows.Count == 0)
                {
                    bool flag = false;
                    e.Cancel = true;//取消当前事件继续执行
                    this.View.Model.ParameterData = null;
                    this.View.Model.OpenParameter = null;
                    this.View.ShowMessage("当前年份期间没有数据，请点击确定跳转至科目余额表勾选未过账金额", MessageBoxOptions.YesNo, new Action<MessageBoxResult>((result) =>
                      {
                          if (result == MessageBoxResult.Yes)
                          {
                              SysReportShowParameter billShowPara2 = new SysReportShowParameter();//打开表单类型
                              billShowPara2.OpenStyle.ShowType = ShowType.MainNewTabPage;//这个是打开方式
                              //billShowPara2.ParentPageId = this.View.ParentFormView.PageId;
                              billShowPara2.ParentPageId = this.View.PageId;
                              billShowPara2.FormId = "GL_RPT_AccountBalance";//目标表单标识
                              billShowPara2.CustomComplexParams["Flag"] = flag;
                              flag = true;
                              this.View.ShowForm(billShowPara2);//打开表单
                              return;
                          }
                          else
                          {
                              return;
                          }
                          
                      }));
                }
            }else if (e.Key.Equals("F_LQKJ_BUTTON"))//清空当前年月数据
            {
                string DeleteSql = $"delete from LQKJ_t_KMYESJ where {Year} between F_LQKJ_STARTYEAR and F_LQKJ_ENDYEAR and {Month} between F_LQKJ_STARTMONTH and F_LQKJ_ENDMONTH";
                DBUtils.Execute(this.Context, DeleteSql);
                this.View.ShowMessage("清空数据成功");
            }
        }
        public override void ToolBarItemClick(BarItemClickEventArgs e)
        {
            base.ToolBarItemClick(e);
        }

    }
}
