﻿using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

namespace LQKJ.K3.NDR.NewReportPlugIn
{
    [HotUpdate, Description("部门分摊费用")]
    public class DepartmentApportionReportPlugIn : AbstractBillPlugIn
    {
        public override void OnLoad(EventArgs e)
        {
            BindData();
            base.OnLoad(e);
        }
        public void BindData()
        {
            string sql = $@"select 部门编码,部门,FPERIOD,FYEAR,sum(研发费用_租金_房屋租金)研发费用_租金_房屋租金,sum(研发费用_租金_宿舍租金)研发费用_租金_宿舍租金
                            ,sum(研发费用_水电费)研发费用_水电费,sum(研发费用_物业管理费)研发费用_物业管理费,sum(研发费用_办公费)研发费用_办公费,sum(研发费用_福利费)研发费用_福利费
                            ,sum(研发费用_折旧费)研发费用_折旧费,sum(研发费用_服务费_装修服务费)研发费用_服务费_装修服务费,
							sum(研发费用_人工成本_工资)研发费用_人工成本_工资,sum(研发费用_人工成本_奖金)研发费用_人工成本_奖金,
							sum(研发费用_人工成本_社保费_工伤保险费)研发费用_人工成本_社保费_工伤保险费,sum(研发费用_人工成本_社保费_生育保险费)研发费用_人工成本_社保费_生育保险费,
							sum(研发费用_人工成本_社保费_失业保险费)研发费用_人工成本_社保费_失业保险费,sum(研发费用_人工成本_社保费_医疗保险费)研发费用_人工成本_社保费_医疗保险费,
							sum(研发费用_人工成本_社保费_养老保险费)研发费用_人工成本_社保费_养老保险费,sum(研发费用_人工成本_住房公积金)研发费用_人工成本_住房公积金,
							sum(研发费用_差旅费)研发费用_差旅费,sum(研发费用_差旅费_出差补助)研发费用_差旅费_出差补助,sum(研发费用_低值易耗品)研发费用_低值易耗品,
							sum(研发费用_电信费)研发费用_电信费,sum(研发费用_其他服务费_维修服务费)研发费用_其他服务费_维修服务费,sum(研发费用_招待费)研发费用_招待费,
							sum(研发费用_邮递费)研发费用_邮递费,sum(研发费用_研发材料费)研发费用_研发材料费
							from (
                            Select d.FNUMBER as 部门编码,e.FNAME 部门,FPERIOD,FYEAR,case a.FACCOUNTID when 128849 then  FDEBIT end as 研发费用_租金_房屋租金
                            ,case a.FACCOUNTID when 128862 then  FDEBIT end as 研发费用_租金_宿舍租金,case a.FACCOUNTID when 128737 then  FDEBIT end as 研发费用_水电费
                            ,case a.FACCOUNTID when 128863 then  FDEBIT end as 研发费用_物业管理费,case a.FACCOUNTID when 128739 then  FDEBIT end as 研发费用_办公费
                            ,case a.FACCOUNTID when 128870 then  FDEBIT end as 研发费用_福利费,case a.FACCOUNTID when 128742 then  FDEBIT end as 研发费用_折旧费
                            ,case a.FACCOUNTID when 128768 then  FDEBIT end as 研发费用_服务费_装修服务费,case a.FACCOUNTID when 128766 then  FDEBIT end as 研发费用_人工成本_工资
							,case a.FACCOUNTID when 128869 then  FDEBIT end as 研发费用_人工成本_奖金,case a.FACCOUNTID when 128901 then  FDEBIT end as 研发费用_人工成本_社保费_工伤保险费
							,case a.FACCOUNTID when 128902 then  FDEBIT end as 研发费用_人工成本_社保费_生育保险费,case a.FACCOUNTID when 128900 then  FDEBIT end as 研发费用_人工成本_社保费_失业保险费
							,case a.FACCOUNTID when 128898 then  FDEBIT end as 研发费用_人工成本_社保费_养老保险费,case a.FACCOUNTID when 128899 then  FDEBIT end as 研发费用_人工成本_社保费_医疗保险费
							,case a.FACCOUNTID when 128868 then  FDEBIT end as 研发费用_人工成本_住房公积金,case a.FACCOUNTID when 128861 then  FDEBIT end as 研发费用_差旅费
							,case a.FACCOUNTID when 128861 then  FDEBIT end as 研发费用_差旅费_出差补助,case a.FACCOUNTID when 128741 then  FDEBIT end as 研发费用_低值易耗品
							,case a.FACCOUNTID when 128735 then  FDEBIT end as 研发费用_电信费,case a.FACCOUNTID when 128865 then  FDEBIT end as 研发费用_其他服务费_维修服务费
							,case a.FACCOUNTID when 128736 then  FDEBIT end as 研发费用_招待费,case a.FACCOUNTID when 128740 then  FDEBIT end as 研发费用_邮递费
							,case a.FACCOUNTID when 128738 then  FDEBIT end as 研发费用_研发材料费
							From T_GL_Balance a 
                            left join T_BD_FLEXITEMDETAILV c on a.FDETAILID=c.FID
                            left join T_BD_DEPARTMENT d on c.FFLEX5=d.FDEPTID
                            left join T_BD_DEPARTMENT_L e on d.FDEPTID=e.FDEPTID
                            where  FCURRENCYID=1 --人民币
                            and a.FDETAILID!=0
                            and FPERIOD=month(getdate())--当期,借方本位币金额
                            )T
                            group by 部门编码,部门,FPERIOD,FYEAR";
            IEnumerable<System.Data.IDataRecord> dataRecords = DBUtils.ExecuteEnumerable(this.Context, sql);
            int i = 0;
            foreach (System.Data.IDataRecord item in dataRecords)
            {
                this.View.Model.CreateNewEntryRow("F_LQKJ_Entity");
                this.View.Model.SetItemValueByNumber("F_LQKJ_BMNUMBER", item["部门编码"].ToString(), i);
                this.View.Model.SetItemValueByNumber("F_LQKJ_BM", item["部门编码"].ToString(), i);
                this.View.Model.SetItemValueByNumber("F_LQKJ_ITEM", "00000", i);
                this.View.Model.SetValue("F_LQKJ_YF", item["研发费用_租金_房屋租金"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_SS", item["研发费用_租金_宿舍租金"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_SDF", item["研发费用_水电费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_WY", item["研发费用_物业管理费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_BG", item["研发费用_办公费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_FL", item["研发费用_福利费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_ZJ", item["研发费用_折旧费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_ZX", item["研发费用_服务费_装修服务费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_GZ", item["研发费用_人工成本_工资"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_JJ", item["研发费用_人工成本_奖金"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_BX", item["研发费用_人工成本_社保费_工伤保险费"].ToString(), i);

                this.View.Model.SetValue("F_LQKJ_SY", item["研发费用_人工成本_社保费_生育保险费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_SYBX", item["研发费用_人工成本_社保费_失业保险费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_YL", item["研发费用_人工成本_社保费_养老保险费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_YLBX", item["研发费用_人工成本_社保费_医疗保险费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_ZF", item["研发费用_人工成本_住房公积金"].ToString(), i);

                this.View.Model.SetValue("F_LQKJ_CL", item["研发费用_差旅费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_CC", item["研发费用_差旅费_出差补助"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_DZ", item["研发费用_低值易耗品"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_DX", item["研发费用_电信费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_WX", item["研发费用_其他服务费_维修服务费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_ZD", item["研发费用_招待费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_YD", item["研发费用_邮递费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_YFCL", item["研发费用_研发材料费"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_Text", item["FPERIOD"].ToString(), i);
                this.View.Model.SetValue("F_LQKJ_Text1", item["FYEAR"].ToString(), i);
                i++;
            }

        }
    }
}
