﻿using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.DynamicForm.PlugIn.ControlModel;
using Kingdee.BOS.JSON;
using Kingdee.BOS.ServiceHelper.Excel;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;

namespace LQKJ.K3.NDR.NewReportPlugIn
{
    [HotUpdate,Description("引入部门科目信息")]
   public class DynamicFormPlugIn: AbstractDynamicFormPlugIn
    {
        DataTable dtexcel;
        private string _filePath;

        public override void ButtonClick(ButtonClickEventArgs e)
        {
            base.ButtonClick(e);    
            if(e.Key== "F_LQKJ_BUTTON")
            {
                if (IsNotNull())
                {
                    Impoort();
                    this.View.ShowMessage("导入完成");
                    return;
                }
            }
        }
        
        private void Impoort()
        {
            ExcelOperation excelOperation = new ExcelOperation();
            DataSet dataSet = null;
            dataSet = excelOperation.ReadFromFile(this._filePath, 0, 0);
            //在dataSet中获取一个Table的表中的数据
            dtexcel = dataSet.Tables["Sheet1"];
            List<SqlObject> sqlObjects = new List<SqlObject>();
            for (int i = 1; i < dtexcel.Rows.Count; i++)
            {
               string sql1 = "delete from LQKJ_T_BMKMDYB";
                DBUtils.Execute(this.Context, sql1);
                if (dtexcel.Rows[i][0].ToString() != "")
                {
                    //更新销售出库单T_SAL_OUTSTOCK, 运单号F_YDH = 导入的运单号
                    string BM = dtexcel.Rows[i]["部门名称"].ToString();
                    string NUM= dtexcel.Rows[i]["部门编号"].ToString();
                    string TP = dtexcel.Rows[i]["类别"].ToString();
                    string JD = dtexcel.Rows[i]["借贷"].ToString();
                    string FW = dtexcel.Rows[i]["房屋租金"].ToString();
                    string SS = dtexcel.Rows[i]["宿舍租金"].ToString();
                    string SD = dtexcel.Rows[i]["水电费"].ToString();
                    string WY = dtexcel.Rows[i]["物业管理费"].ToString();
                    string BG = dtexcel.Rows[i]["办公费"].ToString();
                    string FL = dtexcel.Rows[i]["福利费"].ToString();
                    string ZJ = dtexcel.Rows[i]["折旧费"].ToString();
                    string ZX = dtexcel.Rows[i]["装修服务费"].ToString();
                    string GZ = dtexcel.Rows[i]["工资"].ToString();
                    string YL = dtexcel.Rows[i]["养老保险费"].ToString();
                    string JJ = dtexcel.Rows[i]["奖金"].ToString();
                    string GS = dtexcel.Rows[i]["工伤保险费"].ToString();
                    string SY = dtexcel.Rows[i]["生育保险费"].ToString();
                    string SYBX = dtexcel.Rows[i]["失业保险费"].ToString();
                    string YLBX = dtexcel.Rows[i]["医疗保险费"].ToString();
                    string ZF = dtexcel.Rows[i]["住房公积金"].ToString();
                    string CL = dtexcel.Rows[i]["差旅费"].ToString();
                    string CCBZ = dtexcel.Rows[i]["出差补助"].ToString();
                    string DZ = dtexcel.Rows[i]["低值易耗品"].ToString();
                    string DX = dtexcel.Rows[i]["电信费"].ToString();
                    string WX = dtexcel.Rows[i]["维修服务费"].ToString();
                    string YF = dtexcel.Rows[i]["研发材料费"].ToString();
                    string YD = dtexcel.Rows[i]["邮递费"].ToString();
                    string ZD = dtexcel.Rows[i]["招待费"].ToString();
                   string sql = $@"insert into LQKJ_T_BMKMDYB(FID,F_LQKJ_DEP,F_LQKJ_NUMBER,F_LQKJ_TYPE,F_LQKJ_JIEDAI,F_LQKJ_FW,F_LQKJ_SS,F_LQKJ_SD
                        ,F_LQKJ_WY,F_LQKJ_BG,F_LQKJ_FL,F_LQKJ_ZJ,F_LQKJ_ZX,F_LQKJ_GZ,F_LQKJ_YL,F_LQKJ_JJ,F_LQKJ_GS,F_LQKJ_SYBX,F_LQKJ_SY,F_LQKJ_YLBX,F_LQKJ_ZF,F_LQKJ_CL,F_LQKJ_CCBZ,F_LQKJ_DZ,F_LQKJ_DX,F_LQKJ_WX,F_LQKJ_YF,F_LQKJ_YD,F_LQKJ_ZD) 
                        values(newid(),'{BM}','{NUM}','{TP}','{JD}','{FW}','{SS}','{SD}','{WY}','{BG}','{FL}','{ZJ}','{ZX}','{GZ}','{YL}','{JJ}','{GS}','{SYBX}'
                        ,'{SY}','{YLBX}','{ZF}','{CL}','{CCBZ}','{DZ}','{DX}','{WX}','{YF}','{YD}','{ZD}')";
                    sqlObjects.Add(new SqlObject(sql, new List<Kingdee.BOS.SqlParam>()));
                }
            }
            DBUtils.ExecuteBatch(this.Context, sqlObjects);
            this.View.ShowMessage("上传完成");
        }
        private bool IsNotNull()
        {
            ExcelOperation excelOperation = new ExcelOperation();
            DataSet dataSet = null;
            dataSet = excelOperation.ReadFromFile(this._filePath, 0, 0);
            dtexcel = dataSet.Tables["Sheet1"];
            if (dtexcel == null)
            {
                this.View.ShowMessage("没有找到模板请重新选择");
                return false;

            }
            return true;
        }
        //自定义方法,文件上传完毕触发的事件
        public override void CustomEvents(CustomEventsArgs e)
        {
            if (e.Key.EqualsIgnoreCase("F_LQKJ_FileUpdate"))
            {
                if (e.EventName.EqualsIgnoreCase("FILECHANGED"))
                {
                    JSONObject jSONObject = KDObjectConverter.DeserializeObject<JSONObject>(e.EventArgs);
                    if (jSONObject != null)
                    {
                        JSONArray jSONArray = new JSONArray(jSONObject["NewValue"].ToString());
                        if (jSONArray.Count > 0)
                        {
                            string text = (jSONArray[0] as Dictionary<string, object>)["ServerFileName"].ToString();
                            if (this.CheckFile(text))
                            {
                                this._filePath = this.GetFilePath(text);
                                //上传按钮变成可用状态
                                this.EnableButton("F_LQKJ_Button", true);
                            }
                        }
                        else
                        {
                            this.EnableButton("F_LQKJ_Button", false);
                        }
                    }
                }
                else
                {
                    if (e.EventName.EqualsIgnoreCase("STATECHANGED"))
                    {
                        JSONObject jSONObject2 = KDObjectConverter.DeserializeObject<JSONObject>(e.EventArgs);
                        if (jSONObject2["State"].ToString() != "2")
                        {
                            this.EnableButton("F_LQKJ_Button", false);
                        }
                    }
                }
            }
            base.CustomEvents(e);
        }
        private void EnableButton(string key, bool bEnable)
        {
            this.View.GetControl<Button>(key).Enabled = bEnable;
        }

        private bool CheckFile(string fileName)
        {
            bool flag = false;
            string[] array = fileName.Split(new char[]
            {
                '.'
            });
            //通过后缀名,判断是否是Excel
            if (array.Length == 2 && (array[1].EqualsIgnoreCase("xls") || array[1].EqualsIgnoreCase("xlsx")))
            {
                flag = true;
            }
            if (!flag)
            {
                this.View.ShowWarnningMessage("请选择正确的文件进行引入");
            }
            return flag;
        }
        private string GetFilePath(string serverFileName)
        {
            string directory = "FileUpLoadServices\\UploadFiles";
            return PathUtils.GetPhysicalPath(directory, serverFileName);
        }
    }
}
