﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.DynamicForm.PlugIn.ControlModel;
using Kingdee.BOS.Core.Metadata;
using Kingdee.BOS.Core.Metadata.FieldElement;
using Kingdee.BOS.Util;
using Kingdee.BOS.WebApi.Client;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;


namespace LQKJ.K3.NDR.NewReportPlugIn
{
    [HotUpdate, Description("动态表单")]
    public class OpenDynamicReport : AbstractDynamicFormPlugIn
    {
        public override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            string sql = "select F_LQKJ_TEXT1, F_LQKJ_TEXT,F_LQKJ_TEXT2,F_LQKJ_TEXT3  from LQKJ_t_KAIZHANGSTATE";
            int i = 2;
            DataTable dt = DBUtils.ExecuteDataSet(this.Context, sql).Tables[0];
            if (dt.Rows.Count > 0)
            {

            
            this.View.Model.SetValue("F_LQKJ_Text",dt.Rows[0]["F_LQKJ_TEXT1"].ToString());
            this.View.Model.SetValue("F_LQKJ_CheckBox", dt.Rows[0]["F_LQKJ_TEXT2"].ToString());
                this.View.Model.SetValue("F_LQKJ_HOLIDAY", dt.Rows[0]["F_LQKJ_TEXT3"].ToString());
            if(dt.Rows[0]["F_LQKJ_TEXT"].ToString() == "打开")
            {
                i = 1;
            }
            this.View.Model.SetValue("F_LQKJ_Combo1",i.ToString());
            this.View.UpdateView("F_LQKJ_Combo1");
            }
        }
        public override void BarItemClick(BarItemClickEventArgs e)
        {
            base.BarItemClick(e);
            if (e.BarItemKey.Equals("LQKJ_tbButton_1"))
            {
                string enumName1 = this.View.Model.GetValue("F_LQKJ_Text").ToString();//月份
                string ZhouM = this.View.Model.GetValue("F_LQKJ_CheckBox").ToString();//周末
                string Holiday = this.View.Model.GetValue("F_LQKJ_HOLIDAY").ToString();//节假日
                try
                {

                    if (int.Parse(enumName1) > Convert.ToInt32(DateTime.Now.ToString("yyyyMM")))
                    {
                        this.View.ShowErrMessage("输入的月份有误!");
                        return;
                    }
                    string sql = string.Empty;
                    var field = this.View.BusinessInfo.GetField("F_LQKJ_Combo1") as ComboField;
                    string enumName = field.GetEnumItemName(this.Model.GetValue("F_LQKJ_Combo1")).ToString();//状态下拉框选中值
                    if (enumName == "关账")
                    {
                        sql = $"select * from LQKJ_t_KAIZHANGSTATE where F_LQKJ_TEXT1='{enumName1}'";
                        if (DBUtils.ExecuteDataSet(this.Context, sql).Tables[0].Rows.Count == 0)
                        {
                            this.View.ShowErrMessage($"'{enumName1}暂未开账'");
                            return;
                        }
                    }
                    sql = $"select * from LQKJ_t_KAIZHANGSTATE";
                    if (DBUtils.ExecuteDataSet(this.Context, sql).Tables[0].Rows.Count == 0)
                    {
                        sql = $"insert LQKJ_t_KAIZHANGSTATE(FID, F_LQKJ_TEXT,F_LQKJ_TEXT1,F_LQKJ_TEXT2,F_LQKJ_TEXT3) values(1, '{enumName}','{enumName1}','{ZhouM}','{Holiday}')";
                        DBUtils.Execute(this.Context, sql);
                    }
                    else
                    {
                        sql = $"update LQKJ_t_KAIZHANGSTATE set F_LQKJ_TEXT='{enumName}',F_LQKJ_TEXT1='{enumName1}',F_LQKJ_TEXT2='{ZhouM}',F_LQKJ_TEXT3='{Holiday}' where FID=1";
                        DBUtils.Execute(this.Context, sql);
                    }
                }
                catch (Exception ex )
                {
                     this.View.ShowErrMessage("日期格式不正确!正确格式如:202301");
                    return;
                }
                 this.View.ShowMessage("修改成功");
            }
        }
    }
}
