﻿using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Util;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;

namespace LQKJ.K3.NDR.NewReportPlugIn
{
    [HotUpdate, Description("生产部门工时汇总插件")]
    public class WorktimeSummaryReportPlugIn : AbstractBillPlugIn
    {
        private string sql = string.Empty;
        public override void BarItemClick(BarItemClickEventArgs e)//点击操作
        {
            base.BarItemClick(e);

            if (e.BarItemKey.Equals("LQKJ_tbBtnSum"))//点击汇总按钮
            {
                if (this.View.Model.GetValue("F_LQKJ_Date") != null)
                {

                    string Date = this.View.Model.GetValue("F_LQKJ_Date").ToString();//获取日期
                    sql = string.Format(@"/*dialect*/
                                            select FPRODUCTNUMBER,FPROJECTNUMBER,FLENDINGDEPARTMENT,FENGINEER,sum(FMANHOUR) FMANHOUR,F_LQKJ_WORKCONTAINER,F_LQKJ_DEPARTMENT,F_LQKJ_TYPE from LQKJ_T_WorkAssignmentEntry
                                            left join LQKJ_t_CONTRAST b on LQKJ_T_WorkAssignmentEntry.F_LQKJ_WORKCONTAINER=b.F_LQKJ_ASSISTANT
	                                        where FDATE='{0}'group by FPRODUCTNUMBER,FPROJECTNUMBER,FLENDINGDEPARTMENT,FENGINEER,FMANHOUR,F_LQKJ_WORKCONTAINER,F_LQKJ_DEPARTMENT,F_LQKJ_TYPE", Date);
                    int i = 0;
                    IEnumerable<IDataRecord> dataRecords = DBUtils.ExecuteEnumerable(this.Context, sql);
                    foreach (IDataRecord item in dataRecords)
                    {

                        this.View.Model.CreateNewEntryRow("FEntity");
                        this.View.Model.SetValue("F_LQKJ_DEPARTMENT", item["F_LQKJ_DEPARTMENT"].ToString(), i);
                        this.View.Model.SetItemValueByID("F_LQKJ_WOEKCONTAINER", item["F_LQKJ_WORKCONTAINER"].ToString(), i);
                        this.View.Model.SetValue("F_LQKJ_FNumber", item["FPRODUCTNUMBER"].ToString(), i);
                        this.View.Model.SetValue("F_LQKJ_FItem", item["FPROJECTNUMBER"].ToString(), i);
                        this.View.Model.SetValue("F_LQKJ_DEPARTMENT2", item["FLENDINGDEPARTMENT"].ToString(), i);
                        this.View.Model.SetValue("F_LQKJ_FName", item["FENGINEER"].ToString(), i);
                        this.View.Model.SetValue("F_LQKJ_WORKTIME", item["FMANHOUR"].ToString(), i);
                        //this.View.Model.SetItemValueByID("F_LQKJ_CostType", item["F_LQKJ_TYPE"].ToString(), i);
                        i++;
                    }
                    this.View.Model.ClearNoDataRow();
                }
                else
                {
                    this.View.ShowWarnningMessage("请选择汇总日期");
                }
            }
        }
        public override void DataChanged(DataChangedEventArgs e)//值更新操作
        {
            base.DataChanged(e);
            if (e.Field.Key.Equals("F_LQKJ_WOEKCONTAINER"))
            {   //e.Row改变当前行索引
                if (this.View.Model.GetValue("F_LQKJ_WOEKCONTAINER") != null)
                {
                    string Id = (this.View.Model.GetValue("F_LQKJ_WOEKCONTAINER", e.Row) as DynamicObject)["Id"].ToString();
                    string sql1 = string.Format("select F_LQKJ_TYPE from LQKJ_t_CONTRAST where F_LQKJ_ASSISTANT='{0}'", Id);
                    DynamicObjectCollection dynamic = DBUtils.ExecuteDynamicObject(this.Context, sql1);
                    if (dynamic.Count > 0)
                    {
                        this.View.Model.SetValue("F_LQKJ_CostType", dynamic[0]["F_LQKJ_TYPE"].ToString(), e.Row);
                    }
                    else
                    {
                        this.View.Model.SetValue("F_LQKJ_CostType", null, e.Row);
                    }
                    this.View.UpdateView("F_LQKJ_WOEKCONTAINER");
                }

            }
        }
    }
}
