﻿using Kingdee.BOS.App;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Contracts;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Util;
using Kingdee.K3.SCM.App.Sal.Report;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;

namespace LQKJ.K3.NDR.ReportPlugIn
{
    [HotUpdate, Description("销售订单执行明细表")]
    public class SalDetailRptPlugIn : SalDetailRpt
    {
        private string[] TempTableName;
        public override void BuilderReportSqlAndTempTable(IRptParams filter, string tableName)
        {
            IDBService dBService = ServiceHelper.GetService<IDBService>();
            TempTableName = dBService.CreateTemporaryTableName(this.Context, 1);
            string strTable = TempTableName[0];
            base.BuilderReportSqlAndTempTable(filter, strTable);
            StringBuilder sb = new StringBuilder();
            string strSql = @"/*dialect*/
                            select t1.*,t6.FDATAVALUE as F_LQKJ_PRODUCTLINE,t3.FNUMBER as F_LQKJ_ITEM,t4.FNAME as F_LQKJ_CUSTOMER,t2.F_PJXX_TEXT as F_LQKJ_CUSTOMERORDER
								into {0} from {1} t1 left join (select a.FBILLNO,b.FSEQ,b.F_PJXX_BASE1,b.FENTRYID,a.F_PJXX_BASE,F_PJXX_TEXT,b.F_PJXX_ASSISTANT from  T_SAL_ORDER a left join T_SAL_ORDERENTRY b on a.FID=b.FID 
                                )t2 on t1.FBILLNO=t2.FBILLNO  and t1.FORDERID=t2.FENTRYID 
								left join T_BAS_PREBDONE t3 on t3.FID=t2.F_PJXX_BASE1
								left join T_BD_CUSTOMER_L t4 on t4.FCUSTID=t2.F_PJXX_BASE 
                                left join T_BAS_ASSISTANTDATAENTRY_L t6 on t6.FENTRYID=t2.F_PJXX_ASSISTANT";
            sb.AppendFormat(strSql, tableName, strTable);
            DBUtils.Execute(this.Context, sb.ToString());
        }
        public override void CloseReport()
        {
            if (TempTableName == null || TempTableName.Length == 0)
            {
                return;
            }
            IDBService dBService = ServiceHelper.GetService<IDBService>();
            dBService.DeleteTemporaryTableName(this.Context, TempTableName);
            base.CloseReport();
        }
    }
}
