﻿using Kingdee.BOS.App;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Contracts;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Util;
using Kingdee.K3.SCM.App.Sal.Report;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;

namespace LQKJ.K3.NDR.ReportPlugIn
{
    [HotUpdate, Description("销售出库明细报表")]
    public class SaleOutStockDetailRptPlugIn : SaleOutStockDetailRpt
    {
        private string[] TempTableName;
        public override void BuilderReportSqlAndTempTable(IRptParams filter, string tableName)
        {
            IDBService dBService = ServiceHelper.GetService<IDBService>();
            TempTableName = dBService.CreateTemporaryTableName(this.Context, 1);
            string strTable = TempTableName[0];
            base.BuilderReportSqlAndTempTable(filter, strTable);
            StringBuilder sb = new StringBuilder();
            string strSql = @"/*dialect*/
                            select t1.*,t4.FNAME as F_LQKJ_CUSTOMER,t6.FDATAVALUE as F_LQKJ_PRODUCTLINE,t3.FNUMBER as F_LQKJ_ITEM,t2.F_PJXX_TEXT as F_LQKJ_CUSTOMERORDER
                            into {0} from {1} t1 left join (select FENTRYID,a.FID,b.F_PJXX_BASE1,a.F_PJXX_BASE,b.F_PJXX_ASSISTANT,b.F_PJXX_TEXT from T_SAL_OUTSTOCK a left join T_SAL_OUTSTOCKENTRY b on a.FID=b.FID)
                            t2 on t1.FID=t2.FID and t1.FENTRYID=t2.FENTRYID and FBILLNAME!='应收单' 
                            left join  T_BAS_PREBDONE t3 on t3.FID=t2.F_PJXX_BASE1
                            left join T_BD_CUSTOMER_L t4 on t2.F_PJXX_BASE=t4.FCUSTID left join T_BAS_ASSISTANTDATAENTRY_L t6 on t6.FENTRYID=t2.F_PJXX_ASSISTANT";
            sb.AppendFormat(strSql, tableName, strTable);
            string sql = "select * from " + strTable;
            DBUtils.Execute(this.Context, sql);
            DBUtils.Execute(this.Context, sb.ToString());
        }
        public override void CloseReport()
        {
            if (TempTableName == null || TempTableName.Length == 0)
            {
                return;
            }
            IDBService dBService = ServiceHelper.GetService<IDBService>();
            dBService.DeleteTemporaryTableName(this.Context, TempTableName);
            base.CloseReport();
        }
    }
}
