﻿using Kingdee.BOS.App;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Contracts;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Util;
using Kingdee.K3.SCM.App.Sal.Report;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;

namespace LQKJ.K3.NDR.ReportPlugIn
{
    [HotUpdate, Description("销售出库汇总报表")]
    public class SaleOutStockSummaryRptPlugIn: SaleOutStockSummaryRpt
    {
        private string[] TempTableName;
        public override void BuilderReportSqlAndTempTable(IRptParams filter, string tableName)
        {
            IDBService dBService = ServiceHelper.GetService<IDBService>();
            TempTableName = dBService.CreateTemporaryTableName(this.Context, 1);
            string strTable = TempTableName[0];
            base.BuilderReportSqlAndTempTable(filter, strTable);

            StringBuilder sb = new StringBuilder();

            string strSql = @"/*dialect*/
                            select t1.*,t2.F_PJXX_BASE as F_LQKJ_CUSTOMER,t3.F_PJXX_BASE1 as F_LQKJ_ITEM
                            into {0} from {1} t1 left join T_SAL_OUTSTOCK t2 on t1.FSALERID=t2.FSALERID left join  T_SAL_OUTSTOCKENTRY t3 on t3.FID=t2.FID";
            sb.AppendFormat(strSql, tableName, strTable);
            string sql = string.Format(@"/*dialect*/ select *   {0}", strTable);
            //DataTable dt = DBUtils.ExecuteDataSet(this.Context, sql).Tables[0];
            DBUtils.Execute(this.Context, sql);
            DBUtils.Execute(this.Context, sb.ToString());
        }
        public override void CloseReport()
        {
            //删除临时表
            if (TempTableName == null || TempTableName.Length == 0)
            {
                return;
            }
            IDBService dBService = ServiceHelper.GetService<IDBService>();
            dBService.DeleteTemporaryTableName(this.Context, TempTableName);
            base.CloseReport();
        }
    }
}

