﻿using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;

namespace LQKJ.K3.ENG.BOMSelect.BusinessPlugIn
{
    [HotUpdate]
    [Description("BOM查询")]
    public class BOMSelectPlugIn: AbstractListPlugIn
    {
        
        public override void BarItemClick(BarItemClickEventArgs e)
        {
            base.BarItemClick(e);
            if (e.BarItemKey == "LQKJ_BOM")
            {
                string sql = string.Format(@"/*dialect*/
                                            select FNUMBER from (
                                            select t2.FMASTERID,max(F_LQKJ_CHECKBOX) F_LQKJ_CHECKBOX from T_ENG_BOM t1
                                            left join T_BD_MATERIAL t2 on t1.FMATERIALID=t2.FMATERIALID
                                            group by t2.FMASTERID ) t1
                                            left join T_BD_MATERIAL t3 on t3.FMATERIALID=t1.FMASTERID where F_LQKJ_CHECKBOX=0");
                DataTable dt = DBUtils.ExecuteDataSet(this.Context, sql).Tables[0];
                string title = "";
                if (dt.Rows.Count > 0)
                {
                    foreach (DataRow item in dt.Rows)
                    {
                        title += item["FNUMBER"].ToString() + " ， ";
                    }
                    //this.View.ShowErrMessage("暂未维护：" + title, action: (result) s=>
                    //{
                    //    this.View.Close();
                    //});
                    this.View.ShowErrMessage("未维护的成品：" + title);
                }
                else
                {
                    this.View.ShowMessage("所有BOM已经维护");
                }     
            }
        }
    }
}
