﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.Bill.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Log;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;

namespace LQKJ.K3.ENG.BOMSelect.ServersPlugIn
{
    [HotUpdate, Description("保存服务插件")]

    public class BOMSavePlugIn : AbstractOperationServicePlugIn
    {
        public static string type = "保存";
        public override void BeginOperationTransaction(BeginOperationTransactionArgs e)
        {
            Logger.Info("BeginOperationTransaction:", "保存事件开始");
            base.BeginOperationTransaction(e);
        }
        public override void EndOperationTransaction(EndOperationTransactionArgs e)//引入操作后
        {
            base.EndOperationTransaction(e);
            DynamicObject[] dynamic = e.DataEntitys;
            string title = type;
            switch (title)
            {
                case "原材料":
                    YuanCaiLiao(dynamic);
                    break;
                case "半成品":
                    BanChengPin(dynamic);
                    break;
                case "成品":
                    ChengPin(dynamic);
                    break;
                case "保存":
                    BaoCun(dynamic);
                    break;
            }
        }
        private void ChengPin(DynamicObject[] dynamic)//成品  只更新物料
        {
            List<SqlObject> sqlObjects = new List<SqlObject>();
            for (int i = 0; i < dynamic.Length; i++)
            {
                string sql = "";
                string id = dynamic[i]["F_LQKJ_Material_Id"].ToString();//ID
                string date = (dynamic[i]["F_LQKJ_DATE"].ToString());//获取日期
                double price = Convert.ToDouble(dynamic[i]["F_LQKJ_Amount"].ToString());//价格
                sql = string.Format(@"/*dialect*/  update T_BD_MATERIAL set F_ZTW_PRICE1={0} from T_BD_MATERIAL a 
                                                     left join  T_LQKJ_MaterialPrice b on  a.FMASTERID=b.F_LQKJ_MATERIAL where a.FMASTERID in 
                                                    (select FMASTERID from T_BD_MATERIAL where FMATERIALID={1})", price, Convert.ToInt32(id));
                sqlObjects.Add(new SqlObject(sql, new List<SqlParam>()));
            }
            DBUtils.ExecuteBatch(this.Context, sqlObjects);
        }
        private void BanChengPin(DynamicObject[] dynamic)//半成品  更新物料—更新相关BOM，再更新物料，计划单价
        {
            List<SqlObject> sqlObjects1 = new List<SqlObject>();
            string date = (dynamic[0]["F_LQKJ_DATE"].ToString());//获取日期,如果不是最新日期需要用临时表
            string date1 = date.Split('-')[0];//年
            string date2 = date.Split('-')[1];//月
            if ((int.Parse(date2) != DateTime.Now.Month - 1 && int.Parse(date1) == DateTime.Now.Year) || (int.Parse(date2) == DateTime.Now.Month - 1 && int.Parse(date1) != DateTime.Now.Year))//判断是否是最新的日期，不是的话就新建临时表
            {
                string sql2 = @"/*dialect*/ select *   into #T_ENG_BOM from T_ENG_BOM 
                                            select * into #T_ENG_BOMCHILD FROM T_ENG_BOMCHILD
                                            select *   into #T_BD_MATERIAL from T_BD_MATERIAL";
                DBUtils.Execute(this.Context, sql2).ToString();//新建临时表
                for (int i = 0; i < dynamic.Length; i++)
                {
                    string id = dynamic[i]["F_LQKJ_Material_Id"].ToString();//ID
                    double price = Convert.ToDouble(dynamic[i]["F_LQKJ_Amount"].ToString());//价格                                        
                    string sql = string.Format($@"/*dialect*/
                                                    --将当前修改月的所有数据更新到物料备份表中
                                                    update #T_BD_MATERIAL set F_ZTW_PRICE1='{price}' from
                                                    #T_BD_MATERIAL t1 inner join(select  FMASTERID,FMATERIALID,ISNULL(F_LQKJ_AMOUNT,0) F_LQKJ_AMOUNT from #T_BD_MATERIAL t1 left join 
                                                    (select * from T_LQKJ_MaterialPrice where F_LQKJ_DATE ='{date}') t2 on t1.FMASTERID=t2.F_LQKJ_MATERIAL) t2 on t1.FMATERIALID=t2.FMATERIALID

                                                    --重新计算相关BOM到BOM备份表
                                                    update  #T_ENG_BOM set F_LQKJ_PRICE=t2.FPRICE
                                                    from #T_ENG_BOM t1 INNER JOIN( select round(FPRICE/tbom.FQTY,4) FPRICE,tbom.FID from #T_ENG_BOM tbom inner join (
                                                    select sum(t2.FNUMERATOR/t2.FDENOMINATOR*isnull(t3.F_ZTW_PRICE1,0)/t6.FCONVERTDENOMINATOR/t6.FCONVERTNUMERATOR*t7.FCONVERTNUMERATOR*t7.FCONVERTDENOMINATOR) AS FPRICE,t1.FID from #T_ENG_BOM t1
                                                    inner join #T_ENG_BOMCHILD t2 on t1.FID=t2.FID
                                                    inner join #T_BD_MATERIAL t3 on t3.FMATERIALID=t2.FMATERIALID
                                                    inner join t_bd_MaterialPurchase t3_Purchase on t3.FMATERIALID=t3_Purchase.FMATERIALID
                                                    inner join #T_BD_MATERIAL t4 on t4.FMATERIALID=t1.FMATERIALID 
                                                    inner join T_BD_UNITCONVERTRATE t6 on t6.FCURRENTUNITID=t2.FUNITID
                                                    inner join T_BD_UNITCONVERTRATE t7 on t7.FCURRENTUNITID=t3_Purchase.FPURCHASEUNITID
                                                    left join(select FID,t1.FMATERIALID from #T_ENG_BOMCHILD t1 left join #T_BD_MATERIAL t2 on t1.FMATERIALID=t2.FMATERIALID 
								                    where t2.FMASTERID in(select FMASTERID from #T_BD_MATERIAL where FMATERIALID =({id}))) t8 on t8.FID=t2.FID 
					                                WHERE T4.FMASTERID!=111914 and t8.FID is not null
					                                group by t1.FID 
                                                    ) t2 ON tbom.FID=T2.FID )T2 ON T1.FID=T2.FID
                                                    
                                                    --重新计算的BOM价格更新到物料备份表中
                                                    update #T_BD_MATERIAL set F_ZTW_PRICE1=F_LQKJ_PRICE from #T_BD_MATERIAL t1 
                                                    left join (select t1.FMATERIALID,t4.FMASTERID,t1.F_LQKJ_CHECKBOX,F_LQKJ_PRICE 
                                                    from #T_ENG_BOM t1 left join #T_ENG_BOMCHILD t2 on t1.FID=t2.FID
                                                    left join #T_BD_MATERIAL t3 on t3.FMATERIALID=t2.FMATERIALID
                                                    left join #T_BD_MATERIAL t4 on t4.FMATERIALID=t1.FMATERIALID
                                                    where t3.FMASTERID IN (SELECT FMASTERID from #T_BD_MATERIAL where FMATERIALID in({id})) 
                                                    and t1.F_LQKJ_CHECKBOX=1) t2 on t1.FMASTERID=t2.FMASTERID where t2.FMATERIALID is not null

                                                    --重新计算后的最终结果更新到计划单价表中
                                                    update T_LQKJ_MaterialPrice set F_LQKJ_AMOUNT=F_ZTW_PRICE1
                                                    from T_LQKJ_MaterialPrice t1 left join 
                                                    (select FMASTERID,max(F_ZTW_PRICE1) F_ZTW_PRICE1 from #T_BD_MATERIAL where F_ZTW_PRICE1>0 group by FMASTERID) t2 on t2.FMASTERID=t1.F_LQKJ_MATERIAL
                                                    where t1.F_LQKJ_DATE='{date}' and t2.FMASTERID is not null");
                    sqlObjects1.Add(new SqlObject(sql, new List<SqlParam>()));
                }
            }
            else
            {
                for (int i = 0; i < dynamic.Length; i++)
                {
                    string sql = "";
                    string id = dynamic[i]["F_LQKJ_Material_Id"].ToString();//ID
                    double price = Convert.ToDouble(dynamic[i]["F_LQKJ_Amount"].ToString());//价格       //将引入的物料计划单价修改到物料表中
                    sql = string.Format($@"/*dialect*/ update T_BD_MATERIAL set F_ZTW_PRICE1='{price}' from T_BD_MATERIAL a 
                                                left join  T_LQKJ_MaterialPrice b on  a.FMASTERID=b.F_LQKJ_MATERIAL where a.FMASTERID 
                                                in (select FMASTERID from T_BD_MATERIAL where FMATERIALID='{id}')

                                                update  T_ENG_BOM set F_LQKJ_PRICE=t2.FPRICE from T_ENG_BOM t1 INNER JOIN( 
					                            select round(FPRICE/tbom.FQTY,4) FPRICE,tbom.FID from T_ENG_BOM tbom inner join (
					                            select sum(t2.FNUMERATOR/t2.FDENOMINATOR*isnull(t3.F_ZTW_PRICE1,0)/t6.FCONVERTDENOMINATOR/t6.FCONVERTNUMERATOR*t7.FCONVERTNUMERATOR*t7.FCONVERTDENOMINATOR) AS FPRICE,t1.FID from T_ENG_BOM t1
					                            inner join T_ENG_BOMCHILD t2 on t1.FID=t2.FID
					                            inner join T_BD_MATERIAL t3 on t3.FMATERIALID=t2.FMATERIALID
					                            inner join T_BD_MATERIALPurchase t3_Purchase on t3.FMATERIALID=t3_Purchase.FMATERIALID
					                            inner join T_BD_MATERIAL t4 on t4.FMATERIALID=t1.FMATERIALID 
					                            inner join T_BD_UNITCONVERTRATE t6 on t6.FCURRENTUNITID=t2.FUNITID
					                            inner join T_BD_UNITCONVERTRATE t7 on t7.FCURRENTUNITID=t3_Purchase.FPURCHASEUNITID
					                            left join(select FID,t1.FMATERIALID from T_ENG_BOMCHILD t1 left join T_BD_MATERIAL t2 on t1.FMATERIALID=t2.FMATERIALID 
								                            where t2.FMASTERID in(select FMASTERID from T_BD_MATERIAL where FMATERIALID =('{id}'))) t8 on t8.FID=t2.FID 
					                            WHERE T4.FMASTERID!=111914 and t8.FID is not null
					                            group by t1.FID 
				                             ) t2 ON tbom.FID=T2.FID )T2 ON T1.FID=T2.FID 

                                                update T_BD_MATERIAL set F_ZTW_PRICE1= t2.price
				                                 from T_BD_MATERIAL t1 inner join 
				                                 (
					                                SELECT max(F_LQKJ_PRICE) price,t2.FMASTERID FROM T_ENG_BOM T1 
					                                LEFT JOIN T_BD_MATERIAL T2 ON T1.FMATERIALID=T2.FMATERIALID 
					                                where t2.FMASTERID!=111914 AND T1.F_LQKJ_CHECKBOX=1 group by t2.FMASTERID 
				                                 ) t2 on t1.FMASTERID=t2.FMASTERID where t1.FMASTERID not in(select FMASTERID from T_BD_MATERIAL where FMATERIALID={1})

                                          	    update T_LQKJ_MaterialPrice set F_LQKJ_AMOUNT=B.F_ZTW_PRICE1  
				                                from T_LQKJ_MaterialPrice A
				                                left join (select max(F_ZTW_PRICE1) F_ZTW_PRICE1,FMASTERID from T_BD_MATERIAL group by FMASTERID) b ON A.F_LQKJ_MATERIAL=B.FMASTERID
				                                where b.F_ZTW_PRICE1>0 and b.FMASTERID = a.F_LQKJ_MATERIAL and a.F_LQKJ_MATERIAL!='{id}' and F_LQKJ_DATE='{date}'");//这里需要多写一步日期过滤
                    sqlObjects1.Add(new SqlObject(sql, new List<SqlParam>()));
                }
            }
            DBUtils.ExecuteBatch(this.Context, sqlObjects1);
            sqlObjects1.Clear();
        }
        private void YuanCaiLiao(DynamicObject[] dynamic)//原材料  更新物料—更新BOM，更新物料-更新计划单价
        {
            List<SqlObject> sqlObjects1 = new List<SqlObject>();
            //List<SqlObject> sqlObjects2 = new List<SqlObject>();
            string date = (dynamic[0]["F_LQKJ_DATE"].ToString());//获取日期
            string n1 = "T_BD_MATERIAL", n2 = "T_ENG_BOM";
            string date1 = date.Split('-')[0];//年
            string date2 = date.Split('-')[1];//月
            if ((int.Parse(date2) != DateTime.Now.Month - 1 && int.Parse(date1) == DateTime.Now.Year) || (int.Parse(date2) == DateTime.Now.Month - 1 && int.Parse(date1) != DateTime.Now.Year))
                //如果不是最新的日期,就创建临时表
            {
                string sql2 = @"/*dialect*/ select *   into #T_ENG_BOM from T_ENG_BOM 
                                            select * into #T_ENG_BOMCHILD FROM T_ENG_BOMCHILD
                                            select *   into #T_BD_MATERIAL from T_BD_MATERIAL";
                DBUtils.Execute(this.Context, sql2).ToString();//新建临时表
                for (int i = 0; i < dynamic.Length; i++)
                {
                    string id = dynamic[i]["F_LQKJ_Material_Id"].ToString();//ID
                    double price = Convert.ToDouble(dynamic[i]["F_LQKJ_Amount"].ToString());//价格                                        
                    string sql = string.Format($@"/*dialect*/
                                                    --将当前修改月的所有数据更新到物料备份表中
                                                    update #T_BD_MATERIAL set F_ZTW_PRICE1='{price}' from
                                                    #T_BD_MATERIAL t1 inner join(select  FMASTERID,FMATERIALID,ISNULL(F_LQKJ_AMOUNT,0) F_LQKJ_AMOUNT from #T_BD_MATERIAL t1 left join 
                                                    (select * from T_LQKJ_MaterialPrice where F_LQKJ_DATE ='{date}') t2 on t1.FMASTERID=t2.F_LQKJ_MATERIAL) t2 on t1.FMATERIALID=t2.FMATERIALID

                                                    --重新计算相关BOM到BOM备份表
                                                    update  #T_ENG_BOM set F_LQKJ_PRICE=t2.FPRICE
                                                    from #T_ENG_BOM t1 INNER JOIN( select round(FPRICE/tbom.FQTY,4) FPRICE,tbom.FID from #T_ENG_BOM tbom inner join (
                                                    select sum(t2.FNUMERATOR/t2.FDENOMINATOR*isnull(t3.F_ZTW_PRICE1,0)/t6.FCONVERTDENOMINATOR/t6.FCONVERTNUMERATOR*t7.FCONVERTNUMERATOR*t7.FCONVERTDENOMINATOR) AS FPRICE,t1.FID from #T_ENG_BOM t1
                                                    inner join #T_ENG_BOMCHILD t2 on t1.FID=t2.FID
                                                    inner join #T_BD_MATERIAL t3 on t3.FMATERIALID=t2.FMATERIALID
                                                    inner join t_bd_MaterialPurchase t3_Purchase on t3.FMATERIALID=t3_Purchase.FMATERIALID
                                                    inner join #T_BD_MATERIAL t4 on t4.FMATERIALID=t1.FMATERIALID 
                                                    inner join T_BD_UNITCONVERTRATE t6 on t6.FCURRENTUNITID=t2.FUNITID
                                                    inner join T_BD_UNITCONVERTRATE t7 on t7.FCURRENTUNITID=t3_Purchase.FPURCHASEUNITID
                                                    left join(select FID,t1.FMATERIALID from #T_ENG_BOMCHILD t1 left join #T_BD_MATERIAL t2 on t1.FMATERIALID=t2.FMATERIALID 
								                    where t2.FMASTERID in(select FMASTERID from #T_BD_MATERIAL where FMATERIALID =({id}))) t8 on t8.FID=t2.FID 
					                                WHERE T4.FMASTERID!=111914 and t8.FID is not null
					                                group by t1.FID 
                                                    ) t2 ON tbom.FID=T2.FID )T2 ON T1.FID=T2.FID
                                                    
                                                    --重新计算的BOM价格更新到物料备份表中
                                                    update #T_BD_MATERIAL set F_ZTW_PRICE1=F_LQKJ_PRICE from #T_BD_MATERIAL t1 
                                                    left join (select t1.FMATERIALID,t4.FMASTERID,t1.F_LQKJ_CHECKBOX,F_LQKJ_PRICE 
                                                    from #T_ENG_BOM t1 left join #T_ENG_BOMCHILD t2 on t1.FID=t2.FID
                                                    left join #T_BD_MATERIAL t3 on t3.FMATERIALID=t2.FMATERIALID
                                                    left join #T_BD_MATERIAL t4 on t4.FMATERIALID=t1.FMATERIALID
                                                    where t3.FMASTERID IN (SELECT FMASTERID from #T_BD_MATERIAL where FMATERIALID in({id})) 
                                                    and t1.F_LQKJ_CHECKBOX=1) t2 on t1.FMASTERID=t2.FMASTERID where t2.FMATERIALID is not null

                                                    --重新计算后的最终结果更新到计划单价表中
                                                    update T_LQKJ_MaterialPrice set F_LQKJ_AMOUNT=F_ZTW_PRICE1
                                                    from T_LQKJ_MaterialPrice t1 left join 
                                                    (select FMASTERID,max(F_ZTW_PRICE1) F_ZTW_PRICE1 from #T_BD_MATERIAL where F_ZTW_PRICE1>0 group by FMASTERID) t2 on t2.FMASTERID=t1.F_LQKJ_MATERIAL
                                                    where t1.F_LQKJ_DATE='{date}' and t2.FMASTERID is not null");
                    sqlObjects1.Add(new SqlObject(sql, new List<SqlParam>()));
                }
            }
            else
            {
                for (int i = 0; i < dynamic.Length; i++)
                {
                    string sql = "";
                    string id = dynamic[i]["F_LQKJ_Material_Id"].ToString();//ID
                    double price = Convert.ToDouble(dynamic[i]["F_LQKJ_Amount"].ToString());//价格       //将引入的物料计划单价修改到物料表中
                    sql = string.Format($@"/*dialect*/ update T_BD_MATERIAL set F_ZTW_PRICE1='{price}' from T_BD_MATERIAL a 
                                                left join  T_LQKJ_MaterialPrice b on  a.FMASTERID=b.F_LQKJ_MATERIAL where a.FMASTERID 
                                                in (select FMASTERID from T_BD_MATERIAL where FMATERIALID='{id}')

                                                update  T_ENG_BOM set F_LQKJ_PRICE=t2.FPRICE from T_ENG_BOM t1 INNER JOIN( 
					                            select round(FPRICE/tbom.FQTY,4) FPRICE,tbom.FID from T_ENG_BOM tbom inner join (
					                            select sum(t2.FNUMERATOR/t2.FDENOMINATOR*isnull(t3.F_ZTW_PRICE1,0)/t6.FCONVERTDENOMINATOR/t6.FCONVERTNUMERATOR*t7.FCONVERTNUMERATOR*t7.FCONVERTDENOMINATOR) AS FPRICE,t1.FID from T_ENG_BOM t1
					                            inner join T_ENG_BOMCHILD t2 on t1.FID=t2.FID
					                            inner join T_BD_MATERIAL t3 on t3.FMATERIALID=t2.FMATERIALID
					                            inner join T_BD_MATERIALPurchase t3_Purchase on t3.FMATERIALID=t3_Purchase.FMATERIALID
					                            inner join T_BD_MATERIAL t4 on t4.FMATERIALID=t1.FMATERIALID 
					                            inner join T_BD_UNITCONVERTRATE t6 on t6.FCURRENTUNITID=t2.FUNITID
					                            inner join T_BD_UNITCONVERTRATE t7 on t7.FCURRENTUNITID=t3_Purchase.FPURCHASEUNITID
					                            left join(select FID,t1.FMATERIALID from T_ENG_BOMCHILD t1 left join T_BD_MATERIAL t2 on t1.FMATERIALID=t2.FMATERIALID 
								                            where t2.FMASTERID in(select FMASTERID from T_BD_MATERIAL where FMATERIALID =('{id}'))) t8 on t8.FID=t2.FID 
					                            WHERE T4.FMASTERID!=111914 and t8.FID is not null
					                            group by t1.FID 
				                             ) t2 ON tbom.FID=T2.FID )T2 ON T1.FID=T2.FID 

                                                update T_BD_MATERIAL set F_ZTW_PRICE1= t2.price
				                                 from T_BD_MATERIAL t1 inner join 
				                                 (
					                                SELECT max(F_LQKJ_PRICE) price,t2.FMASTERID FROM T_ENG_BOM T1 
					                                LEFT JOIN T_BD_MATERIAL T2 ON T1.FMATERIALID=T2.FMATERIALID 
					                                where t2.FMASTERID!=111914 AND T1.F_LQKJ_CHECKBOX=1 group by t2.FMASTERID 
				                                 ) t2 on t1.FMASTERID=t2.FMASTERID where t1.FMASTERID not in(select FMASTERID from T_BD_MATERIAL where FMATERIALID={1})

                                          	    update T_LQKJ_MaterialPrice set F_LQKJ_AMOUNT=B.F_ZTW_PRICE1  
				                                from T_LQKJ_MaterialPrice A
				                                left join (select max(F_ZTW_PRICE1) F_ZTW_PRICE1,FMASTERID from T_BD_MATERIAL group by FMASTERID) b ON A.F_LQKJ_MATERIAL=B.FMASTERID
				                                where b.F_ZTW_PRICE1>0 and b.FMASTERID = a.F_LQKJ_MATERIAL and a.F_LQKJ_MATERIAL!='{id}' and F_LQKJ_DATE='{date}'");//这里需要多写一步日期过滤
                    sqlObjects1.Add(new SqlObject(sql, new List<SqlParam>()));
                }
            }
            
            int j = 0;
            while (j < 2)
            {
                DBUtils.ExecuteBatch(this.Context, sqlObjects1);
                j++;
            }
            sqlObjects1.Clear();
        }
        private void BaoCun(DynamicObject[] dynamic)
        {
            string sql = "";
            string id = dynamic[0]["F_LQKJ_Material_Id"].ToString();//ID
            double price = Convert.ToDouble(dynamic[0]["F_LQKJ_Amount"].ToString());//价格
            string date = (dynamic[0]["F_LQKJ_DATE"].ToString());//获取日期
            sql = string.Format(@"/*dialect*/  update T_BD_MATERIAL set F_ZTW_PRICE1={0} from T_BD_MATERIAL a left join 
                                        T_LQKJ_MaterialPrice b on a.FMATERIALID = b.F_LQKJ_MATERIAL where a.FMASTERID in (select FMASTERID from T_BD_MATERIAL where FMATERIALID={1})", price, Convert.ToInt32(id));
            DBUtils.Execute(this.Context, sql);
            //string sql2 = string.Format(@"/*dialect*/ 
            //                                select F_LQKJ_CREATORID,F_LQKJ_CREATEDATE  from T_BD_MATERIAL A
            //                    left join T_LQKJ_MaterialPrice b ON A.FMATERIALID=B.F_LQKJ_MATERIAL
            //                    where A.F_ZTW_PRICE1>0 and A.FMASTERID = A.FMATERIALID AND A.FMATERIALID={0}", Convert.ToInt32(id));
            //DataTable dt = DBUtils.ExecuteDataSet(this.Context, sql2).Tables[0];
            //string date = "";
            //foreach (DataRow item in dt.Rows)
            //{
            //     date = item["F_LQKJ_CREATEDATE"].ToString();
            //}
            //string name = dt.Rows[0]["F_LQKJ_CREATORID"].ToString();
            //string sql3 = string.Format(@"/*dialect*/ 
            //                update T_LQKJ_MaterialPrice set F_LQKJ_CREATORID={0},F_LQKJ_CREATEDATE='{1}'
            //                    from T_BD_MATERIAL A
            //                    left join T_LQKJ_MaterialPrice b ON A.FMATERIALID=B.F_LQKJ_MATERIAL
            //                    where A.F_ZTW_PRICE1>0 and A.FMASTERID = A.FMATERIALID AND A.FMATERIALID={2}", name, date, Convert.ToInt32(id));
            //DBUtils.Execute(this.Context, sql3);


            //for (int i = 0; i < dynamic.Length; i++)
            //{
            //    string sql = "";
            //    string id = dynamic[i]["F_LQKJ_Material_Id"].ToString();//ID
            //    double price = Convert.ToDouble(dynamic[i]["F_LQKJ_Amount"].ToString());//价格
            //    sql = string.Format(@"/*dialect*/  update {2} set F_ZTW_PRICE1={0} from {2} a 
            //                                        left join  T_LQKJ_MaterialPrice b on  a.FMASTERID=b.F_LQKJ_MATERIAL 
            //                                        where a.FMASTERID in (select FMASTERID from {2} where FMATERIALID={1})", price, Convert.ToInt32(id),n1);
            //    sqlObjects2.Add(new SqlObject(sql, new List<SqlParam>()));
            //    //DBUtils.Execute(this.Context, sql);
            //}
            //DBUtils.ExecuteBatch(this.Context, sqlObjects2);
        }
    }
}
