﻿using Kingdee.BOS;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Contracts.Report;
using Kingdee.BOS.Core.Report;
using Kingdee.BOS.Orm.DataEntity;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

namespace LQKJ.K3.ENG.BOMSelect.ServersPlugIn
{
    [Description("钯价变动分析表"), HotUpdate]
    public class BaJiaServerPlugin: SysReportBaseService
    {

		private int Year = 0;
		private int month = 1;
		public override void Initialize()
		{
			base.Initialize();
			this.ReportProperty.ReportName = new LocaleValue("钯价变动分析表", base.Context.UserLocale.LCID);
			ReportProperty.ReportType = ReportType.REPORTTYPE_NORMAL;
			this.ReportProperty.IsUIDesignerColumns = false;
			this.ReportProperty.PrimaryKeyFieldName = "FCUSTOMERID";
			base.Initialize();
		}
		public override string GetTableName()
		{
			return base.GetTableName();
		}

		public override void BuilderReportSqlAndTempTable(IRptParams filter, string tableName)
		{
			string seqFld = string.Format(base.KSQL_SEQ, " T.FCUSTOMERID ");
			DynamicObject dyFilter = filter.FilterParameter.CustomFilter;
			
			var keySet = dyFilter.DynamicObjectType.Properties;//过滤框的所有属性
			DynamicObject ProductsName = dyFilter["F_LQKJ_FItem"] as DynamicObject;
			string Name = "";
			if (ProductsName != null)
			{
				Name = ProductsName["FDataValue"].ToString();
			}
			string FDate = "";
			if (dyFilter["F_LQKJ_FDATE"] != null)
			{
				FDate = dyFilter["F_LQKJ_FDATE"].ToString();
			}
			if (FDate == "")
			{
				Year = DateTime.Now.Year;
			}
			else
			{
				Year = Convert.ToInt32(FDate);
			}
			string sql = string.Format(@"/*dialect*/
												SELECT *,{0} into {1} FROM (
												select  D.FNAME,FCUSTOMERID,FREMARK,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='01'THEN CONVERT(DECIMAL(23,4),FAREA) ELSE 0 END),0)  AS FAREA1,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='01'THEN CONVERT(DECIMAL(23,4),B.FPRICE) ELSE 0 END),0)  AS FPRICE1,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='02'THEN CONVERT(DECIMAL(23,4),FAREA) ELSE 0 END),0)  AS FAREA2,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='02'THEN CONVERT(DECIMAL(23,4),B.FPRICE) ELSE 0 END),0)  AS FPRICE2,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='03'THEN CONVERT(DECIMAL(23,4),FAREA) ELSE 0 END),0)  AS FAREA3,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='03'THEN CONVERT(DECIMAL(23,4),B.FPRICE) ELSE 0 END),0)  AS FPRICE3,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='04'THEN CONVERT(DECIMAL(23,4),FAREA) ELSE 0 END),0)  AS FAREA4,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='04'THEN CONVERT(DECIMAL(23,4),B.FPRICE) ELSE 0 END),0)  AS FPRICE4,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='05'THEN CONVERT(DECIMAL(23,4),FAREA) ELSE 0 END),0)  AS FAREA5,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='05'THEN CONVERT(DECIMAL(23,4),B.FPRICE) ELSE 0 END),0)  AS FPRICE5,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='06'THEN CONVERT(DECIMAL(23,4),FAREA) ELSE 0 END),0)  AS FAREA6,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='06'THEN CONVERT(DECIMAL(23,4),B.FPRICE) ELSE 0 END),0)  AS FPRICE6,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='07'THEN CONVERT(DECIMAL(23,4),FAREA) ELSE 0 END),0)  AS FAREA7,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='07'THEN CONVERT(DECIMAL(23,4),B.FPRICE) ELSE 0 END),0)  AS FPRICE7,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='08'THEN CONVERT(DECIMAL(23,4),FAREA) ELSE 0 END),0)  AS FAREA8,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='08'THEN CONVERT(DECIMAL(23,4),B.FPRICE) ELSE 0 END),0)  AS FPRICE8,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='09'THEN CONVERT(DECIMAL(23,4),FAREA) ELSE 0 END),0)  AS FAREA9,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='09'THEN CONVERT(DECIMAL(23,4),B.FPRICE) ELSE 0 END),0)  AS FPRICE9,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='10'THEN CONVERT(DECIMAL(23,4),FAREA) ELSE 0 END),0)  AS FAREA10,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='10'THEN CONVERT(DECIMAL(23,4),B.FPRICE) ELSE 0 END),0)  AS FPRICE10,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='11'THEN CONVERT(DECIMAL(23,4),FAREA) ELSE 0 END),0)  AS FAREA11,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='11'THEN CONVERT(DECIMAL(23,4),B.FPRICE) ELSE 0 END),0)  AS FPRICE11,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='12'THEN CONVERT(DECIMAL(23,4),FAREA) ELSE 0 END),0)  AS FAREA12,
												nullif(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)='12'THEN CONVERT(DECIMAL(23,4),B.FPRICE) ELSE 0 END),0)  AS FPRICE12,
												nullif(CONVERT(DECIMAL(23,4),(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)=SUBSTRING(FORMAT(GetDate(),'yyyyMM'),5,2)THEN B.FPRICE ELSE 0 END)-SUM(CASE WHEN FMONTH=CONVERT(INT,FORMAT(GetDate(),'yyyyMM'))-1 THEN B.FPRICE ELSE 0 END))),0)  AS FPRICESUB,
												nullif(CONVERT(DECIMAL(23,4),(SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)=SUBSTRING(FORMAT(GetDate(),'yyyyMM'),5,2)THEN B.FPRICE ELSE 0 END)*SUM(CASE WHEN SUBSTRING(CONVERT(nvarchar(20),FMONTH),5,2)=SUBSTRING(FORMAT(GetDate(),'yyyyMM'),5,2)THEN FAREA ELSE 0 END)-
												SUM(CASE WHEN FMONTH=CONVERT(INT,FORMAT(GetDate(),'yyyyMM'))-1 THEN B.FPRICE ELSE 0 END)*SUM(CASE WHEN FMONTH=CONVERT(INT,FORMAT(GetDate(),'yyyyMM'))-1 THEN FAREA ELSE 0 END))),0) AS PRICECHANGE
												from ZTW_StockBill A left join ztw_StockBillItem  B ON A.FID=B.FID left join T_BAS_ASSISTANTDATAENTRY_L C ON B.FITEMTYPE=C.FENTRYID
												left join T_BD_CUSTOMER_L D ON A.FCUSTOMERID=D.FCUSTID and D.FLOCALEID=2052
												LEFT JOIN ztw_StockBillEntry3 E ON E.FID=A.FID
												where C.FDATAVALUE like '%{2}%'
												and CONVERT(VARCHAR(10),FMONTH) LIKE '%{3}%'
												group by D.FNAME,FCUSTOMERID,FREMARK) T
														", seqFld, tableName,Name, FDate);//表名
			DBUtils.ExecuteDynamicObject(this.Context, sql);
			base.BuilderReportSqlAndTempTable(filter, tableName);
		}
		public override ReportHeader GetReportHeaders(IRptParams filter)
		{
			//return base.GetReportHeaders(filter);
			ReportHeader header = new ReportHeader();
			var fname = header.AddChild("FNAME", new LocaleValue("客户名"));
			fname.ColIndex = 0;
			if (Year < DateTime.Now.Year)//小于当前年
			{
				month = 12;
			}
			else if (Year == DateTime.Now.Year)//等于当前年
			{
				month = DateTime.Now.Month;
			}
			int i = 1;
			for (; i <= month; i++)//选择年份来判断显示几个月
			{
				header.AddChild("FPRICE" + i.ToString(), new LocaleValue(i.ToString() + "月单价")).ColIndex = i;
				header.AddChild("FAREA" + i.ToString(), new LocaleValue(i.ToString() + "月面积")).ColIndex = i;
				
			}
			var priceSub = header.AddChild("FPRICESUB", new LocaleValue("单价差异"));
			var priceChange = header.AddChild("PRICECHANGE", new LocaleValue("变动金额"));
			var FREMARK = header.AddChild("FREMARK", new LocaleValue("备注"));
			return header;
		}
		//数据列汇总
		public override List<SummaryField> GetSummaryColumnInfo(IRptParams filter)
		{
			var result = base.GetSummaryColumnInfo(filter);
			for (int i = 1; i <= month; i++)
			{
				result.Add(new SummaryField("FAREA" + i.ToString(), Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));
				result.Add(new SummaryField("FPRICE" + i.ToString(), Kingdee.BOS.Core.Enums.BOSEnums.Enu_SummaryType.SUM));
			}
			return result;
		}

		protected override string GetIdentityFieldIndexSQL(string tableName)
		{
			string result = base.GetIdentityFieldIndexSQL(tableName);
			return result;
		}
		protected override void ExecuteBatch(List<string> listSql)
		{
			base.ExecuteBatch(listSql);
		}

		protected override void AfterCreateTempTable(string tablename)
		{
			base.AfterCreateTempTable(tablename);
		}
	}
}
