﻿using Kingdee.BOS.Core.DynamicForm.PlugIn;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Util;
using Kingdee.BOS.Orm.DataEntity;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Data;
using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.Validation;

namespace LQKJ.K3.ENG.BOMSelect.ServersPlugIn
{
    [HotUpdate]
    [Description("BOM")]
    public class BOMSelectPlugIn:AbstractOperationServicePlugIn
    {
        public override void BeforeExecuteOperationTransaction(BeforeExecuteOperationTransaction e)
        {
            base.BeforeExecuteOperationTransaction(e);
            var Data = e.SelectedRows as dynamic;
            string MaterialID = e.SelectedRows.ToArray()[0].DataEntity["MATERIALID_Id"].ToString();
            string sql = string.Format("select A.FMATERIALID,A.FNUMBER from T_ENG_BOM A LEFT JOIN T_BD_MATERIAL B on A.FMATERIALID=B.FMATERIALID " +
                                      "WHERE F_LQKJ_CHECKBOX1=1 AND A.FMATERIALID={0}",MaterialID);
            DataTable dt = DBUtils.ExecuteDataSet(this.Context, sql).Tables[0];
            if (dt.Rows.Count > 0)//返回有数据的话代表已经有BOM勾选过的
            {
                var number = dt.Rows[0]["FNUMBER"].ToString();
                e.CancelMessage = number + "已勾选为成品统一计划单价";
                e.Cancel = true;
            }
        }
    }
}
