﻿using Kingdee.BOS.App.Data;
using Kingdee.BOS.Core.DynamicForm.PlugIn.Args;
using Kingdee.BOS.Core.List.PlugIn;
using Kingdee.BOS.Util;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;

namespace LQKJ.K3.ENG.BOMSelect.BusinessPlugIn
{
    [HotUpdate]
    [Description("BOM")]
    public class BOMSelectPlugIn: AbstractListPlugIn
    {
        
        public override void BarItemClick(BarItemClickEventArgs e)
        {
            base.BarItemClick(e);
            if (e.BarItemKey == "LQKJ_BOM")
            {
                string sql = "SELECT B.FNAME FROM T_ENG_BOM A LEFT JOIN T_BD_MATERIAL_L B ON A.FMATERIALID=B.FMATERIALID WHERE  F_LQKJ_CHECKBOX=0 GROUP BY A.FMATERIALID,B.FNAME";
                DataTable dt = DBUtils.ExecuteDataSet(this.Context, sql).Tables[0];
                string title = "";
                if (dt.Rows.Count >= 0)
                {
                    foreach (DataRow item in dt.Rows)
                    {
                        title += item["FNAME"].ToString() + " ， ";
                    }
                    //this.View.ShowErrMessage("暂未维护：" + title, action: (result) s=>
                    //{
                    //    this.View.Close();
                    //});
                    this.View.ShowErrMessage("未维护的成品：" + title);
                }
                else
                {
                    this.View.ShowMessage("所有BOM已经维护");
                }
                
            }
        }
    }
}
